/*
 * Criteo API Transition Swagger
 * This is used to help Criteo clients transition from MAPI to Criteo API
 *
 * The version of the OpenAPI document: 1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.criteo.marketing.api;

import com.criteo.marketing.ApiCallback;
import com.criteo.marketing.ApiClient;
import com.criteo.marketing.ApiException;
import com.criteo.marketing.ApiResponse;
import com.criteo.marketing.Configuration;
import com.criteo.marketing.Pair;
import com.criteo.marketing.ProgressRequestBody;
import com.criteo.marketing.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.criteo.marketing.model.CampaignBidChangeRequest;
import com.criteo.marketing.model.CampaignBidChangeResponseMessageWithDetails;
import com.criteo.marketing.model.CampaignBidMessage;
import com.criteo.marketing.model.CampaignMessage;
import com.criteo.marketing.model.CategoryMessage;
import com.criteo.marketing.model.RequestAdSetSearch;
import com.criteo.marketing.model.RequestsAdSetId;
import com.criteo.marketing.model.RequestsPatchAdSet;
import com.criteo.marketing.model.ResponseAdSetId;
import com.criteo.marketing.model.ResponseReadAdSet;
import com.criteo.marketing.model.ResponsesAdSetId;
import com.criteo.marketing.model.ResponsesReadAdSet;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CampaignApi {
    private ApiClient localVarApiClient;

    public CampaignApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CampaignApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getAdSet
     * @param adSetId Id of the ad set (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> data for the ad set </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> The API client is not properly authenticated. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The API client is not authorized to access this resource or the resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAdSetCall(String adSetId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2021-04/marketing-solutions/ad-sets/{adSetId}"
            .replaceAll("\\{" + "adSetId" + "\\}", localVarApiClient.escapeString(adSetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "text/plain", "application/json", "text/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "Authorization" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAdSetValidateBeforeCall(String adSetId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'adSetId' is set
        if (adSetId == null) {
            throw new ApiException("Missing the required parameter 'adSetId' when calling getAdSet(Async)");
        }
        

        okhttp3.Call localVarCall = getAdSetCall(adSetId, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get the data for the specified ad set
     * @param adSetId Id of the ad set (required)
     * @return ResponseReadAdSet
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> data for the ad set </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> The API client is not properly authenticated. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The API client is not authorized to access this resource or the resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ResponseReadAdSet getAdSet(String adSetId) throws ApiException {
        ApiResponse<ResponseReadAdSet> localVarResp = getAdSetWithHttpInfo(adSetId);
        return localVarResp.getData();
    }

    /**
     * 
     * Get the data for the specified ad set
     * @param adSetId Id of the ad set (required)
     * @return ApiResponse&lt;ResponseReadAdSet&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> data for the ad set </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> The API client is not properly authenticated. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The API client is not authorized to access this resource or the resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ResponseReadAdSet> getAdSetWithHttpInfo(String adSetId) throws ApiException {
        okhttp3.Call localVarCall = getAdSetValidateBeforeCall(adSetId, null);
        Type localVarReturnType = new TypeToken<ResponseReadAdSet>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get the data for the specified ad set
     * @param adSetId Id of the ad set (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> data for the ad set </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> The API client is not properly authenticated. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The API client is not authorized to access this resource or the resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAdSetAsync(String adSetId, final ApiCallback<ResponseReadAdSet> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAdSetValidateBeforeCall(adSetId, _callback);
        Type localVarReturnType = new TypeToken<ResponseReadAdSet>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getBids
     * @param campaignIds Optional. The ids of the campaigns we want to get the bids on. If not specified, advertiserIds will be used. (optional)
     * @param advertiserIds Optional. The ids of the advertisers&#39; campaigns we want to get the bids on. If campaignIds not specified, and neither is advertiserIds, all the advertisers in the user&#39;s portfolio are used. (optional)
     * @param categoryHashCodes Optional. Filters only specified categories. By default no filtering is applied. (optional)
     * @param bidType Optional. Filters by bid type. By default no filtering is applied. (optional)
     * @param campaignStatus Optional. Filters by campaign status. By default no filtering is applied. (optional)
     * @param pendingChanges Optional. Filters only pending changes or settled ones. By default no filtering is applied. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Bids returned OK. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> There is not even one valid advertiserId or campaignId requested. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBidsCall(String campaignIds, String advertiserIds, String categoryHashCodes, String bidType, String campaignStatus, Boolean pendingChanges, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/legacy/marketing/v1/campaigns/bids";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (campaignIds != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("campaignIds", campaignIds));
        }

        if (advertiserIds != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("advertiserIds", advertiserIds));
        }

        if (categoryHashCodes != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("categoryHashCodes", categoryHashCodes));
        }

        if (bidType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("bidType", bidType));
        }

        if (campaignStatus != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("campaignStatus", campaignStatus));
        }

        if (pendingChanges != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pendingChanges", pendingChanges));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json", "text/json", "application/xml", "text/xml", "text/html"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "Authorization" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getBidsValidateBeforeCall(String campaignIds, String advertiserIds, String categoryHashCodes, String bidType, String campaignStatus, Boolean pendingChanges, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getBidsCall(campaignIds, advertiserIds, categoryHashCodes, bidType, campaignStatus, pendingChanges, _callback);
        return localVarCall;

    }

    /**
     * Gets a the bids for campaigns and their categories
     * Get the campaigns&#39; bids, as well as the bids of their categories
     * @param campaignIds Optional. The ids of the campaigns we want to get the bids on. If not specified, advertiserIds will be used. (optional)
     * @param advertiserIds Optional. The ids of the advertisers&#39; campaigns we want to get the bids on. If campaignIds not specified, and neither is advertiserIds, all the advertisers in the user&#39;s portfolio are used. (optional)
     * @param categoryHashCodes Optional. Filters only specified categories. By default no filtering is applied. (optional)
     * @param bidType Optional. Filters by bid type. By default no filtering is applied. (optional)
     * @param campaignStatus Optional. Filters by campaign status. By default no filtering is applied. (optional)
     * @param pendingChanges Optional. Filters only pending changes or settled ones. By default no filtering is applied. (optional)
     * @return List&lt;CampaignBidMessage&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Bids returned OK. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> There is not even one valid advertiserId or campaignId requested. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public List<CampaignBidMessage> getBids(String campaignIds, String advertiserIds, String categoryHashCodes, String bidType, String campaignStatus, Boolean pendingChanges) throws ApiException {
        ApiResponse<List<CampaignBidMessage>> localVarResp = getBidsWithHttpInfo(campaignIds, advertiserIds, categoryHashCodes, bidType, campaignStatus, pendingChanges);
        return localVarResp.getData();
    }

    /**
     * Gets a the bids for campaigns and their categories
     * Get the campaigns&#39; bids, as well as the bids of their categories
     * @param campaignIds Optional. The ids of the campaigns we want to get the bids on. If not specified, advertiserIds will be used. (optional)
     * @param advertiserIds Optional. The ids of the advertisers&#39; campaigns we want to get the bids on. If campaignIds not specified, and neither is advertiserIds, all the advertisers in the user&#39;s portfolio are used. (optional)
     * @param categoryHashCodes Optional. Filters only specified categories. By default no filtering is applied. (optional)
     * @param bidType Optional. Filters by bid type. By default no filtering is applied. (optional)
     * @param campaignStatus Optional. Filters by campaign status. By default no filtering is applied. (optional)
     * @param pendingChanges Optional. Filters only pending changes or settled ones. By default no filtering is applied. (optional)
     * @return ApiResponse&lt;List&lt;CampaignBidMessage&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Bids returned OK. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> There is not even one valid advertiserId or campaignId requested. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<CampaignBidMessage>> getBidsWithHttpInfo(String campaignIds, String advertiserIds, String categoryHashCodes, String bidType, String campaignStatus, Boolean pendingChanges) throws ApiException {
        okhttp3.Call localVarCall = getBidsValidateBeforeCall(campaignIds, advertiserIds, categoryHashCodes, bidType, campaignStatus, pendingChanges, null);
        Type localVarReturnType = new TypeToken<List<CampaignBidMessage>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Gets a the bids for campaigns and their categories (asynchronously)
     * Get the campaigns&#39; bids, as well as the bids of their categories
     * @param campaignIds Optional. The ids of the campaigns we want to get the bids on. If not specified, advertiserIds will be used. (optional)
     * @param advertiserIds Optional. The ids of the advertisers&#39; campaigns we want to get the bids on. If campaignIds not specified, and neither is advertiserIds, all the advertisers in the user&#39;s portfolio are used. (optional)
     * @param categoryHashCodes Optional. Filters only specified categories. By default no filtering is applied. (optional)
     * @param bidType Optional. Filters by bid type. By default no filtering is applied. (optional)
     * @param campaignStatus Optional. Filters by campaign status. By default no filtering is applied. (optional)
     * @param pendingChanges Optional. Filters only pending changes or settled ones. By default no filtering is applied. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Bids returned OK. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> There is not even one valid advertiserId or campaignId requested. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBidsAsync(String campaignIds, String advertiserIds, String categoryHashCodes, String bidType, String campaignStatus, Boolean pendingChanges, final ApiCallback<List<CampaignBidMessage>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getBidsValidateBeforeCall(campaignIds, advertiserIds, categoryHashCodes, bidType, campaignStatus, pendingChanges, _callback);
        Type localVarReturnType = new TypeToken<List<CampaignBidMessage>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getCategories
     * @param campaignId Mandatory. The id of the campaign the categories are linked to. (required)
     * @param enabledOnly Optional. Returns only categories you can bid on. Defaults to false. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Categories returned OK. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> One of the requested campaigns doesn&#39;t belong to the API user&#39;s portfolio which prevents from accessing its data. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested campaign was not found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCategoriesCall(Integer campaignId, Boolean enabledOnly, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/legacy/marketing/v1/campaigns/{campaignId}/categories"
            .replaceAll("\\{" + "campaignId" + "\\}", localVarApiClient.escapeString(campaignId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (enabledOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("enabledOnly", enabledOnly));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json", "text/json", "application/xml", "text/xml", "text/html"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "Authorization" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCategoriesValidateBeforeCall(Integer campaignId, Boolean enabledOnly, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'campaignId' is set
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling getCategories(Async)");
        }
        

        okhttp3.Call localVarCall = getCategoriesCall(campaignId, enabledOnly, _callback);
        return localVarCall;

    }

    /**
     * Gets categories
     * Get the list of categories linked to the requested campaign.
     * @param campaignId Mandatory. The id of the campaign the categories are linked to. (required)
     * @param enabledOnly Optional. Returns only categories you can bid on. Defaults to false. (optional)
     * @return CategoryMessage
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Categories returned OK. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> One of the requested campaigns doesn&#39;t belong to the API user&#39;s portfolio which prevents from accessing its data. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested campaign was not found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public CategoryMessage getCategories(Integer campaignId, Boolean enabledOnly) throws ApiException {
        ApiResponse<CategoryMessage> localVarResp = getCategoriesWithHttpInfo(campaignId, enabledOnly);
        return localVarResp.getData();
    }

    /**
     * Gets categories
     * Get the list of categories linked to the requested campaign.
     * @param campaignId Mandatory. The id of the campaign the categories are linked to. (required)
     * @param enabledOnly Optional. Returns only categories you can bid on. Defaults to false. (optional)
     * @return ApiResponse&lt;CategoryMessage&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Categories returned OK. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> One of the requested campaigns doesn&#39;t belong to the API user&#39;s portfolio which prevents from accessing its data. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested campaign was not found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CategoryMessage> getCategoriesWithHttpInfo(Integer campaignId, Boolean enabledOnly) throws ApiException {
        okhttp3.Call localVarCall = getCategoriesValidateBeforeCall(campaignId, enabledOnly, null);
        Type localVarReturnType = new TypeToken<CategoryMessage>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Gets categories (asynchronously)
     * Get the list of categories linked to the requested campaign.
     * @param campaignId Mandatory. The id of the campaign the categories are linked to. (required)
     * @param enabledOnly Optional. Returns only categories you can bid on. Defaults to false. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Categories returned OK. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> One of the requested campaigns doesn&#39;t belong to the API user&#39;s portfolio which prevents from accessing its data. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested campaign was not found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCategoriesAsync(Integer campaignId, Boolean enabledOnly, final ApiCallback<CategoryMessage> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCategoriesValidateBeforeCall(campaignId, enabledOnly, _callback);
        Type localVarReturnType = new TypeToken<CategoryMessage>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getCategory
     * @param campaignId Mandatory. The id of the campaign the categories are linked to. (required)
     * @param categoryHashCode Mandatory. The id of the category to return. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Category returned OK. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> One of the requested campaigns doesn&#39;t belong to the API user&#39;s portfolio which prevents from accessing its data. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested category was not found for the campaign. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCategoryCall(Integer campaignId, Integer categoryHashCode, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/legacy/marketing/v1/campaigns/{campaignId}/categories/{categoryHashCode}"
            .replaceAll("\\{" + "campaignId" + "\\}", localVarApiClient.escapeString(campaignId.toString()))
            .replaceAll("\\{" + "categoryHashCode" + "\\}", localVarApiClient.escapeString(categoryHashCode.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json", "text/json", "application/xml", "text/xml", "text/html"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "Authorization" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCategoryValidateBeforeCall(Integer campaignId, Integer categoryHashCode, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'campaignId' is set
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling getCategory(Async)");
        }
        
        // verify the required parameter 'categoryHashCode' is set
        if (categoryHashCode == null) {
            throw new ApiException("Missing the required parameter 'categoryHashCode' when calling getCategory(Async)");
        }
        

        okhttp3.Call localVarCall = getCategoryCall(campaignId, categoryHashCode, _callback);
        return localVarCall;

    }

    /**
     * Gets a specific category
     * Get a specific category linked to the requested campaign.
     * @param campaignId Mandatory. The id of the campaign the categories are linked to. (required)
     * @param categoryHashCode Mandatory. The id of the category to return. (required)
     * @return CategoryMessage
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Category returned OK. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> One of the requested campaigns doesn&#39;t belong to the API user&#39;s portfolio which prevents from accessing its data. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested category was not found for the campaign. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public CategoryMessage getCategory(Integer campaignId, Integer categoryHashCode) throws ApiException {
        ApiResponse<CategoryMessage> localVarResp = getCategoryWithHttpInfo(campaignId, categoryHashCode);
        return localVarResp.getData();
    }

    /**
     * Gets a specific category
     * Get a specific category linked to the requested campaign.
     * @param campaignId Mandatory. The id of the campaign the categories are linked to. (required)
     * @param categoryHashCode Mandatory. The id of the category to return. (required)
     * @return ApiResponse&lt;CategoryMessage&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Category returned OK. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> One of the requested campaigns doesn&#39;t belong to the API user&#39;s portfolio which prevents from accessing its data. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested category was not found for the campaign. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CategoryMessage> getCategoryWithHttpInfo(Integer campaignId, Integer categoryHashCode) throws ApiException {
        okhttp3.Call localVarCall = getCategoryValidateBeforeCall(campaignId, categoryHashCode, null);
        Type localVarReturnType = new TypeToken<CategoryMessage>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Gets a specific category (asynchronously)
     * Get a specific category linked to the requested campaign.
     * @param campaignId Mandatory. The id of the campaign the categories are linked to. (required)
     * @param categoryHashCode Mandatory. The id of the category to return. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Category returned OK. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> One of the requested campaigns doesn&#39;t belong to the API user&#39;s portfolio which prevents from accessing its data. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested category was not found for the campaign. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCategoryAsync(Integer campaignId, Integer categoryHashCode, final ApiCallback<CategoryMessage> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCategoryValidateBeforeCall(campaignId, categoryHashCode, _callback);
        Type localVarReturnType = new TypeToken<CategoryMessage>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for patchAdSets
     * @param requestsPatchAdSet List of adsets to patch. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of patched adSets. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> The API client is not properly authenticated. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The API client is not authorized to access this resource or the resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call patchAdSetsCall(RequestsPatchAdSet requestsPatchAdSet, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = requestsPatchAdSet;

        // create path and map variables
        String localVarPath = "/2021-04/marketing-solutions/ad-sets";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "text/plain", "application/json", "text/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json-patch+json", "application/json", "text/json", "application/_*+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "Authorization" };
        return localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call patchAdSetsValidateBeforeCall(RequestsPatchAdSet requestsPatchAdSet, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = patchAdSetsCall(requestsPatchAdSet, _callback);
        return localVarCall;

    }

    /**
     * 
     * Patch a list of AdSets.
     * @param requestsPatchAdSet List of adsets to patch. (optional)
     * @return ResponseAdSetId
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of patched adSets. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> The API client is not properly authenticated. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The API client is not authorized to access this resource or the resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ResponseAdSetId patchAdSets(RequestsPatchAdSet requestsPatchAdSet) throws ApiException {
        ApiResponse<ResponseAdSetId> localVarResp = patchAdSetsWithHttpInfo(requestsPatchAdSet);
        return localVarResp.getData();
    }

    /**
     * 
     * Patch a list of AdSets.
     * @param requestsPatchAdSet List of adsets to patch. (optional)
     * @return ApiResponse&lt;ResponseAdSetId&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of patched adSets. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> The API client is not properly authenticated. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The API client is not authorized to access this resource or the resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ResponseAdSetId> patchAdSetsWithHttpInfo(RequestsPatchAdSet requestsPatchAdSet) throws ApiException {
        okhttp3.Call localVarCall = patchAdSetsValidateBeforeCall(requestsPatchAdSet, null);
        Type localVarReturnType = new TypeToken<ResponseAdSetId>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Patch a list of AdSets.
     * @param requestsPatchAdSet List of adsets to patch. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of patched adSets. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> The API client is not properly authenticated. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The API client is not authorized to access this resource or the resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call patchAdSetsAsync(RequestsPatchAdSet requestsPatchAdSet, final ApiCallback<ResponseAdSetId> _callback) throws ApiException {

        okhttp3.Call localVarCall = patchAdSetsValidateBeforeCall(requestsPatchAdSet, _callback);
        Type localVarReturnType = new TypeToken<ResponseAdSetId>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for searchAdSets
     * @param requestAdSetSearch  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> data for the ad sets </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> The API client is not properly authenticated. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call searchAdSetsCall(RequestAdSetSearch requestAdSetSearch, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = requestAdSetSearch;

        // create path and map variables
        String localVarPath = "/2021-04/marketing-solutions/ad-sets/search";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "text/plain", "application/json", "text/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json-patch+json", "application/json", "text/json", "application/_*+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "Authorization" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call searchAdSetsValidateBeforeCall(RequestAdSetSearch requestAdSetSearch, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = searchAdSetsCall(requestAdSetSearch, _callback);
        return localVarCall;

    }

    /**
     * 
     * Search for ad sets
     * @param requestAdSetSearch  (optional)
     * @return ResponsesReadAdSet
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> data for the ad sets </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> The API client is not properly authenticated. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public ResponsesReadAdSet searchAdSets(RequestAdSetSearch requestAdSetSearch) throws ApiException {
        ApiResponse<ResponsesReadAdSet> localVarResp = searchAdSetsWithHttpInfo(requestAdSetSearch);
        return localVarResp.getData();
    }

    /**
     * 
     * Search for ad sets
     * @param requestAdSetSearch  (optional)
     * @return ApiResponse&lt;ResponsesReadAdSet&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> data for the ad sets </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> The API client is not properly authenticated. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ResponsesReadAdSet> searchAdSetsWithHttpInfo(RequestAdSetSearch requestAdSetSearch) throws ApiException {
        okhttp3.Call localVarCall = searchAdSetsValidateBeforeCall(requestAdSetSearch, null);
        Type localVarReturnType = new TypeToken<ResponsesReadAdSet>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Search for ad sets
     * @param requestAdSetSearch  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> data for the ad sets </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> The API client is not properly authenticated. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call searchAdSetsAsync(RequestAdSetSearch requestAdSetSearch, final ApiCallback<ResponsesReadAdSet> _callback) throws ApiException {

        okhttp3.Call localVarCall = searchAdSetsValidateBeforeCall(requestAdSetSearch, _callback);
        Type localVarReturnType = new TypeToken<ResponsesReadAdSet>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for startAdSets
     * @param requestsAdSetId All the ad sets to start (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of ad sets that have been started and errors / warnings by ad set </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> The API client is not properly authenticated. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call startAdSetsCall(RequestsAdSetId requestsAdSetId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = requestsAdSetId;

        // create path and map variables
        String localVarPath = "/2021-04/marketing-solutions/ad-sets/start";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "text/plain", "application/json", "text/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json-patch+json", "application/json", "text/json", "application/_*+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "Authorization" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call startAdSetsValidateBeforeCall(RequestsAdSetId requestsAdSetId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = startAdSetsCall(requestsAdSetId, _callback);
        return localVarCall;

    }

    /**
     * 
     * Start the specified list of ad sets
     * @param requestsAdSetId All the ad sets to start (optional)
     * @return ResponsesAdSetId
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of ad sets that have been started and errors / warnings by ad set </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> The API client is not properly authenticated. </td><td>  -  </td></tr>
     </table>
     */
    public ResponsesAdSetId startAdSets(RequestsAdSetId requestsAdSetId) throws ApiException {
        ApiResponse<ResponsesAdSetId> localVarResp = startAdSetsWithHttpInfo(requestsAdSetId);
        return localVarResp.getData();
    }

    /**
     * 
     * Start the specified list of ad sets
     * @param requestsAdSetId All the ad sets to start (optional)
     * @return ApiResponse&lt;ResponsesAdSetId&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of ad sets that have been started and errors / warnings by ad set </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> The API client is not properly authenticated. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ResponsesAdSetId> startAdSetsWithHttpInfo(RequestsAdSetId requestsAdSetId) throws ApiException {
        okhttp3.Call localVarCall = startAdSetsValidateBeforeCall(requestsAdSetId, null);
        Type localVarReturnType = new TypeToken<ResponsesAdSetId>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Start the specified list of ad sets
     * @param requestsAdSetId All the ad sets to start (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of ad sets that have been started and errors / warnings by ad set </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> The API client is not properly authenticated. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call startAdSetsAsync(RequestsAdSetId requestsAdSetId, final ApiCallback<ResponsesAdSetId> _callback) throws ApiException {

        okhttp3.Call localVarCall = startAdSetsValidateBeforeCall(requestsAdSetId, _callback);
        Type localVarReturnType = new TypeToken<ResponsesAdSetId>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for stopAdSets
     * @param requestsAdSetId All the ad sets to stop (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of ad sets that have been stopped and errors / warnings by ad set </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> The API client is not properly authenticated. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call stopAdSetsCall(RequestsAdSetId requestsAdSetId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = requestsAdSetId;

        // create path and map variables
        String localVarPath = "/2021-04/marketing-solutions/ad-sets/stop";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "text/plain", "application/json", "text/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json-patch+json", "application/json", "text/json", "application/_*+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "Authorization" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call stopAdSetsValidateBeforeCall(RequestsAdSetId requestsAdSetId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = stopAdSetsCall(requestsAdSetId, _callback);
        return localVarCall;

    }

    /**
     * 
     * Stop the specified list of ad sets
     * @param requestsAdSetId All the ad sets to stop (optional)
     * @return ResponsesAdSetId
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of ad sets that have been stopped and errors / warnings by ad set </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> The API client is not properly authenticated. </td><td>  -  </td></tr>
     </table>
     */
    public ResponsesAdSetId stopAdSets(RequestsAdSetId requestsAdSetId) throws ApiException {
        ApiResponse<ResponsesAdSetId> localVarResp = stopAdSetsWithHttpInfo(requestsAdSetId);
        return localVarResp.getData();
    }

    /**
     * 
     * Stop the specified list of ad sets
     * @param requestsAdSetId All the ad sets to stop (optional)
     * @return ApiResponse&lt;ResponsesAdSetId&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of ad sets that have been stopped and errors / warnings by ad set </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> The API client is not properly authenticated. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ResponsesAdSetId> stopAdSetsWithHttpInfo(RequestsAdSetId requestsAdSetId) throws ApiException {
        okhttp3.Call localVarCall = stopAdSetsValidateBeforeCall(requestsAdSetId, null);
        Type localVarReturnType = new TypeToken<ResponsesAdSetId>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Stop the specified list of ad sets
     * @param requestsAdSetId All the ad sets to stop (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of ad sets that have been stopped and errors / warnings by ad set </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> The API client is not properly authenticated. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call stopAdSetsAsync(RequestsAdSetId requestsAdSetId, final ApiCallback<ResponsesAdSetId> _callback) throws ApiException {

        okhttp3.Call localVarCall = stopAdSetsValidateBeforeCall(requestsAdSetId, _callback);
        Type localVarReturnType = new TypeToken<ResponsesAdSetId>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateBids
     * @param bidChanges Specifies the list of bid changes to be applied. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Campaign bids updated OK. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Invalid input. Please check returned message for details. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateBidsCall(List<CampaignBidChangeRequest> bidChanges, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = bidChanges;

        // create path and map variables
        String localVarPath = "/legacy/marketing/v1/campaigns/bids";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json", "text/json", "application/xml", "text/xml", "text/html"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded", "text/html"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "Authorization" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateBidsValidateBeforeCall(List<CampaignBidChangeRequest> bidChanges, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'bidChanges' is set
        if (bidChanges == null) {
            throw new ApiException("Missing the required parameter 'bidChanges' when calling updateBids(Async)");
        }
        

        okhttp3.Call localVarCall = updateBidsCall(bidChanges, _callback);
        return localVarCall;

    }

    /**
     * Update bids for campaigns and their categories
     * If a campaign bid is updated, all (if any) category bids for this campaign will be updated with the new value if they are initially equal to the campaign bid.  If the category bid is not wanted to be cascaded to the categories with the same bid value, new change bids must be added in the request for the categories where the value should be kept (with the initial value).
     * @param bidChanges Specifies the list of bid changes to be applied. (required)
     * @return List&lt;CampaignMessage&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Campaign bids updated OK. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Invalid input. Please check returned message for details. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public List<CampaignMessage> updateBids(List<CampaignBidChangeRequest> bidChanges) throws ApiException {
        ApiResponse<List<CampaignMessage>> localVarResp = updateBidsWithHttpInfo(bidChanges);
        return localVarResp.getData();
    }

    /**
     * Update bids for campaigns and their categories
     * If a campaign bid is updated, all (if any) category bids for this campaign will be updated with the new value if they are initially equal to the campaign bid.  If the category bid is not wanted to be cascaded to the categories with the same bid value, new change bids must be added in the request for the categories where the value should be kept (with the initial value).
     * @param bidChanges Specifies the list of bid changes to be applied. (required)
     * @return ApiResponse&lt;List&lt;CampaignMessage&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Campaign bids updated OK. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Invalid input. Please check returned message for details. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<CampaignMessage>> updateBidsWithHttpInfo(List<CampaignBidChangeRequest> bidChanges) throws ApiException {
        okhttp3.Call localVarCall = updateBidsValidateBeforeCall(bidChanges, null);
        Type localVarReturnType = new TypeToken<List<CampaignMessage>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update bids for campaigns and their categories (asynchronously)
     * If a campaign bid is updated, all (if any) category bids for this campaign will be updated with the new value if they are initially equal to the campaign bid.  If the category bid is not wanted to be cascaded to the categories with the same bid value, new change bids must be added in the request for the categories where the value should be kept (with the initial value).
     * @param bidChanges Specifies the list of bid changes to be applied. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Campaign bids updated OK. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Invalid input. Please check returned message for details. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateBidsAsync(List<CampaignBidChangeRequest> bidChanges, final ApiCallback<List<CampaignMessage>> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateBidsValidateBeforeCall(bidChanges, _callback);
        Type localVarReturnType = new TypeToken<List<CampaignMessage>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
