/*
 * Criteo API Transition Swagger
 * This is used to help Criteo clients transition from MAPI to Criteo API
 *
 * The version of the OpenAPI document: 1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.criteo.marketing.api;

import com.criteo.marketing.ApiCallback;
import com.criteo.marketing.ApiClient;
import com.criteo.marketing.ApiException;
import com.criteo.marketing.ApiResponse;
import com.criteo.marketing.Configuration;
import com.criteo.marketing.Pair;
import com.criteo.marketing.ProgressRequestBody;
import com.criteo.marketing.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.criteo.marketing.model.CategoryMessage;
import com.criteo.marketing.model.CategoryUpdatesPerCatalog;
import com.criteo.marketing.model.CategoryUpdatesPerCatalogErrorMessageWithDetails;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CategoryApi {
    private ApiClient localVarApiClient;

    public CategoryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CategoryApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getCategories
     * @param campaignIds Optional. One or more campaign ids, E.g., 78, 12932, 45236. If the campaign ids requested are not liked to advertisers in the user&#39;s portfolio, they will be skipped. (optional)
     * @param advertiserIds Optional. One or more advertiser ids, E.g., 78, 12932, 45236. If the advertiser ids requested are not part of the user&#39;s portfolio, they will be skipped. (optional)
     * @param categoryHashCodes Optional. One or more category hash codes. (optional)
     * @param enabledOnly Optional. Returns only categories you can bid on. Defaults to false. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Categories returned OK. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> There is not even one valid advertiserId or campaignId requested. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCategoriesCall(String campaignIds, String advertiserIds, String categoryHashCodes, Boolean enabledOnly, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/legacy/marketing/v1/categories";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (campaignIds != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("campaignIds", campaignIds));
        }

        if (advertiserIds != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("advertiserIds", advertiserIds));
        }

        if (categoryHashCodes != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("categoryHashCodes", categoryHashCodes));
        }

        if (enabledOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("enabledOnly", enabledOnly));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json", "text/json", "application/xml", "text/xml", "text/html"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "Authorization" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCategoriesValidateBeforeCall(String campaignIds, String advertiserIds, String categoryHashCodes, Boolean enabledOnly, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getCategoriesCall(campaignIds, advertiserIds, categoryHashCodes, enabledOnly, _callback);
        return localVarCall;

    }

    /**
     * Gets categories
     * Get the list of categories with the specified filters.  If a category is requested but is missing from current user&#39;s portfolio, it will not be included in the list.  If neither campaign ids nor advertisers ids are provided, then the user&#39;s portfolio will be used.
     * @param campaignIds Optional. One or more campaign ids, E.g., 78, 12932, 45236. If the campaign ids requested are not liked to advertisers in the user&#39;s portfolio, they will be skipped. (optional)
     * @param advertiserIds Optional. One or more advertiser ids, E.g., 78, 12932, 45236. If the advertiser ids requested are not part of the user&#39;s portfolio, they will be skipped. (optional)
     * @param categoryHashCodes Optional. One or more category hash codes. (optional)
     * @param enabledOnly Optional. Returns only categories you can bid on. Defaults to false. (optional)
     * @return List&lt;CategoryMessage&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Categories returned OK. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> There is not even one valid advertiserId or campaignId requested. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public List<CategoryMessage> getCategories(String campaignIds, String advertiserIds, String categoryHashCodes, Boolean enabledOnly) throws ApiException {
        ApiResponse<List<CategoryMessage>> localVarResp = getCategoriesWithHttpInfo(campaignIds, advertiserIds, categoryHashCodes, enabledOnly);
        return localVarResp.getData();
    }

    /**
     * Gets categories
     * Get the list of categories with the specified filters.  If a category is requested but is missing from current user&#39;s portfolio, it will not be included in the list.  If neither campaign ids nor advertisers ids are provided, then the user&#39;s portfolio will be used.
     * @param campaignIds Optional. One or more campaign ids, E.g., 78, 12932, 45236. If the campaign ids requested are not liked to advertisers in the user&#39;s portfolio, they will be skipped. (optional)
     * @param advertiserIds Optional. One or more advertiser ids, E.g., 78, 12932, 45236. If the advertiser ids requested are not part of the user&#39;s portfolio, they will be skipped. (optional)
     * @param categoryHashCodes Optional. One or more category hash codes. (optional)
     * @param enabledOnly Optional. Returns only categories you can bid on. Defaults to false. (optional)
     * @return ApiResponse&lt;List&lt;CategoryMessage&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Categories returned OK. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> There is not even one valid advertiserId or campaignId requested. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<CategoryMessage>> getCategoriesWithHttpInfo(String campaignIds, String advertiserIds, String categoryHashCodes, Boolean enabledOnly) throws ApiException {
        okhttp3.Call localVarCall = getCategoriesValidateBeforeCall(campaignIds, advertiserIds, categoryHashCodes, enabledOnly, null);
        Type localVarReturnType = new TypeToken<List<CategoryMessage>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Gets categories (asynchronously)
     * Get the list of categories with the specified filters.  If a category is requested but is missing from current user&#39;s portfolio, it will not be included in the list.  If neither campaign ids nor advertisers ids are provided, then the user&#39;s portfolio will be used.
     * @param campaignIds Optional. One or more campaign ids, E.g., 78, 12932, 45236. If the campaign ids requested are not liked to advertisers in the user&#39;s portfolio, they will be skipped. (optional)
     * @param advertiserIds Optional. One or more advertiser ids, E.g., 78, 12932, 45236. If the advertiser ids requested are not part of the user&#39;s portfolio, they will be skipped. (optional)
     * @param categoryHashCodes Optional. One or more category hash codes. (optional)
     * @param enabledOnly Optional. Returns only categories you can bid on. Defaults to false. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Categories returned OK. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> There is not even one valid advertiserId or campaignId requested. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCategoriesAsync(String campaignIds, String advertiserIds, String categoryHashCodes, Boolean enabledOnly, final ApiCallback<List<CategoryMessage>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCategoriesValidateBeforeCall(campaignIds, advertiserIds, categoryHashCodes, enabledOnly, _callback);
        Type localVarReturnType = new TypeToken<List<CategoryMessage>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateCategories
     * @param categoriesPerCatalog The list of categories to be enabled/disabled, grouped by catalog. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Categories updated OK. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Invalid input. Please check returned message for details. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateCategoriesCall(List<CategoryUpdatesPerCatalog> categoriesPerCatalog, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = categoriesPerCatalog;

        // create path and map variables
        String localVarPath = "/legacy/marketing/v1/categories";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json", "text/json", "application/xml", "text/xml", "text/html"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded", "text/html"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "Authorization" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateCategoriesValidateBeforeCall(List<CategoryUpdatesPerCatalog> categoriesPerCatalog, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'categoriesPerCatalog' is set
        if (categoriesPerCatalog == null) {
            throw new ApiException("Missing the required parameter 'categoriesPerCatalog' when calling updateCategories(Async)");
        }
        

        okhttp3.Call localVarCall = updateCategoriesCall(categoriesPerCatalog, _callback);
        return localVarCall;

    }

    /**
     * Enables/disables categories
     * Update categories for multiple catalogs.&lt;br /&gt;  Please note that all validations need to pass before applying the requested changes;  the subsequent validation error messages will be returned in the response.&lt;br /&gt;  Please note that bidding will still happen for disabled categories, but using the Camapign&#39;s bid.  If the call is successful, full details about the changed categories will be returned.
     * @param categoriesPerCatalog The list of categories to be enabled/disabled, grouped by catalog. (required)
     * @return List&lt;CategoryUpdatesPerCatalog&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Categories updated OK. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Invalid input. Please check returned message for details. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public List<CategoryUpdatesPerCatalog> updateCategories(List<CategoryUpdatesPerCatalog> categoriesPerCatalog) throws ApiException {
        ApiResponse<List<CategoryUpdatesPerCatalog>> localVarResp = updateCategoriesWithHttpInfo(categoriesPerCatalog);
        return localVarResp.getData();
    }

    /**
     * Enables/disables categories
     * Update categories for multiple catalogs.&lt;br /&gt;  Please note that all validations need to pass before applying the requested changes;  the subsequent validation error messages will be returned in the response.&lt;br /&gt;  Please note that bidding will still happen for disabled categories, but using the Camapign&#39;s bid.  If the call is successful, full details about the changed categories will be returned.
     * @param categoriesPerCatalog The list of categories to be enabled/disabled, grouped by catalog. (required)
     * @return ApiResponse&lt;List&lt;CategoryUpdatesPerCatalog&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Categories updated OK. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Invalid input. Please check returned message for details. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<CategoryUpdatesPerCatalog>> updateCategoriesWithHttpInfo(List<CategoryUpdatesPerCatalog> categoriesPerCatalog) throws ApiException {
        okhttp3.Call localVarCall = updateCategoriesValidateBeforeCall(categoriesPerCatalog, null);
        Type localVarReturnType = new TypeToken<List<CategoryUpdatesPerCatalog>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Enables/disables categories (asynchronously)
     * Update categories for multiple catalogs.&lt;br /&gt;  Please note that all validations need to pass before applying the requested changes;  the subsequent validation error messages will be returned in the response.&lt;br /&gt;  Please note that bidding will still happen for disabled categories, but using the Camapign&#39;s bid.  If the call is successful, full details about the changed categories will be returned.
     * @param categoriesPerCatalog The list of categories to be enabled/disabled, grouped by catalog. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Categories updated OK. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Invalid input. Please check returned message for details. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateCategoriesAsync(List<CategoryUpdatesPerCatalog> categoriesPerCatalog, final ApiCallback<List<CategoryUpdatesPerCatalog>> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateCategoriesValidateBeforeCall(categoriesPerCatalog, _callback);
        Type localVarReturnType = new TypeToken<List<CategoryUpdatesPerCatalog>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
