/*
 * Criteo API Transition Swagger
 * This is used to help Criteo clients transition from MAPI to Criteo API
 *
 * The version of the OpenAPI document: 1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.criteo.marketing.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * ad set delivery limitations model
 */
@ApiModel(description = "ad set delivery limitations model")

public class AdSetDeliveryLimitations {
  /**
   * Gets or Sets environments
   */
  @JsonAdapter(EnvironmentsEnum.Adapter.class)
  public enum EnvironmentsEnum {
    WEB("web"),
    
    INAPP("inApp");

    private String value;

    EnvironmentsEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static EnvironmentsEnum fromValue(String value) {
      for (EnvironmentsEnum b : EnvironmentsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<EnvironmentsEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final EnvironmentsEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public EnvironmentsEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return EnvironmentsEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_ENVIRONMENTS = "environments";
  @SerializedName(SERIALIZED_NAME_ENVIRONMENTS)
  private List<EnvironmentsEnum> environments = null;

  /**
   * Gets or Sets devices
   */
  @JsonAdapter(DevicesEnum.Adapter.class)
  public enum DevicesEnum {
    OTHER("other"),
    
    DESKTOP("desktop"),
    
    MOBILE("mobile"),
    
    TABLET("tablet");

    private String value;

    DevicesEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static DevicesEnum fromValue(String value) {
      for (DevicesEnum b : DevicesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<DevicesEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DevicesEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public DevicesEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return DevicesEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_DEVICES = "devices";
  @SerializedName(SERIALIZED_NAME_DEVICES)
  private List<DevicesEnum> devices = null;

  /**
   * Gets or Sets operatingSystems
   */
  @JsonAdapter(OperatingSystemsEnum.Adapter.class)
  public enum OperatingSystemsEnum {
    ANDROID("android"),
    
    IOS("ios"),
    
    UNKNOWN("unknown");

    private String value;

    OperatingSystemsEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static OperatingSystemsEnum fromValue(String value) {
      for (OperatingSystemsEnum b : OperatingSystemsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<OperatingSystemsEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final OperatingSystemsEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public OperatingSystemsEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return OperatingSystemsEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_OPERATING_SYSTEMS = "operatingSystems";
  @SerializedName(SERIALIZED_NAME_OPERATING_SYSTEMS)
  private List<OperatingSystemsEnum> operatingSystems = null;


  public AdSetDeliveryLimitations environments(List<EnvironmentsEnum> environments) {
    
    this.environments = environments;
    return this;
  }

  public AdSetDeliveryLimitations addEnvironmentsItem(EnvironmentsEnum environmentsItem) {
    if (this.environments == null) {
      this.environments = new ArrayList<>();
    }
    this.environments.add(environmentsItem);
    return this;
  }

   /**
   * List of environments which the ad set should target
   * @return environments
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "List of environments which the ad set should target")

  public List<EnvironmentsEnum> getEnvironments() {
    return environments;
  }



  public void setEnvironments(List<EnvironmentsEnum> environments) {
    this.environments = environments;
  }


  public AdSetDeliveryLimitations devices(List<DevicesEnum> devices) {
    
    this.devices = devices;
    return this;
  }

  public AdSetDeliveryLimitations addDevicesItem(DevicesEnum devicesItem) {
    if (this.devices == null) {
      this.devices = new ArrayList<>();
    }
    this.devices.add(devicesItem);
    return this;
  }

   /**
   * List of devices which the ad set should target
   * @return devices
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "List of devices which the ad set should target")

  public List<DevicesEnum> getDevices() {
    return devices;
  }



  public void setDevices(List<DevicesEnum> devices) {
    this.devices = devices;
  }


  public AdSetDeliveryLimitations operatingSystems(List<OperatingSystemsEnum> operatingSystems) {
    
    this.operatingSystems = operatingSystems;
    return this;
  }

  public AdSetDeliveryLimitations addOperatingSystemsItem(OperatingSystemsEnum operatingSystemsItem) {
    if (this.operatingSystems == null) {
      this.operatingSystems = new ArrayList<>();
    }
    this.operatingSystems.add(operatingSystemsItem);
    return this;
  }

   /**
   * List of operating systems which the ad set should target
   * @return operatingSystems
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "List of operating systems which the ad set should target")

  public List<OperatingSystemsEnum> getOperatingSystems() {
    return operatingSystems;
  }



  public void setOperatingSystems(List<OperatingSystemsEnum> operatingSystems) {
    this.operatingSystems = operatingSystems;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdSetDeliveryLimitations adSetDeliveryLimitations = (AdSetDeliveryLimitations) o;
    return Objects.equals(this.environments, adSetDeliveryLimitations.environments) &&
        Objects.equals(this.devices, adSetDeliveryLimitations.devices) &&
        Objects.equals(this.operatingSystems, adSetDeliveryLimitations.operatingSystems);
  }

  @Override
  public int hashCode() {
    return Objects.hash(environments, devices, operatingSystems);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdSetDeliveryLimitations {\n");
    sb.append("    environments: ").append(toIndentedString(environments)).append("\n");
    sb.append("    devices: ").append(toIndentedString(devices)).append("\n");
    sb.append("    operatingSystems: ").append(toIndentedString(operatingSystems)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

