/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing;

import com.criteo.marketing.ApiClient;
import com.criteo.marketing.ApiException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.verify.VerificationTimes;

public class ApiClientTest {
    private static final int SERVER_PORT = 1080;
    private static final String BASE_URL = "http://localhost:1080";
    private static final String PATH_FAKE = "/fake/path";
    private static final String PATH_AUTHENTICATION = "/oauth2/token";
    private static final String EXPLICIT_TOKEN = "EXPLICIT-TOKEN";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final int TOKEN_EXPIRES_IN_SECONDS = 16;
    private ClientAndServer mockServer;
    private ApiClient apiClient;

    @Before
    public void setup() {
        this.mockServer = ClientAndServer.startClientAndServer((Integer[])new Integer[]{1080});
        this.mockServer.when(HttpRequest.request().withMethod("POST").withPath(PATH_AUTHENTICATION)).respond(HttpResponse.response().withBody(String.format("{\"access_token\":\"FAKE-TOKEN\",\"token_type\":\"bearer\",\"expires_in\":%d}", 16)));
        this.apiClient = new ApiClient();
        this.apiClient.setBasePath(BASE_URL);
    }

    @After
    public void stopMockServer() {
        this.mockServer.stop();
    }

    @Test
    public void buildRequest_WithCredential_WithoutExplicitToken_ShouldRefreshToken() throws ApiException {
        this.apiClient.setUsername(USERNAME);
        this.apiClient.setPassword(PASSWORD);
        this.buildFakeGetRequest();
        this.verifyTokenRequestCounts(1);
    }

    @Test
    public void buildRequest_WithoutCredential_WithExplicitToken_ShouldNotRefreshToken() throws ApiException {
        this.buildFakeGetRequest(EXPLICIT_TOKEN);
        this.verifyTokenRequestCounts(0);
    }

    @Test
    public void buildRequest_WithCredential_WithExplicitToken_ShouldNotRefreshToken() throws ApiException {
        this.apiClient.setUsername(USERNAME);
        this.apiClient.setPassword(PASSWORD);
        this.buildFakeGetRequest(EXPLICIT_TOKEN);
        this.verifyTokenRequestCounts(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void buildRequest_WithoutCredential_WithoutExplicitToken_ShouldThrowException() throws ApiException {
        this.buildFakeGetRequest();
        this.verifyTokenRequestCounts(0);
    }

    @Test
    public void buildRequest_WithCredential_WithoutExplicitToken_TokenNotExpired_ShouldNotRefreshTokenInSecondCall() throws ApiException {
        this.apiClient.setUsername(USERNAME);
        this.apiClient.setPassword(PASSWORD);
        this.buildFakeGetRequest();
        this.verifyTokenRequestCounts(1);
        this.buildFakeGetRequest();
        this.verifyTokenRequestCounts(1);
    }

    @Test
    public void buildRequest_WithCredential_TokenExpired_ShouldRefreshTokenInSecondCall() throws ApiException, InterruptedException {
        this.apiClient.setUsername(USERNAME);
        this.apiClient.setPassword(PASSWORD);
        this.buildFakeGetRequest();
        this.verifyTokenRequestCounts(1);
        Thread.sleep(2000L);
        this.buildFakeGetRequest();
        this.verifyTokenRequestCounts(2);
    }

    @Test
    public void buildRequest_AuthenticationEndpoint_ShouldNotRefreshToken() throws ApiException {
        this.buildAuthenticationRequest();
        this.verifyTokenRequestCounts(0);
    }

    private void buildFakeGetRequest() throws ApiException {
        this.buildFakeGetRequest("");
    }

    private void buildFakeGetRequest(String explicitToken) throws ApiException {
        this.buildFakeRequest(PATH_FAKE, "GET", explicitToken);
    }

    private void buildAuthenticationRequest() throws ApiException {
        this.buildFakeRequest(PATH_AUTHENTICATION, "POST", "");
    }

    private void buildFakeRequest(String path, String method, final String explicitToken) throws ApiException {
        Map formParams = Collections.emptyMap();
        List queryParams = Collections.emptyList();
        List collectionQueryParams = Collections.emptyList();
        String[] authNames = new String[]{"Authorization"};
        HashMap<String, String> headerParams = new HashMap<String, String>(){
            {
                this.put("Authorization", explicitToken);
            }
        };
        this.apiClient.buildRequest(path, method, queryParams, collectionQueryParams, (Object)"", (Map)headerParams, formParams, authNames, null);
    }

    private void verifyTokenRequestCounts(int count) {
        this.mockServer.verify(HttpRequest.request().withMethod("POST").withPath(PATH_AUTHENTICATION), VerificationTimes.exactly((int)count));
    }
}

