/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing.api;

import com.criteo.marketing.ApiCallback;
import com.criteo.marketing.ApiClient;
import com.criteo.marketing.ApiException;
import com.criteo.marketing.ApiResponse;
import com.criteo.marketing.Configuration;
import com.criteo.marketing.Pair;
import com.criteo.marketing.model.CampaignBidChangeRequest;
import com.criteo.marketing.model.CampaignBidMessage;
import com.criteo.marketing.model.CampaignMessage;
import com.criteo.marketing.model.CategoryMessage;
import com.criteo.marketing.model.RequestAdSetSearch;
import com.criteo.marketing.model.RequestsAdSetId;
import com.criteo.marketing.model.RequestsPatchAdSet;
import com.criteo.marketing.model.ResponseAdSetId;
import com.criteo.marketing.model.ResponseReadAdSet;
import com.criteo.marketing.model.ResponsesAdSetId;
import com.criteo.marketing.model.ResponsesReadAdSet;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class CampaignApi {
    private ApiClient localVarApiClient;

    public CampaignApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CampaignApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getAdSetCall(String adSetId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/2021-04/marketing-solutions/ad-sets/{adSetId}".replaceAll("\\{adSetId\\}", this.localVarApiClient.escapeString(adSetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAdSetValidateBeforeCall(String adSetId, ApiCallback _callback) throws ApiException {
        if (adSetId == null) {
            throw new ApiException("Missing the required parameter 'adSetId' when calling getAdSet(Async)");
        }
        Call localVarCall = this.getAdSetCall(adSetId, _callback);
        return localVarCall;
    }

    public ResponseReadAdSet getAdSet(String adSetId) throws ApiException {
        ApiResponse<ResponseReadAdSet> localVarResp = this.getAdSetWithHttpInfo(adSetId);
        return localVarResp.getData();
    }

    public ApiResponse<ResponseReadAdSet> getAdSetWithHttpInfo(String adSetId) throws ApiException {
        Call localVarCall = this.getAdSetValidateBeforeCall(adSetId, null);
        Type localVarReturnType = new TypeToken<ResponseReadAdSet>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAdSetAsync(String adSetId, ApiCallback<ResponseReadAdSet> _callback) throws ApiException {
        Call localVarCall = this.getAdSetValidateBeforeCall(adSetId, _callback);
        Type localVarReturnType = new TypeToken<ResponseReadAdSet>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBidsCall(String campaignIds, String advertiserIds, String categoryHashCodes, String bidType, String campaignStatus, Boolean pendingChanges, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/legacy/marketing/v1/campaigns/bids";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (campaignIds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("campaignIds", campaignIds));
        }
        if (advertiserIds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("advertiserIds", advertiserIds));
        }
        if (categoryHashCodes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("categoryHashCodes", categoryHashCodes));
        }
        if (bidType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("bidType", bidType));
        }
        if (campaignStatus != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("campaignStatus", campaignStatus));
        }
        if (pendingChanges != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pendingChanges", pendingChanges));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml", "text/html"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBidsValidateBeforeCall(String campaignIds, String advertiserIds, String categoryHashCodes, String bidType, String campaignStatus, Boolean pendingChanges, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getBidsCall(campaignIds, advertiserIds, categoryHashCodes, bidType, campaignStatus, pendingChanges, _callback);
        return localVarCall;
    }

    public List<CampaignBidMessage> getBids(String campaignIds, String advertiserIds, String categoryHashCodes, String bidType, String campaignStatus, Boolean pendingChanges) throws ApiException {
        ApiResponse<List<CampaignBidMessage>> localVarResp = this.getBidsWithHttpInfo(campaignIds, advertiserIds, categoryHashCodes, bidType, campaignStatus, pendingChanges);
        return localVarResp.getData();
    }

    public ApiResponse<List<CampaignBidMessage>> getBidsWithHttpInfo(String campaignIds, String advertiserIds, String categoryHashCodes, String bidType, String campaignStatus, Boolean pendingChanges) throws ApiException {
        Call localVarCall = this.getBidsValidateBeforeCall(campaignIds, advertiserIds, categoryHashCodes, bidType, campaignStatus, pendingChanges, null);
        Type localVarReturnType = new TypeToken<List<CampaignBidMessage>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBidsAsync(String campaignIds, String advertiserIds, String categoryHashCodes, String bidType, String campaignStatus, Boolean pendingChanges, ApiCallback<List<CampaignBidMessage>> _callback) throws ApiException {
        Call localVarCall = this.getBidsValidateBeforeCall(campaignIds, advertiserIds, categoryHashCodes, bidType, campaignStatus, pendingChanges, _callback);
        Type localVarReturnType = new TypeToken<List<CampaignBidMessage>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCategoriesCall(Integer campaignId, Boolean enabledOnly, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/legacy/marketing/v1/campaigns/{campaignId}/categories".replaceAll("\\{campaignId\\}", this.localVarApiClient.escapeString(campaignId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (enabledOnly != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("enabledOnly", enabledOnly));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml", "text/html"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCategoriesValidateBeforeCall(Integer campaignId, Boolean enabledOnly, ApiCallback _callback) throws ApiException {
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling getCategories(Async)");
        }
        Call localVarCall = this.getCategoriesCall(campaignId, enabledOnly, _callback);
        return localVarCall;
    }

    public CategoryMessage getCategories(Integer campaignId, Boolean enabledOnly) throws ApiException {
        ApiResponse<CategoryMessage> localVarResp = this.getCategoriesWithHttpInfo(campaignId, enabledOnly);
        return localVarResp.getData();
    }

    public ApiResponse<CategoryMessage> getCategoriesWithHttpInfo(Integer campaignId, Boolean enabledOnly) throws ApiException {
        Call localVarCall = this.getCategoriesValidateBeforeCall(campaignId, enabledOnly, null);
        Type localVarReturnType = new TypeToken<CategoryMessage>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCategoriesAsync(Integer campaignId, Boolean enabledOnly, ApiCallback<CategoryMessage> _callback) throws ApiException {
        Call localVarCall = this.getCategoriesValidateBeforeCall(campaignId, enabledOnly, _callback);
        Type localVarReturnType = new TypeToken<CategoryMessage>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCategoryCall(Integer campaignId, Integer categoryHashCode, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/legacy/marketing/v1/campaigns/{campaignId}/categories/{categoryHashCode}".replaceAll("\\{campaignId\\}", this.localVarApiClient.escapeString(campaignId.toString())).replaceAll("\\{categoryHashCode\\}", this.localVarApiClient.escapeString(categoryHashCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml", "text/html"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCategoryValidateBeforeCall(Integer campaignId, Integer categoryHashCode, ApiCallback _callback) throws ApiException {
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling getCategory(Async)");
        }
        if (categoryHashCode == null) {
            throw new ApiException("Missing the required parameter 'categoryHashCode' when calling getCategory(Async)");
        }
        Call localVarCall = this.getCategoryCall(campaignId, categoryHashCode, _callback);
        return localVarCall;
    }

    public CategoryMessage getCategory(Integer campaignId, Integer categoryHashCode) throws ApiException {
        ApiResponse<CategoryMessage> localVarResp = this.getCategoryWithHttpInfo(campaignId, categoryHashCode);
        return localVarResp.getData();
    }

    public ApiResponse<CategoryMessage> getCategoryWithHttpInfo(Integer campaignId, Integer categoryHashCode) throws ApiException {
        Call localVarCall = this.getCategoryValidateBeforeCall(campaignId, categoryHashCode, null);
        Type localVarReturnType = new TypeToken<CategoryMessage>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCategoryAsync(Integer campaignId, Integer categoryHashCode, ApiCallback<CategoryMessage> _callback) throws ApiException {
        Call localVarCall = this.getCategoryValidateBeforeCall(campaignId, categoryHashCode, _callback);
        Type localVarReturnType = new TypeToken<CategoryMessage>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchAdSetsCall(RequestsPatchAdSet requestsPatchAdSet, ApiCallback _callback) throws ApiException {
        RequestsPatchAdSet localVarPostBody = requestsPatchAdSet;
        String localVarPath = "/2021-04/marketing-solutions/ad-sets";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchAdSetsValidateBeforeCall(RequestsPatchAdSet requestsPatchAdSet, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.patchAdSetsCall(requestsPatchAdSet, _callback);
        return localVarCall;
    }

    public ResponseAdSetId patchAdSets(RequestsPatchAdSet requestsPatchAdSet) throws ApiException {
        ApiResponse<ResponseAdSetId> localVarResp = this.patchAdSetsWithHttpInfo(requestsPatchAdSet);
        return localVarResp.getData();
    }

    public ApiResponse<ResponseAdSetId> patchAdSetsWithHttpInfo(RequestsPatchAdSet requestsPatchAdSet) throws ApiException {
        Call localVarCall = this.patchAdSetsValidateBeforeCall(requestsPatchAdSet, null);
        Type localVarReturnType = new TypeToken<ResponseAdSetId>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchAdSetsAsync(RequestsPatchAdSet requestsPatchAdSet, ApiCallback<ResponseAdSetId> _callback) throws ApiException {
        Call localVarCall = this.patchAdSetsValidateBeforeCall(requestsPatchAdSet, _callback);
        Type localVarReturnType = new TypeToken<ResponseAdSetId>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call searchAdSetsCall(RequestAdSetSearch requestAdSetSearch, ApiCallback _callback) throws ApiException {
        RequestAdSetSearch localVarPostBody = requestAdSetSearch;
        String localVarPath = "/2021-04/marketing-solutions/ad-sets/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call searchAdSetsValidateBeforeCall(RequestAdSetSearch requestAdSetSearch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.searchAdSetsCall(requestAdSetSearch, _callback);
        return localVarCall;
    }

    public ResponsesReadAdSet searchAdSets(RequestAdSetSearch requestAdSetSearch) throws ApiException {
        ApiResponse<ResponsesReadAdSet> localVarResp = this.searchAdSetsWithHttpInfo(requestAdSetSearch);
        return localVarResp.getData();
    }

    public ApiResponse<ResponsesReadAdSet> searchAdSetsWithHttpInfo(RequestAdSetSearch requestAdSetSearch) throws ApiException {
        Call localVarCall = this.searchAdSetsValidateBeforeCall(requestAdSetSearch, null);
        Type localVarReturnType = new TypeToken<ResponsesReadAdSet>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call searchAdSetsAsync(RequestAdSetSearch requestAdSetSearch, ApiCallback<ResponsesReadAdSet> _callback) throws ApiException {
        Call localVarCall = this.searchAdSetsValidateBeforeCall(requestAdSetSearch, _callback);
        Type localVarReturnType = new TypeToken<ResponsesReadAdSet>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call startAdSetsCall(RequestsAdSetId requestsAdSetId, ApiCallback _callback) throws ApiException {
        RequestsAdSetId localVarPostBody = requestsAdSetId;
        String localVarPath = "/2021-04/marketing-solutions/ad-sets/start";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call startAdSetsValidateBeforeCall(RequestsAdSetId requestsAdSetId, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.startAdSetsCall(requestsAdSetId, _callback);
        return localVarCall;
    }

    public ResponsesAdSetId startAdSets(RequestsAdSetId requestsAdSetId) throws ApiException {
        ApiResponse<ResponsesAdSetId> localVarResp = this.startAdSetsWithHttpInfo(requestsAdSetId);
        return localVarResp.getData();
    }

    public ApiResponse<ResponsesAdSetId> startAdSetsWithHttpInfo(RequestsAdSetId requestsAdSetId) throws ApiException {
        Call localVarCall = this.startAdSetsValidateBeforeCall(requestsAdSetId, null);
        Type localVarReturnType = new TypeToken<ResponsesAdSetId>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call startAdSetsAsync(RequestsAdSetId requestsAdSetId, ApiCallback<ResponsesAdSetId> _callback) throws ApiException {
        Call localVarCall = this.startAdSetsValidateBeforeCall(requestsAdSetId, _callback);
        Type localVarReturnType = new TypeToken<ResponsesAdSetId>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call stopAdSetsCall(RequestsAdSetId requestsAdSetId, ApiCallback _callback) throws ApiException {
        RequestsAdSetId localVarPostBody = requestsAdSetId;
        String localVarPath = "/2021-04/marketing-solutions/ad-sets/stop";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stopAdSetsValidateBeforeCall(RequestsAdSetId requestsAdSetId, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.stopAdSetsCall(requestsAdSetId, _callback);
        return localVarCall;
    }

    public ResponsesAdSetId stopAdSets(RequestsAdSetId requestsAdSetId) throws ApiException {
        ApiResponse<ResponsesAdSetId> localVarResp = this.stopAdSetsWithHttpInfo(requestsAdSetId);
        return localVarResp.getData();
    }

    public ApiResponse<ResponsesAdSetId> stopAdSetsWithHttpInfo(RequestsAdSetId requestsAdSetId) throws ApiException {
        Call localVarCall = this.stopAdSetsValidateBeforeCall(requestsAdSetId, null);
        Type localVarReturnType = new TypeToken<ResponsesAdSetId>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call stopAdSetsAsync(RequestsAdSetId requestsAdSetId, ApiCallback<ResponsesAdSetId> _callback) throws ApiException {
        Call localVarCall = this.stopAdSetsValidateBeforeCall(requestsAdSetId, _callback);
        Type localVarReturnType = new TypeToken<ResponsesAdSetId>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateBidsCall(List<CampaignBidChangeRequest> bidChanges, ApiCallback _callback) throws ApiException {
        List<CampaignBidChangeRequest> localVarPostBody = bidChanges;
        String localVarPath = "/legacy/marketing/v1/campaigns/bids";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml", "text/html"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded", "text/html"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateBidsValidateBeforeCall(List<CampaignBidChangeRequest> bidChanges, ApiCallback _callback) throws ApiException {
        if (bidChanges == null) {
            throw new ApiException("Missing the required parameter 'bidChanges' when calling updateBids(Async)");
        }
        Call localVarCall = this.updateBidsCall(bidChanges, _callback);
        return localVarCall;
    }

    public List<CampaignMessage> updateBids(List<CampaignBidChangeRequest> bidChanges) throws ApiException {
        ApiResponse<List<CampaignMessage>> localVarResp = this.updateBidsWithHttpInfo(bidChanges);
        return localVarResp.getData();
    }

    public ApiResponse<List<CampaignMessage>> updateBidsWithHttpInfo(List<CampaignBidChangeRequest> bidChanges) throws ApiException {
        Call localVarCall = this.updateBidsValidateBeforeCall(bidChanges, null);
        Type localVarReturnType = new TypeToken<List<CampaignMessage>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateBidsAsync(List<CampaignBidChangeRequest> bidChanges, ApiCallback<List<CampaignMessage>> _callback) throws ApiException {
        Call localVarCall = this.updateBidsValidateBeforeCall(bidChanges, _callback);
        Type localVarReturnType = new TypeToken<List<CampaignMessage>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

