/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing.api;

import com.criteo.marketing.ApiCallback;
import com.criteo.marketing.ApiClient;
import com.criteo.marketing.ApiException;
import com.criteo.marketing.ApiResponse;
import com.criteo.marketing.Configuration;
import com.criteo.marketing.Pair;
import com.criteo.marketing.model.CategoryMessage;
import com.criteo.marketing.model.CategoryUpdatesPerCatalog;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class CategoryApi {
    private ApiClient localVarApiClient;

    public CategoryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CategoryApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getCategoriesCall(String campaignIds, String advertiserIds, String categoryHashCodes, Boolean enabledOnly, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/legacy/marketing/v1/categories";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (campaignIds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("campaignIds", campaignIds));
        }
        if (advertiserIds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("advertiserIds", advertiserIds));
        }
        if (categoryHashCodes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("categoryHashCodes", categoryHashCodes));
        }
        if (enabledOnly != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("enabledOnly", enabledOnly));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml", "text/html"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCategoriesValidateBeforeCall(String campaignIds, String advertiserIds, String categoryHashCodes, Boolean enabledOnly, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getCategoriesCall(campaignIds, advertiserIds, categoryHashCodes, enabledOnly, _callback);
        return localVarCall;
    }

    public List<CategoryMessage> getCategories(String campaignIds, String advertiserIds, String categoryHashCodes, Boolean enabledOnly) throws ApiException {
        ApiResponse<List<CategoryMessage>> localVarResp = this.getCategoriesWithHttpInfo(campaignIds, advertiserIds, categoryHashCodes, enabledOnly);
        return localVarResp.getData();
    }

    public ApiResponse<List<CategoryMessage>> getCategoriesWithHttpInfo(String campaignIds, String advertiserIds, String categoryHashCodes, Boolean enabledOnly) throws ApiException {
        Call localVarCall = this.getCategoriesValidateBeforeCall(campaignIds, advertiserIds, categoryHashCodes, enabledOnly, null);
        Type localVarReturnType = new TypeToken<List<CategoryMessage>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCategoriesAsync(String campaignIds, String advertiserIds, String categoryHashCodes, Boolean enabledOnly, ApiCallback<List<CategoryMessage>> _callback) throws ApiException {
        Call localVarCall = this.getCategoriesValidateBeforeCall(campaignIds, advertiserIds, categoryHashCodes, enabledOnly, _callback);
        Type localVarReturnType = new TypeToken<List<CategoryMessage>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateCategoriesCall(List<CategoryUpdatesPerCatalog> categoriesPerCatalog, ApiCallback _callback) throws ApiException {
        List<CategoryUpdatesPerCatalog> localVarPostBody = categoriesPerCatalog;
        String localVarPath = "/legacy/marketing/v1/categories";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml", "text/html"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded", "text/html"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateCategoriesValidateBeforeCall(List<CategoryUpdatesPerCatalog> categoriesPerCatalog, ApiCallback _callback) throws ApiException {
        if (categoriesPerCatalog == null) {
            throw new ApiException("Missing the required parameter 'categoriesPerCatalog' when calling updateCategories(Async)");
        }
        Call localVarCall = this.updateCategoriesCall(categoriesPerCatalog, _callback);
        return localVarCall;
    }

    public List<CategoryUpdatesPerCatalog> updateCategories(List<CategoryUpdatesPerCatalog> categoriesPerCatalog) throws ApiException {
        ApiResponse<List<CategoryUpdatesPerCatalog>> localVarResp = this.updateCategoriesWithHttpInfo(categoriesPerCatalog);
        return localVarResp.getData();
    }

    public ApiResponse<List<CategoryUpdatesPerCatalog>> updateCategoriesWithHttpInfo(List<CategoryUpdatesPerCatalog> categoriesPerCatalog) throws ApiException {
        Call localVarCall = this.updateCategoriesValidateBeforeCall(categoriesPerCatalog, null);
        Type localVarReturnType = new TypeToken<List<CategoryUpdatesPerCatalog>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateCategoriesAsync(List<CategoryUpdatesPerCatalog> categoriesPerCatalog, ApiCallback<List<CategoryUpdatesPerCatalog>> _callback) throws ApiException {
        Call localVarCall = this.updateCategoriesValidateBeforeCall(categoriesPerCatalog, _callback);
        Type localVarReturnType = new TypeToken<List<CategoryUpdatesPerCatalog>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

