/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing.api;

import com.criteo.marketing.ApiCallback;
import com.criteo.marketing.ApiClient;
import com.criteo.marketing.ApiException;
import com.criteo.marketing.ApiResponse;
import com.criteo.marketing.Configuration;
import com.criteo.marketing.Pair;
import com.criteo.marketing.model.JwtModel;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class OAuthApi {
    private ApiClient localVarApiClient;

    public OAuthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OAuthApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createTokenCall(String clientId, String clientSecret, String grantType, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/oauth2/token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (clientId != null) {
            localVarFormParams.put("client_id", clientId);
        }
        if (clientSecret != null) {
            localVarFormParams.put("client_secret", clientSecret);
        }
        if (grantType != null) {
            localVarFormParams.put("grant_type", grantType);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"text/plain", "application/json", "text/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTokenValidateBeforeCall(String clientId, String clientSecret, String grantType, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.createTokenCall(clientId, clientSecret, grantType, _callback);
        return localVarCall;
    }

    public JwtModel createToken(String clientId, String clientSecret, String grantType) throws ApiException {
        ApiResponse<JwtModel> localVarResp = this.createTokenWithHttpInfo(clientId, clientSecret, grantType);
        return localVarResp.getData();
    }

    public ApiResponse<JwtModel> createTokenWithHttpInfo(String clientId, String clientSecret, String grantType) throws ApiException {
        Call localVarCall = this.createTokenValidateBeforeCall(clientId, clientSecret, grantType, null);
        Type localVarReturnType = new TypeToken<JwtModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createTokenAsync(String clientId, String clientSecret, String grantType, ApiCallback<JwtModel> _callback) throws ApiException {
        Call localVarCall = this.createTokenValidateBeforeCall(clientId, clientSecret, grantType, _callback);
        Type localVarReturnType = new TypeToken<JwtModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

