/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ad set delivery limitations model")
public class AdSetDeliveryLimitations {
    public static final String SERIALIZED_NAME_ENVIRONMENTS = "environments";
    @SerializedName(value="environments")
    private List<EnvironmentsEnum> environments = null;
    public static final String SERIALIZED_NAME_DEVICES = "devices";
    @SerializedName(value="devices")
    private List<DevicesEnum> devices = null;
    public static final String SERIALIZED_NAME_OPERATING_SYSTEMS = "operatingSystems";
    @SerializedName(value="operatingSystems")
    private List<OperatingSystemsEnum> operatingSystems = null;

    public AdSetDeliveryLimitations environments(List<EnvironmentsEnum> environments) {
        this.environments = environments;
        return this;
    }

    public AdSetDeliveryLimitations addEnvironmentsItem(EnvironmentsEnum environmentsItem) {
        if (this.environments == null) {
            this.environments = new ArrayList<EnvironmentsEnum>();
        }
        this.environments.add(environmentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of environments which the ad set should target")
    public List<EnvironmentsEnum> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(List<EnvironmentsEnum> environments) {
        this.environments = environments;
    }

    public AdSetDeliveryLimitations devices(List<DevicesEnum> devices) {
        this.devices = devices;
        return this;
    }

    public AdSetDeliveryLimitations addDevicesItem(DevicesEnum devicesItem) {
        if (this.devices == null) {
            this.devices = new ArrayList<DevicesEnum>();
        }
        this.devices.add(devicesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of devices which the ad set should target")
    public List<DevicesEnum> getDevices() {
        return this.devices;
    }

    public void setDevices(List<DevicesEnum> devices) {
        this.devices = devices;
    }

    public AdSetDeliveryLimitations operatingSystems(List<OperatingSystemsEnum> operatingSystems) {
        this.operatingSystems = operatingSystems;
        return this;
    }

    public AdSetDeliveryLimitations addOperatingSystemsItem(OperatingSystemsEnum operatingSystemsItem) {
        if (this.operatingSystems == null) {
            this.operatingSystems = new ArrayList<OperatingSystemsEnum>();
        }
        this.operatingSystems.add(operatingSystemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of operating systems which the ad set should target")
    public List<OperatingSystemsEnum> getOperatingSystems() {
        return this.operatingSystems;
    }

    public void setOperatingSystems(List<OperatingSystemsEnum> operatingSystems) {
        this.operatingSystems = operatingSystems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdSetDeliveryLimitations adSetDeliveryLimitations = (AdSetDeliveryLimitations)o;
        return Objects.equals(this.environments, adSetDeliveryLimitations.environments) && Objects.equals(this.devices, adSetDeliveryLimitations.devices) && Objects.equals(this.operatingSystems, adSetDeliveryLimitations.operatingSystems);
    }

    public int hashCode() {
        return Objects.hash(this.environments, this.devices, this.operatingSystems);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdSetDeliveryLimitations {\n");
        sb.append("    environments: ").append(this.toIndentedString(this.environments)).append("\n");
        sb.append("    devices: ").append(this.toIndentedString(this.devices)).append("\n");
        sb.append("    operatingSystems: ").append(this.toIndentedString(this.operatingSystems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OperatingSystemsEnum {
        ANDROID("android"),
        IOS("ios"),
        UNKNOWN("unknown");

        private String value;

        private OperatingSystemsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OperatingSystemsEnum fromValue(String value) {
            for (OperatingSystemsEnum b : OperatingSystemsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<OperatingSystemsEnum> {
            public void write(JsonWriter jsonWriter, OperatingSystemsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OperatingSystemsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OperatingSystemsEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DevicesEnum {
        OTHER("other"),
        DESKTOP("desktop"),
        MOBILE("mobile"),
        TABLET("tablet");

        private String value;

        private DevicesEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DevicesEnum fromValue(String value) {
            for (DevicesEnum b : DevicesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DevicesEnum> {
            public void write(JsonWriter jsonWriter, DevicesEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DevicesEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DevicesEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EnvironmentsEnum {
        WEB("web"),
        INAPP("inApp");

        private String value;

        private EnvironmentsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EnvironmentsEnum fromValue(String value) {
            for (EnvironmentsEnum b : EnvironmentsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<EnvironmentsEnum> {
            public void write(JsonWriter jsonWriter, EnvironmentsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EnvironmentsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EnvironmentsEnum.fromValue(value);
            }
        }
    }
}

