/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ad set targeting rule model")
public class AdSetTargetingRule {
    public static final String SERIALIZED_NAME_OPERAND = "operand";
    @SerializedName(value="operand")
    private OperandEnum operand;
    public static final String SERIALIZED_NAME_VALUES = "values";
    @SerializedName(value="values")
    private List<String> values = null;

    public AdSetTargetingRule operand(OperandEnum operand) {
        this.operand = operand;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Operand which states how the values should be applied")
    public OperandEnum getOperand() {
        return this.operand;
    }

    public void setOperand(OperandEnum operand) {
        this.operand = operand;
    }

    public AdSetTargetingRule values(List<String> values) {
        this.values = values;
        return this;
    }

    public AdSetTargetingRule addValuesItem(String valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of values to apply")
    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdSetTargetingRule adSetTargetingRule = (AdSetTargetingRule)o;
        return Objects.equals((Object)this.operand, (Object)adSetTargetingRule.operand) && Objects.equals(this.values, adSetTargetingRule.values);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operand, this.values});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdSetTargetingRule {\n");
        sb.append("    operand: ").append(this.toIndentedString((Object)this.operand)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OperandEnum {
        UNDEFINED("undefined"),
        IN("in"),
        NOTIN("notIn");

        private String value;

        private OperandEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OperandEnum fromValue(String value) {
            for (OperandEnum b : OperandEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<OperandEnum> {
            public void write(JsonWriter jsonWriter, OperandEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OperandEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OperandEnum.fromValue(value);
            }
        }
    }
}

