/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Definition of the warning")
public class AudienceWarning {
    public static final String SERIALIZED_NAME_TRACE_ID = "traceId";
    @SerializedName(value="traceId")
    private String traceId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_CODE = "code";
    @SerializedName(value="code")
    private String code;
    public static final String SERIALIZED_NAME_INSTANCE = "instance";
    @SerializedName(value="instance")
    private String instance;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_DETAIL = "detail";
    @SerializedName(value="detail")
    private String detail;
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    private Object source;
    public static final String SERIALIZED_NAME_STACK_TRACE = "stackTrace";
    @SerializedName(value="stackTrace")
    private List<String> stackTrace = null;

    public AudienceWarning traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="(REQUIRED) The Correlation ID provided by the Gateway. It is also a unique identifier for this particular occurrence of the problem.")
    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public AudienceWarning type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="(REQUIRED) The classification of the error")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public AudienceWarning code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(required=true, value="(REQUIRED) A machine-readable unique error code, expressed as a string value. The format used must be kebab-case.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public AudienceWarning instance(String instance) {
        this.instance = instance;
        return this;
    }

    @ApiModelProperty(required=true, value="(REQUIRED) A URI reference that identifies the specific occurrence of the problem")
    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public AudienceWarning title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="(RECOMMENDED) A short, human-readable summary of the problem type")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public AudienceWarning detail(String detail) {
        this.detail = detail;
        return this;
    }

    @ApiModelProperty(required=true, value="(REQUIRED) A human-readable explanation specific to this occurrence of the problem")
    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public AudienceWarning source(Object source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="(OPTIONAL) A machine-readable structure to reference to the exact location(s) causing the error(s)")
    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public AudienceWarning stackTrace(List<String> stackTrace) {
        this.stackTrace = stackTrace;
        return this;
    }

    public AudienceWarning addStackTraceItem(String stackTraceItem) {
        if (this.stackTrace == null) {
            this.stackTrace = new ArrayList<String>();
        }
        this.stackTrace.add(stackTraceItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="(NEVER IN PRODUCTION) A human-readable stacktrace produced by the implementation technology")
    public List<String> getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(List<String> stackTrace) {
        this.stackTrace = stackTrace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudienceWarning audienceWarning = (AudienceWarning)o;
        return Objects.equals(this.traceId, audienceWarning.traceId) && Objects.equals((Object)this.type, (Object)audienceWarning.type) && Objects.equals(this.code, audienceWarning.code) && Objects.equals(this.instance, audienceWarning.instance) && Objects.equals(this.title, audienceWarning.title) && Objects.equals(this.detail, audienceWarning.detail) && Objects.equals(this.source, audienceWarning.source) && Objects.equals(this.stackTrace, audienceWarning.stackTrace);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.traceId, this.type, this.code, this.instance, this.title, this.detail, this.source, this.stackTrace});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AudienceWarning {\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    instance: ").append(this.toIndentedString(this.instance)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    stackTrace: ").append(this.toIndentedString(this.stackTrace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        ACCESS_CONTROL("access-control"),
        AUTHENTICATION("authentication"),
        AUTHORIZATION("authorization"),
        AVAILABILITY("availability"),
        DEPRECATION("deprecation"),
        QUOTA("quota"),
        VALIDATION("validation");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

