/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing.model;

import com.criteo.marketing.model.AdSetTargeting;
import com.criteo.marketing.model.ReadAdSetBidding;
import com.criteo.marketing.model.ReadAdSetBudget;
import com.criteo.marketing.model.ReadAdSetSchedule;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ad set read model")
public class ReadAdSet {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_ADVERTISER_ID = "advertiserId";
    @SerializedName(value="advertiserId")
    private String advertiserId;
    public static final String SERIALIZED_NAME_CAMPAIGN_ID = "campaignId";
    @SerializedName(value="campaignId")
    private String campaignId;
    public static final String SERIALIZED_NAME_DESTINATION_ENVIRONMENT = "destinationEnvironment";
    @SerializedName(value="destinationEnvironment")
    private DestinationEnvironmentEnum destinationEnvironment;
    public static final String SERIALIZED_NAME_SCHEDULE = "schedule";
    @SerializedName(value="schedule")
    private ReadAdSetSchedule schedule;
    public static final String SERIALIZED_NAME_BIDDING = "bidding";
    @SerializedName(value="bidding")
    private ReadAdSetBidding bidding;
    public static final String SERIALIZED_NAME_TARGETING = "targeting";
    @SerializedName(value="targeting")
    private AdSetTargeting targeting;
    public static final String SERIALIZED_NAME_BUDGET = "budget";
    @SerializedName(value="budget")
    private ReadAdSetBudget budget;

    public ReadAdSet name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the ad set")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ReadAdSet advertiserId(String advertiserId) {
        this.advertiserId = advertiserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Advertiser id of the campaign this ad set belongs to")
    public String getAdvertiserId() {
        return this.advertiserId;
    }

    public void setAdvertiserId(String advertiserId) {
        this.advertiserId = advertiserId;
    }

    public ReadAdSet campaignId(String campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Campaign id this ad set belongs to")
    public String getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public ReadAdSet destinationEnvironment(DestinationEnvironmentEnum destinationEnvironment) {
        this.destinationEnvironment = destinationEnvironment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The environment that an ad click will lead a user to")
    public DestinationEnvironmentEnum getDestinationEnvironment() {
        return this.destinationEnvironment;
    }

    public void setDestinationEnvironment(DestinationEnvironmentEnum destinationEnvironment) {
        this.destinationEnvironment = destinationEnvironment;
    }

    public ReadAdSet schedule(ReadAdSetSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ReadAdSetSchedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(ReadAdSetSchedule schedule) {
        this.schedule = schedule;
    }

    public ReadAdSet bidding(ReadAdSetBidding bidding) {
        this.bidding = bidding;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ReadAdSetBidding getBidding() {
        return this.bidding;
    }

    public void setBidding(ReadAdSetBidding bidding) {
        this.bidding = bidding;
    }

    public ReadAdSet targeting(AdSetTargeting targeting) {
        this.targeting = targeting;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AdSetTargeting getTargeting() {
        return this.targeting;
    }

    public void setTargeting(AdSetTargeting targeting) {
        this.targeting = targeting;
    }

    public ReadAdSet budget(ReadAdSetBudget budget) {
        this.budget = budget;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ReadAdSetBudget getBudget() {
        return this.budget;
    }

    public void setBudget(ReadAdSetBudget budget) {
        this.budget = budget;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadAdSet readAdSet = (ReadAdSet)o;
        return Objects.equals(this.name, readAdSet.name) && Objects.equals(this.advertiserId, readAdSet.advertiserId) && Objects.equals(this.campaignId, readAdSet.campaignId) && Objects.equals((Object)this.destinationEnvironment, (Object)readAdSet.destinationEnvironment) && Objects.equals(this.schedule, readAdSet.schedule) && Objects.equals(this.bidding, readAdSet.bidding) && Objects.equals(this.targeting, readAdSet.targeting) && Objects.equals(this.budget, readAdSet.budget);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.advertiserId, this.campaignId, this.destinationEnvironment, this.schedule, this.bidding, this.targeting, this.budget});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReadAdSet {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    advertiserId: ").append(this.toIndentedString(this.advertiserId)).append("\n");
        sb.append("    campaignId: ").append(this.toIndentedString(this.campaignId)).append("\n");
        sb.append("    destinationEnvironment: ").append(this.toIndentedString((Object)this.destinationEnvironment)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    bidding: ").append(this.toIndentedString(this.bidding)).append("\n");
        sb.append("    targeting: ").append(this.toIndentedString(this.targeting)).append("\n");
        sb.append("    budget: ").append(this.toIndentedString(this.budget)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DestinationEnvironmentEnum {
        UNDEFINED("undefined"),
        WEB("web"),
        APP("app");

        private String value;

        private DestinationEnvironmentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DestinationEnvironmentEnum fromValue(String value) {
            for (DestinationEnvironmentEnum b : DestinationEnvironmentEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DestinationEnvironmentEnum> {
            public void write(JsonWriter jsonWriter, DestinationEnvironmentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DestinationEnvironmentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DestinationEnvironmentEnum.fromValue(value);
            }
        }
    }
}

