/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing.model;

import com.criteo.marketing.model.NillableDecimal;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ad set bidding read model")
public class ReadAdSetBidding {
    public static final String SERIALIZED_NAME_BID_AMOUNT = "bidAmount";
    @SerializedName(value="bidAmount")
    private NillableDecimal bidAmount;
    public static final String SERIALIZED_NAME_BID_STRATEGY = "bidStrategy";
    @SerializedName(value="bidStrategy")
    private BidStrategyEnum bidStrategy;
    public static final String SERIALIZED_NAME_COST_CONTROLLER = "costController";
    @SerializedName(value="costController")
    private CostControllerEnum costController;

    public ReadAdSetBidding bidAmount(NillableDecimal bidAmount) {
        this.bidAmount = bidAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public NillableDecimal getBidAmount() {
        return this.bidAmount;
    }

    public void setBidAmount(NillableDecimal bidAmount) {
        this.bidAmount = bidAmount;
    }

    public ReadAdSetBidding bidStrategy(BidStrategyEnum bidStrategy) {
        this.bidStrategy = bidStrategy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The intended optimization for the Ad Set")
    public BidStrategyEnum getBidStrategy() {
        return this.bidStrategy;
    }

    public void setBidStrategy(BidStrategyEnum bidStrategy) {
        this.bidStrategy = bidStrategy;
    }

    public ReadAdSetBidding costController(CostControllerEnum costController) {
        this.costController = costController;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="How is spend controlled")
    public CostControllerEnum getCostController() {
        return this.costController;
    }

    public void setCostController(CostControllerEnum costController) {
        this.costController = costController;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadAdSetBidding readAdSetBidding = (ReadAdSetBidding)o;
        return Objects.equals(this.bidAmount, readAdSetBidding.bidAmount) && Objects.equals((Object)this.bidStrategy, (Object)readAdSetBidding.bidStrategy) && Objects.equals((Object)this.costController, (Object)readAdSetBidding.costController);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bidAmount, this.bidStrategy, this.costController});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReadAdSetBidding {\n");
        sb.append("    bidAmount: ").append(this.toIndentedString(this.bidAmount)).append("\n");
        sb.append("    bidStrategy: ").append(this.toIndentedString((Object)this.bidStrategy)).append("\n");
        sb.append("    costController: ").append(this.toIndentedString((Object)this.costController)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CostControllerEnum {
        COS("COS"),
        CPC("CPC"),
        CPI("CPI"),
        CPM("CPM"),
        CPO("CPO"),
        CPSV("CPSV"),
        CPV("CPV"),
        DAILYBUDGET("dailyBudget");

        private String value;

        private CostControllerEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CostControllerEnum fromValue(String value) {
            for (CostControllerEnum b : CostControllerEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CostControllerEnum> {
            public void write(JsonWriter jsonWriter, CostControllerEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CostControllerEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CostControllerEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BidStrategyEnum {
        ACTIONS("actions"),
        CLICKS("clicks"),
        CONVERSIONS("conversions"),
        DISPLAYS("displays"),
        INSTALLS("installs"),
        REVENUE("revenue"),
        STORECONVERSIONS("storeConversions"),
        VALUE("value"),
        VIEWEDIMPRESSIONS("viewedImpressions"),
        VISITS("Visits"),
        COMPLETEDVIDEOVIEWS("completedVideoViews");

        private String value;

        private BidStrategyEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BidStrategyEnum fromValue(String value) {
            for (BidStrategyEnum b : BidStrategyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<BidStrategyEnum> {
            public void write(JsonWriter jsonWriter, BidStrategyEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BidStrategyEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BidStrategyEnum.fromValue(value);
            }
        }
    }
}

