/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing.model;

import com.criteo.marketing.model.NillableDecimal;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ad set budget read model")
public class ReadAdSetBudget {
    public static final String SERIALIZED_NAME_BUDGET_STRATEGY = "budgetStrategy";
    @SerializedName(value="budgetStrategy")
    private BudgetStrategyEnum budgetStrategy;
    public static final String SERIALIZED_NAME_BUDGET_RENEWAL = "budgetRenewal";
    @SerializedName(value="budgetRenewal")
    private BudgetRenewalEnum budgetRenewal;
    public static final String SERIALIZED_NAME_BUDGET_DELIVERY_SMOOTHING = "budgetDeliverySmoothing";
    @SerializedName(value="budgetDeliverySmoothing")
    private BudgetDeliverySmoothingEnum budgetDeliverySmoothing;
    public static final String SERIALIZED_NAME_BUDGET_DELIVERY_WEEK = "budgetDeliveryWeek";
    @SerializedName(value="budgetDeliveryWeek")
    private BudgetDeliveryWeekEnum budgetDeliveryWeek;
    public static final String SERIALIZED_NAME_BUDGET_AMOUNT = "budgetAmount";
    @SerializedName(value="budgetAmount")
    private NillableDecimal budgetAmount;

    public ReadAdSetBudget budgetStrategy(BudgetStrategyEnum budgetStrategy) {
        this.budgetStrategy = budgetStrategy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether your budget is capped or not")
    public BudgetStrategyEnum getBudgetStrategy() {
        return this.budgetStrategy;
    }

    public void setBudgetStrategy(BudgetStrategyEnum budgetStrategy) {
        this.budgetStrategy = budgetStrategy;
    }

    public ReadAdSetBudget budgetRenewal(BudgetRenewalEnum budgetRenewal) {
        this.budgetRenewal = budgetRenewal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The pace of the budget renewal")
    public BudgetRenewalEnum getBudgetRenewal() {
        return this.budgetRenewal;
    }

    public void setBudgetRenewal(BudgetRenewalEnum budgetRenewal) {
        this.budgetRenewal = budgetRenewal;
    }

    public ReadAdSetBudget budgetDeliverySmoothing(BudgetDeliverySmoothingEnum budgetDeliverySmoothing) {
        this.budgetDeliverySmoothing = budgetDeliverySmoothing;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The pace at which the budget can be spent")
    public BudgetDeliverySmoothingEnum getBudgetDeliverySmoothing() {
        return this.budgetDeliverySmoothing;
    }

    public void setBudgetDeliverySmoothing(BudgetDeliverySmoothingEnum budgetDeliverySmoothing) {
        this.budgetDeliverySmoothing = budgetDeliverySmoothing;
    }

    public ReadAdSetBudget budgetDeliveryWeek(BudgetDeliveryWeekEnum budgetDeliveryWeek) {
        this.budgetDeliveryWeek = budgetDeliveryWeek;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The delivery week for the budget")
    public BudgetDeliveryWeekEnum getBudgetDeliveryWeek() {
        return this.budgetDeliveryWeek;
    }

    public void setBudgetDeliveryWeek(BudgetDeliveryWeekEnum budgetDeliveryWeek) {
        this.budgetDeliveryWeek = budgetDeliveryWeek;
    }

    public ReadAdSetBudget budgetAmount(NillableDecimal budgetAmount) {
        this.budgetAmount = budgetAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public NillableDecimal getBudgetAmount() {
        return this.budgetAmount;
    }

    public void setBudgetAmount(NillableDecimal budgetAmount) {
        this.budgetAmount = budgetAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadAdSetBudget readAdSetBudget = (ReadAdSetBudget)o;
        return Objects.equals((Object)this.budgetStrategy, (Object)readAdSetBudget.budgetStrategy) && Objects.equals((Object)this.budgetRenewal, (Object)readAdSetBudget.budgetRenewal) && Objects.equals((Object)this.budgetDeliverySmoothing, (Object)readAdSetBudget.budgetDeliverySmoothing) && Objects.equals((Object)this.budgetDeliveryWeek, (Object)readAdSetBudget.budgetDeliveryWeek) && Objects.equals(this.budgetAmount, readAdSetBudget.budgetAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.budgetStrategy, this.budgetRenewal, this.budgetDeliverySmoothing, this.budgetDeliveryWeek, this.budgetAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReadAdSetBudget {\n");
        sb.append("    budgetStrategy: ").append(this.toIndentedString((Object)this.budgetStrategy)).append("\n");
        sb.append("    budgetRenewal: ").append(this.toIndentedString((Object)this.budgetRenewal)).append("\n");
        sb.append("    budgetDeliverySmoothing: ").append(this.toIndentedString((Object)this.budgetDeliverySmoothing)).append("\n");
        sb.append("    budgetDeliveryWeek: ").append(this.toIndentedString((Object)this.budgetDeliveryWeek)).append("\n");
        sb.append("    budgetAmount: ").append(this.toIndentedString(this.budgetAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BudgetDeliveryWeekEnum {
        UNDEFINED("undefined"),
        MONDAYTOSUNDAY("mondayToSunday"),
        TUESDAYTOMONDAY("tuesdayToMonday"),
        WEDNESDAYTOTUESDAY("wednesdayToTuesday"),
        THURSDAYTOWEDNESDAY("thursdayToWednesday"),
        FRIDAYTOTHURSDAY("fridayToThursday"),
        SATURDAYTOFRIDAY("saturdayToFriday"),
        SUNDAYTOSATURDAY("sundayToSaturday");

        private String value;

        private BudgetDeliveryWeekEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BudgetDeliveryWeekEnum fromValue(String value) {
            for (BudgetDeliveryWeekEnum b : BudgetDeliveryWeekEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<BudgetDeliveryWeekEnum> {
            public void write(JsonWriter jsonWriter, BudgetDeliveryWeekEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BudgetDeliveryWeekEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BudgetDeliveryWeekEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BudgetDeliverySmoothingEnum {
        ACCELERATED("accelerated"),
        STANDARD("standard");

        private String value;

        private BudgetDeliverySmoothingEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BudgetDeliverySmoothingEnum fromValue(String value) {
            for (BudgetDeliverySmoothingEnum b : BudgetDeliverySmoothingEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<BudgetDeliverySmoothingEnum> {
            public void write(JsonWriter jsonWriter, BudgetDeliverySmoothingEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BudgetDeliverySmoothingEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BudgetDeliverySmoothingEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BudgetRenewalEnum {
        UNDEFINED("undefined"),
        DAILY("daily"),
        MONTHLY("monthly"),
        LIFETIME("lifetime");

        private String value;

        private BudgetRenewalEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BudgetRenewalEnum fromValue(String value) {
            for (BudgetRenewalEnum b : BudgetRenewalEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<BudgetRenewalEnum> {
            public void write(JsonWriter jsonWriter, BudgetRenewalEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BudgetRenewalEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BudgetRenewalEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BudgetStrategyEnum {
        CAPPED("capped"),
        UNCAPPED("uncapped");

        private String value;

        private BudgetStrategyEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BudgetStrategyEnum fromValue(String value) {
            for (BudgetStrategyEnum b : BudgetStrategyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<BudgetStrategyEnum> {
            public void write(JsonWriter jsonWriter, BudgetStrategyEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BudgetStrategyEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BudgetStrategyEnum.fromValue(value);
            }
        }
    }
}

