/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="This is the message defining the query for Adset report")
public class StatisticsReportQueryMessage {
    public static final String SERIALIZED_NAME_ADVERTISER_IDS = "advertiserIds";
    @SerializedName(value="advertiserIds")
    private String advertiserIds;
    public static final String SERIALIZED_NAME_DIMENSIONS = "dimensions";
    @SerializedName(value="dimensions")
    private List<DimensionsEnum> dimensions = new ArrayList<DimensionsEnum>();
    public static final String SERIALIZED_NAME_METRICS = "metrics";
    @SerializedName(value="metrics")
    private List<String> metrics = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_FORMAT = "format";
    @SerializedName(value="format")
    private String format;
    public static final String SERIALIZED_NAME_TIMEZONE = "timezone";
    @SerializedName(value="timezone")
    private String timezone = "UTC";
    public static final String SERIALIZED_NAME_START_DATE = "startDate";
    @SerializedName(value="startDate")
    private OffsetDateTime startDate;
    public static final String SERIALIZED_NAME_END_DATE = "endDate";
    @SerializedName(value="endDate")
    private OffsetDateTime endDate;

    public StatisticsReportQueryMessage advertiserIds(String advertiserIds) {
        this.advertiserIds = advertiserIds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The comma-separated list of advertiser ids. If empty, all the advertisers in the portfolio will be used")
    public String getAdvertiserIds() {
        return this.advertiserIds;
    }

    public void setAdvertiserIds(String advertiserIds) {
        this.advertiserIds = advertiserIds;
    }

    public StatisticsReportQueryMessage dimensions(List<DimensionsEnum> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public StatisticsReportQueryMessage addDimensionsItem(DimensionsEnum dimensionsItem) {
        this.dimensions.add(dimensionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The dimensions for the report.")
    public List<DimensionsEnum> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(List<DimensionsEnum> dimensions) {
        this.dimensions = dimensions;
    }

    public StatisticsReportQueryMessage metrics(List<String> metrics) {
        this.metrics = metrics;
        return this;
    }

    public StatisticsReportQueryMessage addMetricsItem(String metricsItem) {
        this.metrics.add(metricsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The list of metrics to report.")
    public List<String> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<String> metrics) {
        this.metrics = metrics;
    }

    public StatisticsReportQueryMessage currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="The currency used for the report. ISO 4217 code (three-letter capitals).")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public StatisticsReportQueryMessage format(String format) {
        this.format = format;
        return this;
    }

    @ApiModelProperty(required=true, value="The file format of the generated report: csv, xml, excel or json.")
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public StatisticsReportQueryMessage timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The timezone used for the report. Timezone Database format (Tz).")
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public StatisticsReportQueryMessage startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Start date of the report. Date component of ISO 8061 format, any time or timezone component is ignored.")
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public StatisticsReportQueryMessage endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(required=true, value="End date of the report. Date component of ISO 8061 format, any time or timezone component is ignored.")
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatisticsReportQueryMessage statisticsReportQueryMessage = (StatisticsReportQueryMessage)o;
        return Objects.equals(this.advertiserIds, statisticsReportQueryMessage.advertiserIds) && Objects.equals(this.dimensions, statisticsReportQueryMessage.dimensions) && Objects.equals(this.metrics, statisticsReportQueryMessage.metrics) && Objects.equals(this.currency, statisticsReportQueryMessage.currency) && Objects.equals(this.format, statisticsReportQueryMessage.format) && Objects.equals(this.timezone, statisticsReportQueryMessage.timezone) && Objects.equals(this.startDate, statisticsReportQueryMessage.startDate) && Objects.equals(this.endDate, statisticsReportQueryMessage.endDate);
    }

    public int hashCode() {
        return Objects.hash(this.advertiserIds, this.dimensions, this.metrics, this.currency, this.format, this.timezone, this.startDate, this.endDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StatisticsReportQueryMessage {\n");
        sb.append("    advertiserIds: ").append(this.toIndentedString(this.advertiserIds)).append("\n");
        sb.append("    dimensions: ").append(this.toIndentedString(this.dimensions)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DimensionsEnum {
        ADSETID("AdsetId"),
        ADSET("Adset"),
        ADVERTISERID("AdvertiserId"),
        ADVERTISER("Advertiser"),
        CATEGORYID("CategoryId"),
        CATEGORY("Category"),
        HOUR("Hour"),
        DAY("Day"),
        WEEK("Week"),
        MONTH("Month"),
        YEAR("Year"),
        OS("Os"),
        DEVICE("Device");

        private String value;

        private DimensionsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DimensionsEnum fromValue(String value) {
            for (DimensionsEnum b : DimensionsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DimensionsEnum> {
            public void write(JsonWriter jsonWriter, DimensionsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DimensionsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DimensionsEnum.fromValue(value);
            }
        }
    }
}

