/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="This is the message defining the query for Transaction report")
public class TransactionsReportQueryMessage {
    public static final String SERIALIZED_NAME_ADVERTISER_IDS = "advertiserIds";
    @SerializedName(value="advertiserIds")
    private String advertiserIds;
    public static final String SERIALIZED_NAME_EVENT_TYPE = "eventType";
    @SerializedName(value="eventType")
    private String eventType;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_FORMAT = "format";
    @SerializedName(value="format")
    private String format;
    public static final String SERIALIZED_NAME_TIMEZONE = "timezone";
    @SerializedName(value="timezone")
    private String timezone = "UTC";
    public static final String SERIALIZED_NAME_START_DATE = "startDate";
    @SerializedName(value="startDate")
    private OffsetDateTime startDate;
    public static final String SERIALIZED_NAME_END_DATE = "endDate";
    @SerializedName(value="endDate")
    private OffsetDateTime endDate;

    public TransactionsReportQueryMessage advertiserIds(String advertiserIds) {
        this.advertiserIds = advertiserIds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The comma-separated list of advertiser ids. If empty, all the advertisers in the portfolio will be used")
    public String getAdvertiserIds() {
        return this.advertiserIds;
    }

    public void setAdvertiserIds(String advertiserIds) {
        this.advertiserIds = advertiserIds;
    }

    public TransactionsReportQueryMessage eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Apply a filter on Event type .")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public TransactionsReportQueryMessage currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="The currency used for the report. ISO 4217 code (three-letter capitals).")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public TransactionsReportQueryMessage format(String format) {
        this.format = format;
        return this;
    }

    @ApiModelProperty(required=true, value="The file format of the generated report: csv, xml, excel or json.")
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public TransactionsReportQueryMessage timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The timezone used for the report. Timezone Database format (Tz).")
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public TransactionsReportQueryMessage startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Start date of the report. Date component of ISO 8061 format, any time or timezone component is ignored.")
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public TransactionsReportQueryMessage endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(required=true, value="End date of the report. Date component of ISO 8061 format, any time or timezone component is ignored.")
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionsReportQueryMessage transactionsReportQueryMessage = (TransactionsReportQueryMessage)o;
        return Objects.equals(this.advertiserIds, transactionsReportQueryMessage.advertiserIds) && Objects.equals(this.eventType, transactionsReportQueryMessage.eventType) && Objects.equals(this.currency, transactionsReportQueryMessage.currency) && Objects.equals(this.format, transactionsReportQueryMessage.format) && Objects.equals(this.timezone, transactionsReportQueryMessage.timezone) && Objects.equals(this.startDate, transactionsReportQueryMessage.startDate) && Objects.equals(this.endDate, transactionsReportQueryMessage.endDate);
    }

    public int hashCode() {
        return Objects.hash(this.advertiserIds, this.eventType, this.currency, this.format, this.timezone, this.startDate, this.endDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionsReportQueryMessage {\n");
        sb.append("    advertiserIds: ").append(this.toIndentedString(this.advertiserIds)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

