/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing.api;

import com.criteo.marketing.ApiCallback;
import com.criteo.marketing.ApiClient;
import com.criteo.marketing.ApiException;
import com.criteo.marketing.ApiResponse;
import com.criteo.marketing.Configuration;
import com.criteo.marketing.Pair;
import com.criteo.marketing.model.CategoryMessage;
import com.criteo.marketing.model.GetPortfolioResponse;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class AdvertiserApi {
    private ApiClient localVarApiClient;

    public AdvertiserApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AdvertiserApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call apiPortfolioGetCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/2021-04/advertisers/me";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call apiPortfolioGetValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.apiPortfolioGetCall(_callback);
        return localVarCall;
    }

    public GetPortfolioResponse apiPortfolioGet() throws ApiException {
        ApiResponse<GetPortfolioResponse> localVarResp = this.apiPortfolioGetWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<GetPortfolioResponse> apiPortfolioGetWithHttpInfo() throws ApiException {
        Call localVarCall = this.apiPortfolioGetValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<GetPortfolioResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call apiPortfolioGetAsync(ApiCallback<GetPortfolioResponse> _callback) throws ApiException {
        Call localVarCall = this.apiPortfolioGetValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<GetPortfolioResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCategoriesCall(Integer advertiserId, Boolean enabledOnly, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/legacy/marketing/v1/advertisers/{advertiserId}/categories".replaceAll("\\{advertiserId\\}", this.localVarApiClient.escapeString(advertiserId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (enabledOnly != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("enabledOnly", enabledOnly));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml", "text/html"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCategoriesValidateBeforeCall(Integer advertiserId, Boolean enabledOnly, ApiCallback _callback) throws ApiException {
        if (advertiserId == null) {
            throw new ApiException("Missing the required parameter 'advertiserId' when calling getCategories(Async)");
        }
        Call localVarCall = this.getCategoriesCall(advertiserId, enabledOnly, _callback);
        return localVarCall;
    }

    public List<CategoryMessage> getCategories(Integer advertiserId, Boolean enabledOnly) throws ApiException {
        ApiResponse<List<CategoryMessage>> localVarResp = this.getCategoriesWithHttpInfo(advertiserId, enabledOnly);
        return localVarResp.getData();
    }

    public ApiResponse<List<CategoryMessage>> getCategoriesWithHttpInfo(Integer advertiserId, Boolean enabledOnly) throws ApiException {
        Call localVarCall = this.getCategoriesValidateBeforeCall(advertiserId, enabledOnly, null);
        Type localVarReturnType = new TypeToken<List<CategoryMessage>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCategoriesAsync(Integer advertiserId, Boolean enabledOnly, ApiCallback<List<CategoryMessage>> _callback) throws ApiException {
        Call localVarCall = this.getCategoriesValidateBeforeCall(advertiserId, enabledOnly, _callback);
        Type localVarReturnType = new TypeToken<List<CategoryMessage>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCategoryCall(Integer advertiserId, Integer categoryHashCode, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/legacy/marketing/v1/advertisers/{advertiserId}/categories/{categoryHashCode}".replaceAll("\\{advertiserId\\}", this.localVarApiClient.escapeString(advertiserId.toString())).replaceAll("\\{categoryHashCode\\}", this.localVarApiClient.escapeString(categoryHashCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml", "text/html"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCategoryValidateBeforeCall(Integer advertiserId, Integer categoryHashCode, ApiCallback _callback) throws ApiException {
        if (advertiserId == null) {
            throw new ApiException("Missing the required parameter 'advertiserId' when calling getCategory(Async)");
        }
        if (categoryHashCode == null) {
            throw new ApiException("Missing the required parameter 'categoryHashCode' when calling getCategory(Async)");
        }
        Call localVarCall = this.getCategoryCall(advertiserId, categoryHashCode, _callback);
        return localVarCall;
    }

    public List<CategoryMessage> getCategory(Integer advertiserId, Integer categoryHashCode) throws ApiException {
        ApiResponse<List<CategoryMessage>> localVarResp = this.getCategoryWithHttpInfo(advertiserId, categoryHashCode);
        return localVarResp.getData();
    }

    public ApiResponse<List<CategoryMessage>> getCategoryWithHttpInfo(Integer advertiserId, Integer categoryHashCode) throws ApiException {
        Call localVarCall = this.getCategoryValidateBeforeCall(advertiserId, categoryHashCode, null);
        Type localVarReturnType = new TypeToken<List<CategoryMessage>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCategoryAsync(Integer advertiserId, Integer categoryHashCode, ApiCallback<List<CategoryMessage>> _callback) throws ApiException {
        Call localVarCall = this.getCategoryValidateBeforeCall(advertiserId, categoryHashCode, _callback);
        Type localVarReturnType = new TypeToken<List<CategoryMessage>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

