/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing.api;

import com.criteo.marketing.ApiCallback;
import com.criteo.marketing.ApiClient;
import com.criteo.marketing.ApiException;
import com.criteo.marketing.ApiResponse;
import com.criteo.marketing.Configuration;
import com.criteo.marketing.Pair;
import com.criteo.marketing.model.ContactlistAmendmentRequest;
import com.criteo.marketing.model.DeleteAudienceContactListResponse;
import com.criteo.marketing.model.DeleteAudienceResponse;
import com.criteo.marketing.model.GetAudiencesResponse;
import com.criteo.marketing.model.ModifyAudienceResponse;
import com.criteo.marketing.model.NewAudienceRequest;
import com.criteo.marketing.model.NewAudienceResponse;
import com.criteo.marketing.model.ReplaceAudienceRequest;
import com.criteo.marketing.model.ReplaceAudienceResponse;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class AudienceApi {
    private ApiClient localVarApiClient;

    public AudienceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AudienceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createAudienceCall(NewAudienceRequest newAudienceRequest, ApiCallback _callback) throws ApiException {
        NewAudienceRequest localVarPostBody = newAudienceRequest;
        String localVarPath = "/2021-04/audiences";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createAudienceValidateBeforeCall(NewAudienceRequest newAudienceRequest, ApiCallback _callback) throws ApiException {
        if (newAudienceRequest == null) {
            throw new ApiException("Missing the required parameter 'newAudienceRequest' when calling createAudience(Async)");
        }
        Call localVarCall = this.createAudienceCall(newAudienceRequest, _callback);
        return localVarCall;
    }

    public NewAudienceResponse createAudience(NewAudienceRequest newAudienceRequest) throws ApiException {
        ApiResponse<NewAudienceResponse> localVarResp = this.createAudienceWithHttpInfo(newAudienceRequest);
        return localVarResp.getData();
    }

    public ApiResponse<NewAudienceResponse> createAudienceWithHttpInfo(NewAudienceRequest newAudienceRequest) throws ApiException {
        Call localVarCall = this.createAudienceValidateBeforeCall(newAudienceRequest, null);
        Type localVarReturnType = new TypeToken<NewAudienceResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createAudienceAsync(NewAudienceRequest newAudienceRequest, ApiCallback<NewAudienceResponse> _callback) throws ApiException {
        Call localVarCall = this.createAudienceValidateBeforeCall(newAudienceRequest, _callback);
        Type localVarReturnType = new TypeToken<NewAudienceResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteIdentifiersCall(String audienceId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/2021-04/audiences/{audience-id}/contactlist".replaceAll("\\{audience-id\\}", this.localVarApiClient.escapeString(audienceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteIdentifiersValidateBeforeCall(String audienceId, ApiCallback _callback) throws ApiException {
        if (audienceId == null) {
            throw new ApiException("Missing the required parameter 'audienceId' when calling deleteIdentifiers(Async)");
        }
        Call localVarCall = this.deleteIdentifiersCall(audienceId, _callback);
        return localVarCall;
    }

    public DeleteAudienceContactListResponse deleteIdentifiers(String audienceId) throws ApiException {
        ApiResponse<DeleteAudienceContactListResponse> localVarResp = this.deleteIdentifiersWithHttpInfo(audienceId);
        return localVarResp.getData();
    }

    public ApiResponse<DeleteAudienceContactListResponse> deleteIdentifiersWithHttpInfo(String audienceId) throws ApiException {
        Call localVarCall = this.deleteIdentifiersValidateBeforeCall(audienceId, null);
        Type localVarReturnType = new TypeToken<DeleteAudienceContactListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteIdentifiersAsync(String audienceId, ApiCallback<DeleteAudienceContactListResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteIdentifiersValidateBeforeCall(audienceId, _callback);
        Type localVarReturnType = new TypeToken<DeleteAudienceContactListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAudiencesCall(String advertiserId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/2021-04/audiences";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (advertiserId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("advertiser-id", advertiserId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAudiencesValidateBeforeCall(String advertiserId, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAudiencesCall(advertiserId, _callback);
        return localVarCall;
    }

    public GetAudiencesResponse getAudiences(String advertiserId) throws ApiException {
        ApiResponse<GetAudiencesResponse> localVarResp = this.getAudiencesWithHttpInfo(advertiserId);
        return localVarResp.getData();
    }

    public ApiResponse<GetAudiencesResponse> getAudiencesWithHttpInfo(String advertiserId) throws ApiException {
        Call localVarCall = this.getAudiencesValidateBeforeCall(advertiserId, null);
        Type localVarReturnType = new TypeToken<GetAudiencesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAudiencesAsync(String advertiserId, ApiCallback<GetAudiencesResponse> _callback) throws ApiException {
        Call localVarCall = this.getAudiencesValidateBeforeCall(advertiserId, _callback);
        Type localVarReturnType = new TypeToken<GetAudiencesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call modifyAudienceCall(String audienceId, ReplaceAudienceRequest replaceAudienceRequest, ApiCallback _callback) throws ApiException {
        ReplaceAudienceRequest localVarPostBody = replaceAudienceRequest;
        String localVarPath = "/2021-04/audiences/{audience-id}".replaceAll("\\{audience-id\\}", this.localVarApiClient.escapeString(audienceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call modifyAudienceValidateBeforeCall(String audienceId, ReplaceAudienceRequest replaceAudienceRequest, ApiCallback _callback) throws ApiException {
        if (audienceId == null) {
            throw new ApiException("Missing the required parameter 'audienceId' when calling modifyAudience(Async)");
        }
        if (replaceAudienceRequest == null) {
            throw new ApiException("Missing the required parameter 'replaceAudienceRequest' when calling modifyAudience(Async)");
        }
        Call localVarCall = this.modifyAudienceCall(audienceId, replaceAudienceRequest, _callback);
        return localVarCall;
    }

    public ReplaceAudienceResponse modifyAudience(String audienceId, ReplaceAudienceRequest replaceAudienceRequest) throws ApiException {
        ApiResponse<ReplaceAudienceResponse> localVarResp = this.modifyAudienceWithHttpInfo(audienceId, replaceAudienceRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ReplaceAudienceResponse> modifyAudienceWithHttpInfo(String audienceId, ReplaceAudienceRequest replaceAudienceRequest) throws ApiException {
        Call localVarCall = this.modifyAudienceValidateBeforeCall(audienceId, replaceAudienceRequest, null);
        Type localVarReturnType = new TypeToken<ReplaceAudienceResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call modifyAudienceAsync(String audienceId, ReplaceAudienceRequest replaceAudienceRequest, ApiCallback<ReplaceAudienceResponse> _callback) throws ApiException {
        Call localVarCall = this.modifyAudienceValidateBeforeCall(audienceId, replaceAudienceRequest, _callback);
        Type localVarReturnType = new TypeToken<ReplaceAudienceResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call modifyAudienceUsersCall(String audienceId, ContactlistAmendmentRequest contactlistAmendmentRequest, ApiCallback _callback) throws ApiException {
        ContactlistAmendmentRequest localVarPostBody = contactlistAmendmentRequest;
        String localVarPath = "/2021-04/audiences/{audience-id}/contactlist".replaceAll("\\{audience-id\\}", this.localVarApiClient.escapeString(audienceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call modifyAudienceUsersValidateBeforeCall(String audienceId, ContactlistAmendmentRequest contactlistAmendmentRequest, ApiCallback _callback) throws ApiException {
        if (audienceId == null) {
            throw new ApiException("Missing the required parameter 'audienceId' when calling modifyAudienceUsers(Async)");
        }
        if (contactlistAmendmentRequest == null) {
            throw new ApiException("Missing the required parameter 'contactlistAmendmentRequest' when calling modifyAudienceUsers(Async)");
        }
        Call localVarCall = this.modifyAudienceUsersCall(audienceId, contactlistAmendmentRequest, _callback);
        return localVarCall;
    }

    public ModifyAudienceResponse modifyAudienceUsers(String audienceId, ContactlistAmendmentRequest contactlistAmendmentRequest) throws ApiException {
        ApiResponse<ModifyAudienceResponse> localVarResp = this.modifyAudienceUsersWithHttpInfo(audienceId, contactlistAmendmentRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ModifyAudienceResponse> modifyAudienceUsersWithHttpInfo(String audienceId, ContactlistAmendmentRequest contactlistAmendmentRequest) throws ApiException {
        Call localVarCall = this.modifyAudienceUsersValidateBeforeCall(audienceId, contactlistAmendmentRequest, null);
        Type localVarReturnType = new TypeToken<ModifyAudienceResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call modifyAudienceUsersAsync(String audienceId, ContactlistAmendmentRequest contactlistAmendmentRequest, ApiCallback<ModifyAudienceResponse> _callback) throws ApiException {
        Call localVarCall = this.modifyAudienceUsersValidateBeforeCall(audienceId, contactlistAmendmentRequest, _callback);
        Type localVarReturnType = new TypeToken<ModifyAudienceResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call removeAudienceCall(String audienceId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/2021-04/audiences/{audience-id}".replaceAll("\\{audience-id\\}", this.localVarApiClient.escapeString(audienceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"Authorization"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call removeAudienceValidateBeforeCall(String audienceId, ApiCallback _callback) throws ApiException {
        if (audienceId == null) {
            throw new ApiException("Missing the required parameter 'audienceId' when calling removeAudience(Async)");
        }
        Call localVarCall = this.removeAudienceCall(audienceId, _callback);
        return localVarCall;
    }

    public DeleteAudienceResponse removeAudience(String audienceId) throws ApiException {
        ApiResponse<DeleteAudienceResponse> localVarResp = this.removeAudienceWithHttpInfo(audienceId);
        return localVarResp.getData();
    }

    public ApiResponse<DeleteAudienceResponse> removeAudienceWithHttpInfo(String audienceId) throws ApiException {
        Call localVarCall = this.removeAudienceValidateBeforeCall(audienceId, null);
        Type localVarReturnType = new TypeToken<DeleteAudienceResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call removeAudienceAsync(String audienceId, ApiCallback<DeleteAudienceResponse> _callback) throws ApiException {
        Call localVarCall = this.removeAudienceValidateBeforeCall(audienceId, _callback);
        Type localVarReturnType = new TypeToken<DeleteAudienceResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

