/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ad set frequency capping model")
public class AdSetFrequencyCapping {
    public static final String SERIALIZED_NAME_FREQUENCY = "frequency";
    @SerializedName(value="frequency")
    private FrequencyEnum frequency;
    public static final String SERIALIZED_NAME_MAXIMUM_IMPRESSIONS = "maximumImpressions";
    @SerializedName(value="maximumImpressions")
    private Integer maximumImpressions;

    public AdSetFrequencyCapping frequency(FrequencyEnum frequency) {
        this.frequency = frequency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Period on which impression limitation is calculated")
    public FrequencyEnum getFrequency() {
        return this.frequency;
    }

    public void setFrequency(FrequencyEnum frequency) {
        this.frequency = frequency;
    }

    public AdSetFrequencyCapping maximumImpressions(Integer maximumImpressions) {
        this.maximumImpressions = maximumImpressions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Maximum impressions for the specified period")
    public Integer getMaximumImpressions() {
        return this.maximumImpressions;
    }

    public void setMaximumImpressions(Integer maximumImpressions) {
        this.maximumImpressions = maximumImpressions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdSetFrequencyCapping adSetFrequencyCapping = (AdSetFrequencyCapping)o;
        return Objects.equals((Object)this.frequency, (Object)adSetFrequencyCapping.frequency) && Objects.equals(this.maximumImpressions, adSetFrequencyCapping.maximumImpressions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.frequency, this.maximumImpressions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdSetFrequencyCapping {\n");
        sb.append("    frequency: ").append(this.toIndentedString((Object)this.frequency)).append("\n");
        sb.append("    maximumImpressions: ").append(this.toIndentedString(this.maximumImpressions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FrequencyEnum {
        HOURLY("hourly"),
        DAILY("daily"),
        LIFETIME("lifetime"),
        ADVANCED("advanced");

        private String value;

        private FrequencyEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FrequencyEnum fromValue(String value) {
            for (FrequencyEnum b : FrequencyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<FrequencyEnum> {
            public void write(JsonWriter jsonWriter, FrequencyEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FrequencyEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FrequencyEnum.fromValue(value);
            }
        }
    }
}

