/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

public class AudienceAttributes {
    public static final String SERIALIZED_NAME_ADVERTISER_ID = "advertiserId";
    @SerializedName(value="advertiserId")
    private String advertiserId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_CREATED = "created";
    @SerializedName(value="created")
    private OffsetDateTime created;
    public static final String SERIALIZED_NAME_UPDATED = "updated";
    @SerializedName(value="updated")
    private OffsetDateTime updated;
    public static final String SERIALIZED_NAME_NB_LINES = "nbLines";
    @SerializedName(value="nbLines")
    private Integer nbLines;
    public static final String SERIALIZED_NAME_NB_LINES_EMAIL = "nbLinesEmail";
    @SerializedName(value="nbLinesEmail")
    private Integer nbLinesEmail;
    public static final String SERIALIZED_NAME_NB_MATCHES_EMAIL = "nbMatchesEmail";
    @SerializedName(value="nbMatchesEmail")
    private Integer nbMatchesEmail;

    public AudienceAttributes advertiserId(String advertiserId) {
        this.advertiserId = advertiserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The advertiser id that owns this Audience")
    public String getAdvertiserId() {
        return this.advertiserId;
    }

    public void setAdvertiserId(String advertiserId) {
        this.advertiserId = advertiserId;
    }

    public AudienceAttributes name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the Audience")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AudienceAttributes description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The string description of the Audience")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AudienceAttributes created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time ISO 8601 formatted string")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public AudienceAttributes updated(OffsetDateTime updated) {
        this.updated = updated;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time ISO 8601 formatted string")
    public OffsetDateTime getUpdated() {
        return this.updated;
    }

    public void setUpdated(OffsetDateTime updated) {
        this.updated = updated;
    }

    public AudienceAttributes nbLines(Integer nbLines) {
        this.nbLines = nbLines;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of line in the audience available once processed")
    public Integer getNbLines() {
        return this.nbLines;
    }

    public void setNbLines(Integer nbLines) {
        this.nbLines = nbLines;
    }

    public AudienceAttributes nbLinesEmail(Integer nbLinesEmail) {
        this.nbLinesEmail = nbLinesEmail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of email line in the audience available once processed")
    public Integer getNbLinesEmail() {
        return this.nbLinesEmail;
    }

    public void setNbLinesEmail(Integer nbLinesEmail) {
        this.nbLinesEmail = nbLinesEmail;
    }

    public AudienceAttributes nbMatchesEmail(Integer nbMatchesEmail) {
        this.nbMatchesEmail = nbMatchesEmail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of email matches in the audience available once processed")
    public Integer getNbMatchesEmail() {
        return this.nbMatchesEmail;
    }

    public void setNbMatchesEmail(Integer nbMatchesEmail) {
        this.nbMatchesEmail = nbMatchesEmail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudienceAttributes audienceAttributes = (AudienceAttributes)o;
        return Objects.equals(this.advertiserId, audienceAttributes.advertiserId) && Objects.equals(this.name, audienceAttributes.name) && Objects.equals(this.description, audienceAttributes.description) && Objects.equals(this.created, audienceAttributes.created) && Objects.equals(this.updated, audienceAttributes.updated) && Objects.equals(this.nbLines, audienceAttributes.nbLines) && Objects.equals(this.nbLinesEmail, audienceAttributes.nbLinesEmail) && Objects.equals(this.nbMatchesEmail, audienceAttributes.nbMatchesEmail);
    }

    public int hashCode() {
        return Objects.hash(this.advertiserId, this.name, this.description, this.created, this.updated, this.nbLines, this.nbLinesEmail, this.nbMatchesEmail);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AudienceAttributes {\n");
        sb.append("    advertiserId: ").append(this.toIndentedString(this.advertiserId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    updated: ").append(this.toIndentedString(this.updated)).append("\n");
        sb.append("    nbLines: ").append(this.toIndentedString(this.nbLines)).append("\n");
        sb.append("    nbLinesEmail: ").append(this.toIndentedString(this.nbLinesEmail)).append("\n");
        sb.append("    nbMatchesEmail: ").append(this.toIndentedString(this.nbMatchesEmail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

