/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing.model;

import com.criteo.marketing.model.CategoryUpdateError;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class CategoryUpdatesPerCatalogError {
    public static final String SERIALIZED_NAME_CATALOG_ID = "catalogId";
    @SerializedName(value="catalogId")
    private Integer catalogId;
    public static final String SERIALIZED_NAME_ERROR_CODE = "errorCode";
    @SerializedName(value="errorCode")
    private ErrorCodeEnum errorCode;
    public static final String SERIALIZED_NAME_ERROR_MESSAGE = "errorMessage";
    @SerializedName(value="errorMessage")
    private String errorMessage;
    public static final String SERIALIZED_NAME_CATEGORIES = "categories";
    @SerializedName(value="categories")
    private List<CategoryUpdateError> categories = null;

    @Nullable
    @ApiModelProperty(value="")
    public Integer getCatalogId() {
        return this.catalogId;
    }

    public CategoryUpdatesPerCatalogError errorCode(ErrorCodeEnum errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ErrorCodeEnum getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(ErrorCodeEnum errorCode) {
        this.errorCode = errorCode;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public CategoryUpdatesPerCatalogError categories(List<CategoryUpdateError> categories) {
        this.categories = categories;
        return this;
    }

    public CategoryUpdatesPerCatalogError addCategoriesItem(CategoryUpdateError categoriesItem) {
        if (this.categories == null) {
            this.categories = new ArrayList<CategoryUpdateError>();
        }
        this.categories.add(categoriesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<CategoryUpdateError> getCategories() {
        return this.categories;
    }

    public void setCategories(List<CategoryUpdateError> categories) {
        this.categories = categories;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoryUpdatesPerCatalogError categoryUpdatesPerCatalogError = (CategoryUpdatesPerCatalogError)o;
        return Objects.equals(this.catalogId, categoryUpdatesPerCatalogError.catalogId) && Objects.equals((Object)this.errorCode, (Object)categoryUpdatesPerCatalogError.errorCode) && Objects.equals(this.errorMessage, categoryUpdatesPerCatalogError.errorMessage) && Objects.equals(this.categories, categoryUpdatesPerCatalogError.categories);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.catalogId, this.errorCode, this.errorMessage, this.categories});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CategoryUpdatesPerCatalogError {\n");
        sb.append("    catalogId: ").append(this.toIndentedString(this.catalogId)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString((Object)this.errorCode)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ErrorCodeEnum {
        OK("OK"),
        ACCESSDENIED("AccessDenied"),
        ENABLEDCATEGORYNUMBEREXCEEDED("EnabledCategoryNumberExceeded"),
        CATEGORIESNOTENABLED("CategoriesNotEnabled"),
        DUPLICATECATALOGENTRY("DuplicateCatalogEntry"),
        INVALIDCATALOGID("InvalidCatalogId"),
        INVALIDCATEGORYHASHCODE("InvalidCategoryHashcode"),
        INACTIVECATEGORY("InactiveCategory"),
        DUPLICATECATEGORYENTRY("DuplicateCategoryEntry"),
        BIDDINGCATEGORIESONTHISCAMPAIGNNOTALLOWED("BiddingCategoriesOnThisCampaignNotAllowed"),
        CAMPAIGNNOTINPORTFOLIOORNOTACTIVE("CampaignNotInPortfolioOrNotActive"),
        DUPLICATECAMPAIGNENTRY("DuplicateCampaignEntry"),
        BIDDINGONTHISCAMPAIGNNOTALLOWED("BiddingOnThisCampaignNotAllowed"),
        BIDNOTINRANGE("BidNotInRange"),
        FOURDECIMALSNOTALLOWED("FourDecimalsNotAllowed"),
        BIDDINGONTARGETBUDGETCAMPAIGNNOTALLOWED("BiddingOnTargetBudgetCampaignNotAllowed");

        private String value;

        private ErrorCodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ErrorCodeEnum fromValue(String value) {
            for (ErrorCodeEnum b : ErrorCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ErrorCodeEnum> {
            public void write(JsonWriter jsonWriter, ErrorCodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ErrorCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ErrorCodeEnum.fromValue(value);
            }
        }
    }
}

