/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Criteo API response warning")
public class CriteoApiWarning {
    public static final String SERIALIZED_NAME_TRACE_ID = "traceId";
    @SerializedName(value="traceId")
    private String traceId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_CODE = "code";
    @SerializedName(value="code")
    private CodeEnum code;
    public static final String SERIALIZED_NAME_INSTANCE = "instance";
    @SerializedName(value="instance")
    private String instance;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_DETAIL = "detail";
    @SerializedName(value="detail")
    private String detail;

    public CriteoApiWarning traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The correlation ID provided by the gateway")
    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public CriteoApiWarning type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="access_control", value="A machine-readable code specifying error category")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CriteoApiWarning code(CodeEnum code) {
        this.code = code;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="internal-error", value="A machine-readable error code string in kabab-case. Unique across Criteo")
    public CodeEnum getCode() {
        return this.code;
    }

    public void setCode(CodeEnum code) {
        this.code = code;
    }

    public CriteoApiWarning instance(String instance) {
        this.instance = instance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A URI reference that identifies the specific occurrence of the problem")
    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public CriteoApiWarning title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A short, human-readable summary of the problem type.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public CriteoApiWarning detail(String detail) {
        this.detail = detail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A human-readable explanation specific to this occurrence of the problem.")
    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CriteoApiWarning criteoApiWarning = (CriteoApiWarning)o;
        return Objects.equals(this.traceId, criteoApiWarning.traceId) && Objects.equals((Object)this.type, (Object)criteoApiWarning.type) && Objects.equals((Object)this.code, (Object)criteoApiWarning.code) && Objects.equals(this.instance, criteoApiWarning.instance) && Objects.equals(this.title, criteoApiWarning.title) && Objects.equals(this.detail, criteoApiWarning.detail);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.traceId, this.type, this.code, this.instance, this.title, this.detail});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CriteoApiWarning {\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    code: ").append(this.toIndentedString((Object)this.code)).append("\n");
        sb.append("    instance: ").append(this.toIndentedString(this.instance)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CodeEnum {
        INTERNAL_ERROR("internal-error"),
        DEPRECATED_FIELD("deprecated-field"),
        ENDPOINT_DEPRECATED("endpoint-deprecated"),
        REQUIRED_FIELD("required-field"),
        INVALID_DATE_FORMAT("invalid-date-format"),
        INVALID("invalid"),
        INVALID_RANGED("invalid-ranged"),
        INVALID_TIMESPAN("invalid-timespan");

        private String value;

        private CodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CodeEnum fromValue(String value) {
            for (CodeEnum b : CodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CodeEnum> {
            public void write(JsonWriter jsonWriter, CodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CodeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        ACCESS_CONTROL("access_control"),
        AUTHENTICATION("authentication"),
        AUTHORIZATION("authorization"),
        AVAILABILITY("availability"),
        DEPRECATION("deprecation"),
        QUOTA("quota"),
        VALIDATION("validation");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

