/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public class JwtModel {
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_TOKEN_TYPE = "token_type";
    @SerializedName(value="token_type")
    private String tokenType;
    public static final String SERIALIZED_NAME_EXPIRES_IN = "expires_in";
    @SerializedName(value="expires_in")
    private Integer expiresIn;

    public JwtModel accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The access token issued by the authorization server.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public JwtModel tokenType(String tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the token issued.")
    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public JwtModel expiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The lifetime in seconds of the access token.For  example, the value \"3600\" denotes that the access token will  expire in one hour from the time the response was generated.  If omitted, the authorization server SHOULD provide the  expiration time via other means or document the default value.")
    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JwtModel jwtModel = (JwtModel)o;
        return Objects.equals(this.accessToken, jwtModel.accessToken) && Objects.equals(this.tokenType, jwtModel.tokenType) && Objects.equals(this.expiresIn, jwtModel.expiresIn);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.tokenType, this.expiresIn);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JwtModel {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString(this.tokenType)).append("\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

