/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Data model for common error or warning")
public class ProblemDetails {
    public static final String SERIALIZED_NAME_TRACE_IDENTIFIER = "traceIdentifier";
    @SerializedName(value="traceIdentifier")
    private String traceIdentifier;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_CODE = "code";
    @SerializedName(value="code")
    private String code;
    public static final String SERIALIZED_NAME_INSTANCE = "instance";
    @SerializedName(value="instance")
    private String instance;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_DETAIL = "detail";
    @SerializedName(value="detail")
    private String detail;
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    private Map<String, String> source = null;
    public static final String SERIALIZED_NAME_STACK_TRACE = "stackTrace";
    @SerializedName(value="stackTrace")
    private String stackTrace;

    public ProblemDetails traceIdentifier(String traceIdentifier) {
        this.traceIdentifier = traceIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getTraceIdentifier() {
        return this.traceIdentifier;
    }

    public void setTraceIdentifier(String traceIdentifier) {
        this.traceIdentifier = traceIdentifier;
    }

    public ProblemDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ProblemDetails code(String code) {
        this.code = code;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public ProblemDetails instance(String instance) {
        this.instance = instance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public ProblemDetails title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ProblemDetails detail(String detail) {
        this.detail = detail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public ProblemDetails source(Map<String, String> source) {
        this.source = source;
        return this;
    }

    public ProblemDetails putSourceItem(String key, String sourceItem) {
        if (this.source == null) {
            this.source = new HashMap<String, String>();
        }
        this.source.put(key, sourceItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, String> getSource() {
        return this.source;
    }

    public void setSource(Map<String, String> source) {
        this.source = source;
    }

    public ProblemDetails stackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProblemDetails problemDetails = (ProblemDetails)o;
        return Objects.equals(this.traceIdentifier, problemDetails.traceIdentifier) && Objects.equals((Object)this.type, (Object)problemDetails.type) && Objects.equals(this.code, problemDetails.code) && Objects.equals(this.instance, problemDetails.instance) && Objects.equals(this.title, problemDetails.title) && Objects.equals(this.detail, problemDetails.detail) && Objects.equals(this.source, problemDetails.source) && Objects.equals(this.stackTrace, problemDetails.stackTrace);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.traceIdentifier, this.type, this.code, this.instance, this.title, this.detail, this.source, this.stackTrace});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProblemDetails {\n");
        sb.append("    traceIdentifier: ").append(this.toIndentedString(this.traceIdentifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    instance: ").append(this.toIndentedString(this.instance)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    stackTrace: ").append(this.toIndentedString(this.stackTrace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        UNKNOWN("unknown"),
        ACCESS_CONTROL("access-control"),
        AUTHENTICATION("authentication"),
        AUTHORIZATION("authorization"),
        AVAILABILITY("availability"),
        DEPRECATION("deprecation"),
        QUOTA("quota"),
        VALIDATION("validation");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

