/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.marketing.model;

import com.criteo.marketing.model.NillableDateTime;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ad set schedule read model")
public class ReadAdSetSchedule {
    public static final String SERIALIZED_NAME_START_DATE = "startDate";
    @SerializedName(value="startDate")
    private NillableDateTime startDate;
    public static final String SERIALIZED_NAME_END_DATE = "endDate";
    @SerializedName(value="endDate")
    private NillableDateTime endDate;
    public static final String SERIALIZED_NAME_ACTIVATION_STATUS = "activationStatus";
    @SerializedName(value="activationStatus")
    private ActivationStatusEnum activationStatus;
    public static final String SERIALIZED_NAME_DELIVERY_STATUS = "deliveryStatus";
    @SerializedName(value="deliveryStatus")
    private DeliveryStatusEnum deliveryStatus;

    public ReadAdSetSchedule startDate(NillableDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public NillableDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(NillableDateTime startDate) {
        this.startDate = startDate;
    }

    public ReadAdSetSchedule endDate(NillableDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public NillableDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(NillableDateTime endDate) {
        this.endDate = endDate;
    }

    public ReadAdSetSchedule activationStatus(ActivationStatusEnum activationStatus) {
        this.activationStatus = activationStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Activation status of the ad set, i.e. whether the consumer wants it to deliver")
    public ActivationStatusEnum getActivationStatus() {
        return this.activationStatus;
    }

    public void setActivationStatus(ActivationStatusEnum activationStatus) {
        this.activationStatus = activationStatus;
    }

    public ReadAdSetSchedule deliveryStatus(DeliveryStatusEnum deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Delivery status of the delivery of the ad set, i.e. whether the ad set is delivering")
    public DeliveryStatusEnum getDeliveryStatus() {
        return this.deliveryStatus;
    }

    public void setDeliveryStatus(DeliveryStatusEnum deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadAdSetSchedule readAdSetSchedule = (ReadAdSetSchedule)o;
        return Objects.equals(this.startDate, readAdSetSchedule.startDate) && Objects.equals(this.endDate, readAdSetSchedule.endDate) && Objects.equals((Object)this.activationStatus, (Object)readAdSetSchedule.activationStatus) && Objects.equals((Object)this.deliveryStatus, (Object)readAdSetSchedule.deliveryStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startDate, this.endDate, this.activationStatus, this.deliveryStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReadAdSetSchedule {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    activationStatus: ").append(this.toIndentedString((Object)this.activationStatus)).append("\n");
        sb.append("    deliveryStatus: ").append(this.toIndentedString((Object)this.deliveryStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DeliveryStatusEnum {
        DRAFT("draft"),
        INACTIVE("inactive"),
        LIVE("live"),
        NOTLIVE("notLive"),
        PAUSING("pausing"),
        PAUSED("paused"),
        SCHEDULED("scheduled"),
        ENDED("ended"),
        NOTDELIVERING("notDelivering"),
        ARCHIVED("archived");

        private String value;

        private DeliveryStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DeliveryStatusEnum fromValue(String value) {
            for (DeliveryStatusEnum b : DeliveryStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DeliveryStatusEnum> {
            public void write(JsonWriter jsonWriter, DeliveryStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DeliveryStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DeliveryStatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ActivationStatusEnum {
        ON("on"),
        OFF("off");

        private String value;

        private ActivationStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ActivationStatusEnum fromValue(String value) {
            for (ActivationStatusEnum b : ActivationStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ActivationStatusEnum> {
            public void write(JsonWriter jsonWriter, ActivationStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ActivationStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ActivationStatusEnum.fromValue(value);
            }
        }
    }
}

