/*
 * Decompiled with CFR 0.152.
 */
package com.ctaiot;

import com.alibaba.fastjson.JSONObject;
import com.ctaiot.CloudPrintConfig;
import com.ctaiot.bean.ApiPrintPayLoad;
import com.ctaiot.bean.Brand;
import com.ctaiot.bean.BrandPayLoad;
import com.ctaiot.bean.BrandResult;
import com.ctaiot.bean.DataPrintPayLoad;
import com.ctaiot.bean.DataPrintViewPayLoad;
import com.ctaiot.bean.DataPrintViewResult;
import com.ctaiot.bean.FolderLabel;
import com.ctaiot.bean.FolderPlugCloudResult;
import com.ctaiot.bean.OperateTaskPayLoad;
import com.ctaiot.bean.PdfPrintPayLoad;
import com.ctaiot.bean.PicPrintPayLoad;
import com.ctaiot.bean.PicResourcePrintPayLoad;
import com.ctaiot.bean.PreResourcePayLoad;
import com.ctaiot.bean.PrintPayLoad;
import com.ctaiot.bean.PrintResult;
import com.ctaiot.bean.TaskPageResult;
import com.ctaiot.bean.TaskPayLoad;
import com.ctaiot.connection.HttpProxy;
import com.ctaiot.print.PrintClient;
import com.ctaiot.resp.APIConnectionException;
import com.ctaiot.resp.APIRequestException;
import com.ctaiot.utils.BeanUtil;
import com.ctaiot.utils.EncryptionMD5;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;

public class CloudPrintClient {
    private PrintClient printClient;
    private EncryptionMD5 encryptionMD5;

    private CloudPrintClient() {
    }

    public CloudPrintClient(String appKey, String appSecret) {
        this.printClient = new PrintClient(appKey, appSecret);
        this.encryptionMD5 = new EncryptionMD5();
    }

    public CloudPrintClient(String hostUrl, String appKey, String appSecret) {
        this.printClient = new PrintClient(hostUrl, appKey, appSecret);
        this.encryptionMD5 = new EncryptionMD5();
    }

    public CloudPrintClient(String hostUrl, String appKey, String appSecret, CloudPrintConfig config) {
        this.printClient = new PrintClient(hostUrl, appKey, appSecret, config);
        this.encryptionMD5 = new EncryptionMD5();
    }

    public CloudPrintClient(String hostUrl, String appKey, String appSecret, HttpProxy proxy, CloudPrintConfig config) {
        this.printClient = new PrintClient(hostUrl, appKey, appSecret, proxy, config);
        this.encryptionMD5 = new EncryptionMD5();
    }

    public PrintResult getPrintToken(String userId) throws APIConnectionException, APIRequestException {
        return this.printClient.getSdkToken(userId);
    }

    public List<BrandResult> getPrintBrand(Brand brand, String token) throws APIConnectionException, APIRequestException, IntrospectionException, InvocationTargetException, IllegalAccessException {
        if (Objects.isNull(brand.getEquip())) {
            brand.setEquip(2);
        }
        PrintPayLoad payLoad = this.setPayLoad(token, BeanUtil.beanToMap((Object)brand), brand.getEquip());
        return this.printClient.getBrandList(payLoad).fromDataList(BrandResult.class);
    }

    public PrintResult savePrintBrand(BrandPayLoad payLoad, String token) throws APIConnectionException, APIRequestException, IntrospectionException, InvocationTargetException, IllegalAccessException {
        PrintPayLoad printPayLoad = this.setPayLoad(token, BeanUtil.beanToMap((Object)payLoad), payLoad.getEquip());
        return this.printClient.saveBrand(printPayLoad);
    }

    public FolderPlugCloudResult getFolderLabelList(FolderLabel folderLabel, String token) throws APIConnectionException, APIRequestException, IntrospectionException, InvocationTargetException, IllegalAccessException {
        PrintPayLoad payLoad = this.setPayLoad(token, BeanUtil.beanToMap((Object)folderLabel), folderLabel.getEquip());
        return this.printClient.getFolderLabelList(payLoad).fromData(FolderPlugCloudResult.class);
    }

    @Deprecated
    public PrintResult getPrintClientId(Integer equip, String token) throws APIConnectionException, APIRequestException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("equip", equip);
        PrintPayLoad payLoad = this.setPayLoad(token, params, equip);
        return this.printClient.getClientIdInfo(payLoad);
    }

    @Deprecated
    public PrintResult sendApiPrint(ApiPrintPayLoad apiPrintPayLoad, String token) throws APIConnectionException, APIRequestException, IntrospectionException, InvocationTargetException, IllegalAccessException {
        Map params = BeanUtil.beanToMap((Object)apiPrintPayLoad, (boolean)false, (boolean)true);
        params.put("cloud_doc_md5", this.encryptionMD5.getMD5ofStr(apiPrintPayLoad.getCloudDoc()));
        PrintPayLoad payLoad = this.setPayLoad(token, params, apiPrintPayLoad.getEquip());
        return this.printClient.sendApiPrint(payLoad);
    }

    public PrintResult sendPdfPrint(PdfPrintPayLoad pdfPrintPayLoad, String token) throws APIConnectionException, APIRequestException, IntrospectionException, InvocationTargetException, IllegalAccessException {
        PrintPayLoad payLoad = this.setPayLoad(token, BeanUtil.beanToMap((Object)pdfPrintPayLoad, (boolean)false, (boolean)true), pdfPrintPayLoad.getEquip());
        return this.printClient.sendPdfPrint(payLoad);
    }

    public PrintResult sendPicPrint(PicPrintPayLoad picPrintPayLoad, String token) throws APIConnectionException, APIRequestException, IntrospectionException, InvocationTargetException, IllegalAccessException {
        PrintPayLoad payLoad = this.setPayLoad(token, BeanUtil.beanToMap((Object)picPrintPayLoad, (boolean)false, (boolean)true), picPrintPayLoad.getEquip());
        return this.printClient.sendPicPrint(payLoad);
    }

    public PrintResult getPrintDownUrl(String token) throws APIConnectionException, APIRequestException {
        PrintPayLoad payLoad = this.setPayLoad(token, null, null);
        return this.printClient.printUrl(payLoad);
    }

    public TaskPageResult getPrintTask(TaskPayLoad taskPayLoad, String token) throws IntrospectionException, InvocationTargetException, IllegalAccessException, APIConnectionException, APIRequestException {
        PrintPayLoad payLoad = this.setPayLoad(token, BeanUtil.beanToMap((Object)taskPayLoad, (boolean)false, (boolean)true), taskPayLoad.getEquip());
        return this.printClient.listPrintTask(payLoad).fromData(TaskPageResult.class);
    }

    public PrintResult operatePrintTask(OperateTaskPayLoad taskPayLoad, String token) throws IntrospectionException, InvocationTargetException, IllegalAccessException, APIConnectionException, APIRequestException {
        PrintPayLoad payLoad = this.setPayLoad(token, BeanUtil.beanToMap((Object)taskPayLoad, (boolean)false, (boolean)false), null);
        return this.printClient.operatePrintTask(payLoad);
    }

    public PrintResult preUploadResource(PreResourcePayLoad preResourcePayLoad, String token) throws IntrospectionException, InvocationTargetException, IllegalAccessException, APIConnectionException, APIRequestException {
        PrintPayLoad payLoad = this.setPayLoad(token, BeanUtil.beanToMap((Object)preResourcePayLoad, (boolean)false, (boolean)false), null);
        return this.printClient.preUploadResource(payLoad);
    }

    public PrintResult sendPicResourcePrint(PicResourcePrintPayLoad picPrintPayLoad, String token) throws APIConnectionException, APIRequestException, IntrospectionException, InvocationTargetException, IllegalAccessException {
        PrintPayLoad payLoad = this.setPayLoad(token, BeanUtil.beanToMap((Object)picPrintPayLoad, (boolean)false, (boolean)true), picPrintPayLoad.getEquip());
        return this.printClient.sendPicPrint(payLoad);
    }

    public PrintResult sendDataPrint(DataPrintPayLoad dataPrintPayLoad, String token) throws IntrospectionException, InvocationTargetException, IllegalAccessException, APIConnectionException, APIRequestException {
        PrintPayLoad payLoad = this.setPayLoad(token, BeanUtil.beanToMap((Object)dataPrintPayLoad, (boolean)false, (boolean)true), dataPrintPayLoad.getEquip());
        return this.printClient.sendDataPrint(payLoad);
    }

    public DataPrintViewResult dataPrintView(DataPrintViewPayLoad dataPrintViewPayLoad, String token) throws IntrospectionException, InvocationTargetException, IllegalAccessException, APIConnectionException, APIRequestException {
        PrintPayLoad payLoad = this.setPayLoad(token, BeanUtil.beanToMap((Object)dataPrintViewPayLoad, (boolean)false, (boolean)true), null);
        return this.printClient.dataPrintView(payLoad).fromData(DataPrintViewResult.class);
    }

    private PrintPayLoad setPayLoad(String token, Map<String, Object> params, Integer equip) {
        PrintPayLoad payLoad = new PrintPayLoad();
        if (params != null && !params.isEmpty()) {
            payLoad.setParams(params);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("equip", equip);
        map.put("accessToken", token);
        payLoad.setHeaders(map);
        return payLoad;
    }

    public static void main(String[] args) {
        String secret = "52b76e52965a2d9dfb2210226f915d24";
        Calendar calendar = Calendar.getInstance();
        long time = calendar.getTimeInMillis();
        String result = "secret=" + secret + "&times=" + time + "&username=ctaiot";
        System.out.println(DigestUtils.md5Hex((String)result).toUpperCase());
        System.out.println(time);
        JSONObject object = JSONObject.parseObject((String)"{\"print\":[ {\"cont\":\"\u6807\u9898\",\"type\":\"title\" }, {\"cont\":\"\u95e8\u5e97\u540d\u79f0\uff1a\u81e3\u7530\u5de5\u4e1a\u533a\"}, {\"cont\":\"\u7535\u8bdd\uff1a18620363939\",\"font\":24,\"bold\":true}, { \"thead\":{\"\u540d\u79f0\": \"50%\", \"\u5355\u4ef7\": \"15%\", \"\u6570\u91cf\": \"15%\", \"\u91d1\u989d\": \"20%\"}, \"tbody\": [ [\"\u756a\u8304\u7092\u86cb\", 24, 2, 48], [\"\u897f\u7ea2\u67ff\u7092\u756a\u8304\", 24, 7, 168], [\"\u9e21\u86cb\u7092\u9e2d\u86cb\", 24, 1, 24], [\"\u91ce\u5c71\u6912\u7092\u571f\u8c46\", 24, 3, 72] ] }, {\"cont\":\"http://www.sw-aiot.com\",\"type\":\"qrcode\",\"align\":\"right\"}, {\"cont\":\"123456789\",\"type\":\"bc128\",\"align\":\"left\"}, {\"cont\":\"1\",\"type\":\"cut\"}]}");
        System.out.println(object.toJSONString());
    }
}

