/*
 * Decompiled with CFR 0.152.
 */
package com.ctaiot;

import com.ctaiot.CloudPrintConfig;
import com.ctaiot.bean.ApiPrintPayLoad;
import com.ctaiot.bean.Brand;
import com.ctaiot.bean.BrandPayLoad;
import com.ctaiot.bean.BrandResult;
import com.ctaiot.bean.FolderLabel;
import com.ctaiot.bean.FolderPlugCloudResult;
import com.ctaiot.bean.OperateTaskPayLoad;
import com.ctaiot.bean.PdfPrintPayLoad;
import com.ctaiot.bean.PicPrintPayLoad;
import com.ctaiot.bean.PrintPayLoad;
import com.ctaiot.bean.PrintResult;
import com.ctaiot.bean.TaskPageResult;
import com.ctaiot.bean.TaskPayLoad;
import com.ctaiot.connection.HttpProxy;
import com.ctaiot.print.PrintClient;
import com.ctaiot.resp.APIConnectionException;
import com.ctaiot.resp.APIRequestException;
import com.ctaiot.utils.BeanUtil;
import com.ctaiot.utils.EncryptionMD5;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CloudPrintClient {
    private PrintClient printClient;
    private EncryptionMD5 encryptionMD5;

    private CloudPrintClient() {
    }

    public CloudPrintClient(String appKey, String appSecret) {
        this.printClient = new PrintClient(appKey, appSecret);
        this.encryptionMD5 = new EncryptionMD5();
    }

    public CloudPrintClient(String appKey, String appSecret, CloudPrintConfig config) {
        this.printClient = new PrintClient(appKey, appSecret, config);
        this.encryptionMD5 = new EncryptionMD5();
    }

    public CloudPrintClient(String appKey, String appSecret, HttpProxy proxy, CloudPrintConfig config) {
        this.printClient = new PrintClient(appKey, appSecret, proxy, config);
        this.encryptionMD5 = new EncryptionMD5();
    }

    public PrintResult getPrintToken(String userId) throws APIConnectionException, APIRequestException {
        String str = String.valueOf(System.nanoTime());
        int len = str.length();
        return this.printClient.getSdkToken(userId + "_" + str.substring(len - 5, len));
    }

    public List<BrandResult> getPrintBrand(Brand brand, String token) throws APIConnectionException, APIRequestException, IntrospectionException, InvocationTargetException, IllegalAccessException {
        brand.setEquip(null);
        PrintPayLoad payLoad = this.setPayLoad(token, BeanUtil.beanToMap((Object)brand), brand.getEquip());
        return this.printClient.getBrandList(payLoad).fromDataList(BrandResult.class);
    }

    public PrintResult savePrintBrand(BrandPayLoad payLoad, String token) throws APIConnectionException, APIRequestException, IntrospectionException, InvocationTargetException, IllegalAccessException {
        PrintPayLoad printPayLoad = this.setPayLoad(token, BeanUtil.beanToMap((Object)payLoad), payLoad.getEquip());
        return this.printClient.saveBrand(printPayLoad);
    }

    public FolderPlugCloudResult getFolderLabelList(FolderLabel folderLabel, String token) throws APIConnectionException, APIRequestException, IntrospectionException, InvocationTargetException, IllegalAccessException {
        PrintPayLoad payLoad = this.setPayLoad(token, BeanUtil.beanToMap((Object)folderLabel), folderLabel.getEquip());
        return this.printClient.getFolderLabelList(payLoad).fromData(FolderPlugCloudResult.class);
    }

    public PrintResult getPrintClientId(Integer equip, String token) throws APIConnectionException, APIRequestException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("equip", equip);
        PrintPayLoad payLoad = this.setPayLoad(token, params, equip);
        return this.printClient.getClientIdInfo(payLoad);
    }

    public PrintResult sendApiPrint(ApiPrintPayLoad apiPrintPayLoad, String token) throws APIConnectionException, APIRequestException, IntrospectionException, InvocationTargetException, IllegalAccessException {
        if (apiPrintPayLoad.getClientId() == null || apiPrintPayLoad.getClientId().isEmpty()) {
            throw new IllegalArgumentException("clientId should not be null");
        }
        Map params = BeanUtil.beanToMap((Object)apiPrintPayLoad, (boolean)false, (boolean)true);
        params.put("cloud_doc_md5", this.encryptionMD5.getMD5ofStr(apiPrintPayLoad.getCloudDoc()));
        PrintPayLoad payLoad = this.setPayLoad(token, params, apiPrintPayLoad.getEquip());
        return this.printClient.sendApiPrint(payLoad);
    }

    public PrintResult sendPdfPrint(PdfPrintPayLoad pdfPrintPayLoad, String token) throws APIConnectionException, APIRequestException, IntrospectionException, InvocationTargetException, IllegalAccessException {
        if (pdfPrintPayLoad.getClientId() == null || pdfPrintPayLoad.getClientId().isEmpty()) {
            throw new IllegalArgumentException("clientId should not be null");
        }
        PrintPayLoad payLoad = this.setPayLoad(token, BeanUtil.beanToMap((Object)pdfPrintPayLoad, (boolean)false, (boolean)true), pdfPrintPayLoad.getEquip());
        return this.printClient.sendPdfPrint(payLoad);
    }

    public PrintResult sendPicPrint(PicPrintPayLoad picPrintPayLoad, String token) throws APIConnectionException, APIRequestException, IntrospectionException, InvocationTargetException, IllegalAccessException {
        if (picPrintPayLoad.getClientId() == null || picPrintPayLoad.getClientId().isEmpty()) {
            throw new IllegalArgumentException("clientId should not be null");
        }
        PrintPayLoad payLoad = this.setPayLoad(token, BeanUtil.beanToMap((Object)picPrintPayLoad, (boolean)false, (boolean)true), picPrintPayLoad.getEquip());
        return this.printClient.sendPicPrint(payLoad);
    }

    public PrintResult getPrintDownUrl(String token) throws APIConnectionException, APIRequestException {
        PrintPayLoad payLoad = this.setPayLoad(token, null, null);
        return this.printClient.printUrl(payLoad);
    }

    public TaskPageResult getPrintTask(TaskPayLoad taskPayLoad, String token) throws IntrospectionException, InvocationTargetException, IllegalAccessException, APIConnectionException, APIRequestException {
        PrintPayLoad payLoad = this.setPayLoad(token, BeanUtil.beanToMap((Object)taskPayLoad, (boolean)false, (boolean)true), taskPayLoad.getEquip());
        return this.printClient.listPrintTask(payLoad).fromData(TaskPageResult.class);
    }

    public PrintResult operatePrintTask(OperateTaskPayLoad taskPayLoad, String token) throws IntrospectionException, InvocationTargetException, IllegalAccessException, APIConnectionException, APIRequestException {
        PrintPayLoad payLoad = this.setPayLoad(token, BeanUtil.beanToMap((Object)taskPayLoad, (boolean)false, (boolean)false), null);
        return this.printClient.operatePrintTask(payLoad);
    }

    private PrintPayLoad setPayLoad(String token, Map<String, Object> params, Integer equip) {
        PrintPayLoad payLoad = new PrintPayLoad();
        if (params != null && !params.isEmpty()) {
            payLoad.setParams(params);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("equip", equip);
        map.put("accessToken", token);
        payLoad.setHeaders(map);
        return payLoad;
    }
}

