/*
 * Decompiled with CFR 0.152.
 */
package com.ctaiot.print;

import com.ctaiot.CloudPrintConfig;
import com.ctaiot.bean.PrintPayLoad;
import com.ctaiot.bean.PrintResult;
import com.ctaiot.connection.HttpProxy;
import com.ctaiot.connection.IHttpClient;
import com.ctaiot.connection.NativeHttpClient;
import com.ctaiot.resp.APIConnectionException;
import com.ctaiot.resp.APIRequestException;
import com.ctaiot.resp.BaseResult;
import com.ctaiot.resp.ResponseWrapper;
import com.ctaiot.utils.FileUtil;
import com.ctaiot.utils.Md5Util;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Objects;
import java.util.TreeMap;

public class PrintClient {
    private IHttpClient httpClient;
    private String appKey;
    private String appSecret;
    private String hostUrl;
    private String sdkTokenUrl;
    private String brandListUrl;
    private String brandSaveUrl;
    private String folderLabelListUrl;
    private String clientIdInfoUrl;
    private String sendApiPrintUrl;
    private String sendPdfPrintUrl;
    private String sendPicPrintUrl;
    private String printUrl;
    private String listPrintTask;
    private String operatePrintTask;
    private JsonParser _jsonParser = new JsonParser();

    private PrintClient() {
    }

    public PrintClient(String appKey, String appSecret) {
        this(appKey, appSecret, null, CloudPrintConfig.getInstance());
    }

    public PrintClient(String appKey, String appSecret, CloudPrintConfig clientConfig) {
        this(appKey, appSecret, null, clientConfig);
    }

    public PrintClient(String appKey, String appSecret, HttpProxy proxy, CloudPrintConfig clientConfig) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.hostUrl = (String)clientConfig.get((Object)"host.name") + (String)clientConfig.get((Object)"host.name.path");
        this.sdkTokenUrl = (String)clientConfig.get((Object)"sdk.token");
        this.brandListUrl = (String)clientConfig.get((Object)"brand.list");
        this.brandSaveUrl = (String)clientConfig.get((Object)"brand.save");
        this.folderLabelListUrl = (String)clientConfig.get((Object)"folder.label.list");
        this.clientIdInfoUrl = (String)clientConfig.get((Object)"client.id.info");
        this.sendApiPrintUrl = (String)clientConfig.get((Object)"send.api.print");
        this.sendPdfPrintUrl = (String)clientConfig.get((Object)"send.pdf.print");
        this.sendPicPrintUrl = (String)clientConfig.get((Object)"send.pic.print");
        this.printUrl = (String)clientConfig.get((Object)"print.url");
        this.listPrintTask = (String)clientConfig.get((Object)"list.print.task");
        this.operatePrintTask = (String)clientConfig.get((Object)"operate.print.task");
        this.httpClient = new NativeHttpClient(null, clientConfig);
        if (Objects.nonNull(proxy)) {
            // empty if block
        }
    }

    public PrintResult getSdkToken(String userId) throws APIConnectionException, APIRequestException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appKey", this.appKey);
        if (Objects.equals(this.appKey, "demo-app-key")) {
            String str = String.valueOf(System.nanoTime());
            int len = str.length();
            FileUtil fileUtil = new FileUtil();
            try {
                userId = fileUtil.getUserId(userId + "_" + str.substring(len - 5, len));
            }
            catch (IOException e) {
                userId = userId + "_" + str.substring(len - 5, len);
            }
        }
        map.put("userId", userId);
        map.put("timestamp", Calendar.getInstance().getTimeInMillis());
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("sequenceCode", "");
        treeMap.put("companyId", "");
        treeMap.put("appKey", (String)map.get("appKey"));
        treeMap.put("userId", userId);
        treeMap.put("timestamp", (String)map.get("timestamp"));
        String sign = Md5Util.sign((String)Md5Util.formatSignContent(treeMap), (String)this.appSecret);
        map.put("sign", sign);
        PrintPayLoad payLoad = new PrintPayLoad();
        payLoad.setParams(map);
        ResponseWrapper response = this.httpClient.sendPost(this.hostUrl + this.sdkTokenUrl, payLoad.toParams(), payLoad.getHeaders());
        return (PrintResult)BaseResult.fromResponse((ResponseWrapper)response, PrintResult.class);
    }

    public PrintResult getBrandList(PrintPayLoad payLoad) throws APIConnectionException, APIRequestException {
        this.checkPrintPayLoad(payLoad);
        ResponseWrapper response = this.httpClient.sendGet(this.hostUrl + this.brandListUrl + "?" + payLoad.toParams(), payLoad.getHeaders());
        return (PrintResult)BaseResult.fromResponse((ResponseWrapper)response, PrintResult.class);
    }

    public PrintResult saveBrand(PrintPayLoad payLoad) throws APIConnectionException, APIRequestException {
        this.checkPrintPayLoad(payLoad);
        ResponseWrapper response = this.httpClient.sendPost(this.hostUrl + this.brandSaveUrl, payLoad.toParams(), payLoad.getHeaders());
        return (PrintResult)BaseResult.fromResponse((ResponseWrapper)response, PrintResult.class);
    }

    public PrintResult getFolderLabelList(PrintPayLoad payLoad) throws APIConnectionException, APIRequestException {
        this.checkPrintPayLoad(payLoad);
        ResponseWrapper response = this.httpClient.sendPost(this.hostUrl + this.folderLabelListUrl, payLoad.toParams(), payLoad.getHeaders());
        return (PrintResult)BaseResult.fromResponse((ResponseWrapper)response, PrintResult.class);
    }

    public PrintResult getClientIdInfo(PrintPayLoad payLoad) throws APIConnectionException, APIRequestException {
        this.checkPrintPayLoad(payLoad);
        ResponseWrapper response = this.httpClient.sendPost(this.hostUrl + this.clientIdInfoUrl, payLoad.toParams(), payLoad.getHeaders());
        return (PrintResult)BaseResult.fromResponse((ResponseWrapper)response, PrintResult.class);
    }

    public PrintResult sendApiPrint(PrintPayLoad payLoad) throws APIConnectionException, APIRequestException {
        this.checkPrintPayLoad(payLoad);
        ResponseWrapper response = this.httpClient.sendPost(this.hostUrl + this.sendApiPrintUrl, payLoad.toParams(), payLoad.getHeaders());
        return (PrintResult)BaseResult.fromResponse((ResponseWrapper)response, PrintResult.class);
    }

    public PrintResult sendPdfPrint(PrintPayLoad payLoad) throws APIConnectionException, APIRequestException {
        this.checkPrintPayLoad(payLoad);
        ResponseWrapper response = this.httpClient.sendPost(this.hostUrl + this.sendPdfPrintUrl, payLoad.toParams(), payLoad.getHeaders());
        return (PrintResult)BaseResult.fromResponse((ResponseWrapper)response, PrintResult.class);
    }

    public PrintResult sendPicPrint(PrintPayLoad payLoad) throws APIConnectionException, APIRequestException {
        this.checkPrintPayLoad(payLoad);
        ResponseWrapper response = this.httpClient.sendPost(this.hostUrl + this.sendPicPrintUrl, payLoad.toParams(), payLoad.getHeaders());
        return (PrintResult)BaseResult.fromResponse((ResponseWrapper)response, PrintResult.class);
    }

    public PrintResult printUrl(PrintPayLoad payLoad) throws APIConnectionException, APIRequestException {
        ResponseWrapper response = this.httpClient.sendPost(this.hostUrl + this.printUrl, payLoad.toParams(), payLoad.getHeaders());
        return (PrintResult)BaseResult.fromResponse((ResponseWrapper)response, PrintResult.class);
    }

    public PrintResult listPrintTask(PrintPayLoad payLoad) throws APIConnectionException, APIRequestException {
        ResponseWrapper response = this.httpClient.sendPost(this.hostUrl + this.listPrintTask, payLoad.toParams(), payLoad.getHeaders());
        return (PrintResult)BaseResult.fromResponse((ResponseWrapper)response, PrintResult.class);
    }

    public PrintResult operatePrintTask(PrintPayLoad payLoad) throws APIConnectionException, APIRequestException {
        ResponseWrapper response = this.httpClient.sendPost(this.hostUrl + this.operatePrintTask, payLoad.toParams(), payLoad.getHeaders());
        return (PrintResult)BaseResult.fromResponse((ResponseWrapper)response, PrintResult.class);
    }

    private void checkPrintPayLoad(PrintPayLoad payLoad) {
        if (payLoad == null) {
            throw new IllegalArgumentException("printPayLoad should not be null");
        }
        if (payLoad.getHeaders() == null) {
            throw new IllegalArgumentException("headers should not be null");
        }
    }
}

