package com.ctaiot.bean;

import java.util.Date;


public class TaskResult {
    /**
     * 打印端唯一id标识(透传：用于后台定位打印任务表)
     */
    private Long cid;
    /**
     * 主任务流水号
     */
    private String taskNo;

    /**
     * 主任务单标、多标标识
     * 3:单标单份、4:单标多份、5:多标单份、6:多标多份
     */
    private Integer printType;

    /**
     * 主任务打印内容类型
     * 1:excel 2:pdf 3:图片 4.数据流对接打印 5:普通标签打印
     */
    private Integer contentType;

    /**
     * 主任务打印通知,仅针对分页渲染后的打印通知，不影响主任务的挂起：
     * 1:打印待发送(主任务创建的默认状态)
     * 3:主任务发送中(非最后一页，分页渲染后的打印通知)
     * 4:主任务发送完成 (最后一页，分页渲染后的打印通知)
     */
    private Integer taskStatus;
    /**
     * 主任务创建时间
     */
    private Date createTime;
    /**
     * 主任务打印状态：
     * 1:待打印(主任务创建的默认状态)、
     * 2:已暂停(入口在任务列表，用户操作，mqtt下行通知)
     * 3:打印中(非最后一页，分页渲染后的打印通知)
     * 4:已完成(依赖get_out_page_content.json接口的pageLast)
     * 5:已取消(入口在任务列表，用户操作，mqtt下行通知)
     */
    private Integer printStatus;
    /**
     * 主任务来源的打印端:1、PC 2、AD 3、IOS 4、Mac 5、微信小程序 6、支付宝小程序
     */
    private Integer equip;

    public Long getCid() {
        return cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public String getTaskNo() {
        return taskNo;
    }

    public void setTaskNo(String taskNo) {
        this.taskNo = taskNo;
    }

    public Integer getPrintType() {
        return printType;
    }

    public void setPrintType(Integer printType) {
        this.printType = printType;
    }

    public Integer getContentType() {
        return contentType;
    }

    public void setContentType(Integer contentType) {
        this.contentType = contentType;
    }

    public Integer getTaskStatus() {
        return taskStatus;
    }

    public void setTaskStatus(Integer taskStatus) {
        this.taskStatus = taskStatus;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getPrintStatus() {
        return printStatus;
    }

    public void setPrintStatus(Integer printStatus) {
        this.printStatus = printStatus;
    }

    public Integer getEquip() {
        return equip;
    }

    public void setEquip(Integer equip) {
        this.equip = equip;
    }
}
