/*
 * Decompiled with CFR 0.152.
 */
package com.ctaiot.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BeanUtil {
    public static Map<String, Object> beanToMap(Object bean) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        return BeanUtil.beanToMap(bean, false, false);
    }

    public static Map<String, Object> beanToMap(Object bean, boolean isIgnoreNull, boolean isIgnoreUnderLine) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        return BeanUtil.beanToMap(bean, new HashMap<String, Object>(), isIgnoreNull, isIgnoreUnderLine);
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> target, boolean isIgnoreNull, boolean isIgnoreUnderLine) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        PropertyDescriptor[] descriptors;
        if (bean == null) {
            return null;
        }
        BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
        for (PropertyDescriptor descriptor : descriptors = beanInfo.getPropertyDescriptors()) {
            Object value;
            String key = descriptor.getName();
            if (key.compareToIgnoreCase("class") == 0) continue;
            Method getter = descriptor.getReadMethod();
            Object object = value = getter != null ? getter.invoke(bean, new Object[0]) : null;
            if (isIgnoreNull && (null == value || value.equals(bean)) || key == null || key.equals("token")) continue;
            if (isIgnoreUnderLine) {
                key = BeanUtil.convert(key);
            }
            target.put(key, value);
        }
        return target;
    }

    public static String convert(String str) {
        Pattern compile = Pattern.compile("[A-Z]");
        Matcher matcher = compile.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

