/*
 * Decompiled with CFR 0.152.
 */
package com.ctaiot.resp;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseWrapper
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseWrapper.class);
    private static final int RESPONSE_CODE_NONE = -1;
    private static final long serialVersionUID = 4103955684294622719L;
    private static Gson gson = new Gson();
    private static JsonParser jsonParser = new JsonParser();
    public int responseCode = -1;
    public String responseContent;
    public ErrorEntity error;
    public int rateLimitQuota;
    public int rateLimitRemaining;
    public int rateLimitReset;

    public void setRateLimit(String quota, String remaining, String reset) {
        if (null == quota) {
            return;
        }
        try {
            this.rateLimitQuota = Integer.parseInt(quota);
            this.rateLimitRemaining = Integer.parseInt(remaining);
            this.rateLimitReset = Integer.parseInt(reset);
            LOG.debug("Cloud Print API Rate Limiting params - quota:" + quota + ", remaining:" + remaining + ", reset:" + reset);
        }
        catch (NumberFormatException e) {
            LOG.debug("Unexpected - parse rate limiting headers error.");
        }
    }

    public void setErrorEntity() {
        this.error = new ErrorEntity();
        try {
            JsonElement element = jsonParser.parse(this.responseContent);
            JsonObject errorObj = null;
            if (element instanceof JsonArray) {
                JsonArray array = (JsonArray)element;
                for (int i = 0; i < array.size(); ++i) {
                    if (!array.get(i).getAsJsonObject().has("error")) continue;
                    errorObj = array.get(i).getAsJsonObject();
                    break;
                }
            } else if (element instanceof JsonObject) {
                errorObj = (JsonObject)element;
            }
            if (null != errorObj) {
                JsonObject errorMsg = errorObj;
                if (errorMsg.has("code")) {
                    this.error.code = errorMsg.get("code").getAsInt();
                }
                if (errorMsg.has("message")) {
                    this.error.message = errorMsg.get("message").getAsString();
                }
            }
        }
        catch (JsonSyntaxException e) {
            LOG.error("Unexpected - responseContent:" + this.responseContent, (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Unexpected - responseContent:" + this.responseContent, (Throwable)e);
        }
    }

    public boolean isServerResponse() {
        if (this.responseCode / 100 == 2) {
            return true;
        }
        return this.responseCode > 0 && null != this.error && this.error.code > 0;
    }

    public String toString() {
        return gson.toJson((Object)this);
    }

    public static class ErrorEntity {
        public int code;
        public String message;

        public String toString() {
            return gson.toJson((Object)this);
        }
    }
}

