/*
 * Decompiled with CFR 0.152.
 */
package com.ctaiot.connection;

import com.ctaiot.CloudPrintConfig;
import com.ctaiot.connection.HttpProxy;
import com.ctaiot.connection.IHttpClient;
import com.ctaiot.resp.APIConnectionException;
import com.ctaiot.resp.APIRequestException;
import com.ctaiot.resp.ResponseWrapper;
import com.ctaiot.utils.HttpRequest;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Objects;
import javax.activation.MimetypesFileTypeMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeHttpClient
implements IHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(NativeHttpClient.class);
    private static final String KEYWORDS_CONNECT_TIMED_OUT = "connect timed out";
    private static final String KEYWORDS_READ_TIMED_OUT = "Read timed out";
    private final int connectionTimeout;
    private final int readTimeout;
    private final int maxRetryTimes;
    private HttpProxy proxy;

    public NativeHttpClient(HttpProxy proxy, CloudPrintConfig config) {
        this.maxRetryTimes = config.getMaxRetryTimes();
        this.connectionTimeout = config.getConnectionTimeout();
        this.readTimeout = config.getReadTimeout();
        String message = MessageFormat.format("Created instance with connectionTimeout {0}, readTimeout {1}, maxRetryTimes {2}", this.connectionTimeout, this.readTimeout, this.maxRetryTimes);
        LOG.debug(message);
        if (null != proxy) {
            Authenticator.setDefault(new SimpleProxyAuthenticator(proxy.getUsername(), proxy.getPassword()));
        }
    }

    @Override
    public ResponseWrapper sendGet(String url, Map<String, Object> header) throws APIConnectionException, APIRequestException {
        return this.sendGet(url, null, header);
    }

    @Override
    public ResponseWrapper sendGet(String url, String content, Map<String, Object> header) throws APIConnectionException, APIRequestException {
        return this.doRequest(url, content, null, header, IHttpClient.RequestMethod.GET);
    }

    @Override
    public ResponseWrapper sendDelete(String url, Map<String, Object> header) throws APIConnectionException, APIRequestException {
        return this.sendDelete(url, null, header);
    }

    @Override
    public ResponseWrapper sendDelete(String url, String content, Map<String, Object> header) throws APIConnectionException, APIRequestException {
        return this.doRequest(url, content, null, header, IHttpClient.RequestMethod.DELETE);
    }

    @Override
    public ResponseWrapper sendPost(String url, String content, Map<String, Object> header) throws APIConnectionException, APIRequestException {
        return this.doRequest(url, content, null, header, IHttpClient.RequestMethod.POST);
    }

    @Override
    public ResponseWrapper sendPost(String url, Map<String, Object> content, Map<String, Object> header) throws APIConnectionException, APIRequestException {
        return this.doRequest(url, null, content, header, IHttpClient.RequestMethod.POST);
    }

    @Override
    public ResponseWrapper sendPut(String url, String content, Map<String, Object> header) throws APIConnectionException, APIRequestException {
        return this.doRequest(url, content, null, header, IHttpClient.RequestMethod.PUT);
    }

    public ResponseWrapper doRequest(String url, String content, Map<String, Object> postContent, Map<String, Object> header, IHttpClient.RequestMethod method) throws APIConnectionException, APIRequestException {
        ResponseWrapper response = null;
        int retryTimes = 0;
        while (true) {
            try {
                response = this._doRequests(url, content, postContent, header, method);
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                if (KEYWORDS_READ_TIMED_OUT.equals(e.getMessage())) {
                    throw new APIConnectionException("Read timed out. \nRead response from Cloud Print Server timed out. \nIf this is a Push action, you may not want to retry. \nIt may be due to slowly response from Cloud Print server, or unstable connection. \n", (Throwable)e, true);
                }
                if (retryTimes >= this.maxRetryTimes) {
                    throw new APIConnectionException("connect timed out. \nConnect to Cloud Print Server timed out, and already retried some times. \nPlease ensure your internet connection is ok. \n", (Throwable)e, retryTimes);
                }
                LOG.debug("connect timed out - retry again - " + (retryTimes + 1));
                ++retryTimes;
                continue;
            }
            break;
        }
        return response;
    }

    private ResponseWrapper _doRequests(String url, String content, Map<String, Object> postContent, Map<String, Object> header, IHttpClient.RequestMethod method) throws IOException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        String result;
        HttpRequest request = new HttpRequest();
        ResponseWrapper wrapper = new ResponseWrapper();
        if (Objects.equals(method.name(), IHttpClient.RequestMethod.POST.name())) {
            result = request.sendPost(url, postContent, header);
        } else if (Objects.equals(method.name(), IHttpClient.RequestMethod.GET.name())) {
            result = request.sendGet(url, header, null);
        } else {
            return null;
        }
        wrapper.responseCode = 200;
        wrapper.responseContent = result;
        String quota = "100";
        String remaining = "200";
        String reset = "300";
        wrapper.setRateLimit(quota, remaining, reset);
        return wrapper;
    }

    private ResponseWrapper _doRequest(String url, String content, Map<String, Object> postContent, Map<String, Object> header, IHttpClient.RequestMethod method) throws APIConnectionException, APIRequestException, SocketTimeoutException {
        ResponseWrapper wrapper;
        block47: {
            LOG.debug("Send request - " + method.toString() + " " + url);
            if (null != content) {
                LOG.debug("Request Content - " + content);
            }
            HttpURLConnection conn = null;
            OutputStream out = null;
            InputStream in = null;
            InputStreamReader reader = null;
            StringBuffer sb = new StringBuffer();
            wrapper = new ResponseWrapper();
            try {
                URL aUrl = new URL(url);
                conn = this.getConnectionByUrl(aUrl);
                conn.setConnectTimeout(this.connectionTimeout);
                conn.setReadTimeout(this.readTimeout);
                conn.setUseCaches(false);
                conn.setRequestMethod(method.name());
                conn.setRequestProperty("User-Agent", "Cloud-Print-API-Java-Client");
                conn.setRequestProperty("Connection", "Keep-Alive");
                conn.setRequestProperty("Accept-Charset", "UTF-8");
                conn.setRequestProperty("Charset", "UTF-8");
                if (Objects.nonNull(header)) {
                    for (String string : header.keySet()) {
                        conn.setRequestProperty(string, Objects.nonNull(header.get(string)) ? header.get(string).toString() : null);
                    }
                }
                if (Objects.equals(method.name(), IHttpClient.RequestMethod.POST.name())) {
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                } else {
                    conn.setRequestProperty("Content-Type", "application/json");
                }
                if (null == content) {
                    if (Objects.nonNull(postContent) && !postContent.isEmpty()) {
                        conn.setDoOutput(true);
                        StringBuilder builder = new StringBuilder();
                        for (String key : postContent.keySet()) {
                            String value = String.valueOf(postContent.get(key));
                            builder.append(key).append("=").append(URLEncoder.encode(value, "UTF-8")).append("&");
                        }
                        String string = builder.substring(0, builder.lastIndexOf("&"));
                        byte[] data = string.getBytes(StandardCharsets.UTF_8);
                        conn.setRequestProperty("Content-Length", String.valueOf(data.length));
                        out = conn.getOutputStream();
                        out.write(data);
                        out.flush();
                    } else {
                        conn.setDoOutput(false);
                    }
                } else {
                    conn.setDoOutput(true);
                    byte[] data = content.getBytes("UTF-8");
                    conn.setRequestProperty("Content-Length", String.valueOf(data.length));
                    out = conn.getOutputStream();
                    out.write(data);
                    out.flush();
                }
                int status = conn.getResponseCode();
                in = status / 100 == 2 ? conn.getInputStream() : conn.getErrorStream();
                if (null != in) {
                    int len;
                    reader = new InputStreamReader(in, "UTF-8");
                    char[] cArray = new char[1024];
                    while ((len = reader.read(cArray)) > 0) {
                        sb.append(cArray, 0, len);
                    }
                }
                String string = sb.toString();
                wrapper.responseCode = status;
                wrapper.responseContent = string;
                String quota = conn.getHeaderField("X-Rate-Limit-Limit");
                String remaining = conn.getHeaderField("X-Rate-Limit-Remaining");
                String reset = conn.getHeaderField("X-Rate-Limit-Reset");
                wrapper.setRateLimit(quota, remaining, reset);
                if (status >= 100 && status < 300) {
                    LOG.debug("Succeed to get response OK - responseCode:" + status);
                    LOG.debug("Response Content - " + string);
                    break block47;
                }
                if (status >= 300 && status < 400) {
                    LOG.warn("Normal response but unexpected - responseCode:" + status + ", responseContent:" + string);
                    break block47;
                }
                LOG.warn("Got error response - responseCode:" + status + ", responseContent:" + string);
                switch (status) {
                    case 400: {
                        LOG.error("Your request params is invalid. Please check them according to error message.");
                        wrapper.setErrorEntity();
                        break;
                    }
                    case 401: {
                        LOG.error("Authentication failed! Please check authentication params according to docs.");
                        wrapper.setErrorEntity();
                        break;
                    }
                    case 403: {
                        LOG.error("Request is forbidden! Maybe your appkey is listed in blacklist or your params is invalid.");
                        wrapper.setErrorEntity();
                        break;
                    }
                    case 404: {
                        LOG.error("Request page is not found! Maybe your params is invalid.");
                        wrapper.setErrorEntity();
                        break;
                    }
                    case 410: {
                        LOG.error("Request resource is no longer in service. Please according to notice on official website.");
                        wrapper.setErrorEntity();
                    }
                    case 429: {
                        LOG.error("Too many requests! Please review your appkey's request quota.");
                        wrapper.setErrorEntity();
                        break;
                    }
                    case 500: 
                    case 502: 
                    case 503: 
                    case 504: {
                        LOG.error("Seems encountered server error. Maybe Cloud Print is in maintenance? Please retry later.");
                        break;
                    }
                    default: {
                        LOG.error("Unexpected response.");
                    }
                }
                throw new APIRequestException(wrapper);
            }
            catch (SocketTimeoutException e) {
                if (e.getMessage().contains(KEYWORDS_CONNECT_TIMED_OUT)) {
                    throw e;
                }
                if (e.getMessage().contains(KEYWORDS_READ_TIMED_OUT)) {
                    throw new SocketTimeoutException(KEYWORDS_READ_TIMED_OUT);
                }
                LOG.debug("Connection IO error. \nCan not connect to Cloud Print Server. Please ensure your internet connection is ok. \n", (Throwable)e);
                throw new APIConnectionException("Connection IO error. \nCan not connect to Cloud Print Server. Please ensure your internet connection is ok. \n", e);
            }
            catch (IOException e) {
                LOG.debug("Connection IO error. \nCan not connect to Cloud Print Server. Please ensure your internet connection is ok. \n", (Throwable)e);
                throw new APIConnectionException("Connection IO error. \nCan not connect to Cloud Print Server. Please ensure your internet connection is ok. \n", e);
            }
            finally {
                if (null != out) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        LOG.error("Failed to close stream.", (Throwable)e);
                    }
                }
                if (null != conn) {
                    conn.disconnect();
                }
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (null != reader) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return wrapper;
    }

    public String formUploadByPut(String urlStr, Map<String, String> textMap, Map<String, String> fileMap, String contentType) {
        return this.formUpload(urlStr, textMap, fileMap, contentType, "PUT");
    }

    public String formUploadByPost(String urlStr, Map<String, String> textMap, Map<String, String> fileMap, String contentType) {
        return this.formUpload(urlStr, textMap, fileMap, contentType, "POST");
    }

    private String encode(String value) {
        String encoded = "";
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        StringBuffer buf = new StringBuffer(encoded.length());
        for (int i = 0; i < encoded.length(); ++i) {
            char focus = encoded.charAt(i);
            if (focus == '*') {
                buf.append("%2A");
                continue;
            }
            if (focus == '+') {
                buf.append("%20");
                continue;
            }
            if (focus == '%' && i + 1 < encoded.length() && encoded.charAt(i + 1) == '7' && encoded.charAt(i + 2) == 'E') {
                buf.append('~');
                i += 2;
                continue;
            }
            buf.append(focus);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formUpload(String urlStr, Map<String, String> textMap, Map<String, String> fileMap, String contentType, String requestMethod) {
        String res = "";
        HttpURLConnection conn = null;
        String BOUNDARY = "---------------------------" + System.currentTimeMillis();
        try {
            URL url = new URL(urlStr);
            conn = this.getConnectionByUrl(url);
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(30000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod(requestMethod);
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            if (textMap != null) {
                StringBuffer strBuf = new StringBuffer();
                for (Map.Entry<String, String> entry : textMap.entrySet()) {
                    String inputName = entry.getKey();
                    String inputValue = entry.getValue();
                    if (inputValue == null) continue;
                    strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                    strBuf.append("Content-Disposition: form-data; name=\"" + inputName + "\"\r\n\r\n");
                    strBuf.append(inputValue);
                }
                ((OutputStream)out).write(strBuf.toString().getBytes());
            }
            if (fileMap != null) {
                for (Map.Entry<String, String> entry : fileMap.entrySet()) {
                    String inputName = entry.getKey();
                    String inputValue = entry.getValue();
                    if (inputValue == null) continue;
                    File file = new File(inputValue);
                    String filename = file.getName();
                    contentType = new MimetypesFileTypeMap().getContentType(file);
                    if (!"".equals(contentType)) {
                        if (filename.endsWith(".png")) {
                            contentType = "image/png";
                        } else if (filename.endsWith(".jpg") || filename.endsWith(".jpeg") || filename.endsWith(".jpe")) {
                            contentType = "image/jpeg";
                        } else if (filename.endsWith(".gif")) {
                            contentType = "image/gif";
                        } else if (filename.endsWith(".ico")) {
                            contentType = "image/image/x-icon";
                        }
                    }
                    if (contentType == null || "".equals(contentType)) {
                        contentType = "application/octet-stream";
                    }
                    StringBuffer strBuf = new StringBuffer();
                    strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                    strBuf.append("Content-Disposition: form-data; name=\"" + inputName + "\"; filename=\"" + filename + "\"\r\n");
                    strBuf.append("Content-Type:" + contentType + "\r\n\r\n");
                    ((OutputStream)out).write(strBuf.toString().getBytes());
                    DataInputStream in = new DataInputStream(new FileInputStream(file));
                    int bytes = 0;
                    byte[] bufferOut = new byte[1024];
                    while ((bytes = in.read(bufferOut)) != -1) {
                        ((OutputStream)out).write(bufferOut, 0, bytes);
                    }
                    in.close();
                }
            }
            byte[] endData = ("\r\n--" + BOUNDARY + "--\r\n").getBytes();
            ((OutputStream)out).write(endData);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            StringBuffer strBuf = new StringBuffer();
            Object is = null;
            int responseCode = conn.getResponseCode();
            BufferedReader reader = responseCode == 200 ? new BufferedReader(new InputStreamReader(conn.getInputStream())) : new BufferedReader(new InputStreamReader(conn.getErrorStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                strBuf.append(line).append("\n");
            }
            res = strBuf.toString();
            reader.close();
            reader = null;
        }
        catch (FileNotFoundException e) {
            LOG.error("formUpload error", (Throwable)e);
            throw new RuntimeException("formUpload error", e);
        }
        catch (Exception e) {
            LOG.error("formUpload error", (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
        }
        return res;
    }

    public HttpURLConnection getConnectionByUrl(URL url) throws IOException {
        HttpURLConnection conn = null != this.proxy ? (HttpURLConnection)url.openConnection(this.proxy.getNetProxy()) : (HttpURLConnection)url.openConnection();
        return conn;
    }

    public static class SimpleProxyAuthenticator
    extends Authenticator {
        private String username;
        private String password;

        public SimpleProxyAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password.toCharArray());
        }
    }

    private static class SimpleTrustManager
    implements TrustManager,
    X509TrustManager {
        private SimpleTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    private static class SimpleHostnameVerifier
    implements HostnameVerifier {
        private SimpleHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

