/*
 * Decompiled with CFR 0.152.
 */
package com.ctaiot.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequest {
    static final Logger log = LoggerFactory.getLogger((String)HttpRequest.class.getName());
    private boolean hasInit = false;
    private int socketTimeout = 10000;
    private int connectTimeout = 30000;
    private RequestConfig requestConfig;
    private CloseableHttpClient httpClient;
    private CloseableHttpResponse response;

    public HttpRequest() throws UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.init();
    }

    private void init() throws IOException {
        this.httpClient = HttpClients.createDefault();
        this.requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).build();
        this.hasInit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendGet(String url, Map<String, Object> map) throws IOException, KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException {
        if (!this.hasInit) {
            this.init();
        }
        String requestStr = "";
        String result = null;
        if (map != null) {
            log.debug("get\u8fc7\u53bb\u7684\u6570\u636e\u662f\uff1a");
            log.debug(JSONObject.toJSONString(map));
            System.out.println(map);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if ("".equals(entry.getValue())) continue;
                params.add(new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue())));
            }
            requestStr = url + URLEncodedUtils.format(params, (String)"UTF-8");
        } else {
            requestStr = url;
        }
        System.out.println(requestStr);
        HttpGet httpGet = new HttpGet(requestStr);
        httpGet.setConfig(this.requestConfig);
        log.debug("executing request" + httpGet.getRequestLine());
        try {
            this.response = this.httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = this.response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (ConnectionPoolTimeoutException e) {
            log.error("http get throw ConnectionPoolTimeoutException(wait time out)");
        }
        catch (ConnectTimeoutException e) {
            log.error("http get throw ConnectTimeoutException");
        }
        catch (SocketTimeoutException e) {
            log.error("http get throw SocketTimeoutException");
        }
        catch (Exception e) {
            log.error("http get throw Exception");
        }
        finally {
            this.response.close();
            httpGet.abort();
            this.httpClient.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendGet(String url, Map<String, Object> headers, Map<String, Object> map) throws IOException, KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException {
        if (!this.hasInit) {
            this.init();
        }
        String requestStr = "";
        String result = null;
        if (map != null) {
            log.info("====> get\u8fc7\u53bb\u7684\u6570\u636e\u662f\uff1a");
            log.info("====> " + JSONObject.toJSONString(map));
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if ("".equals(entry.getValue())) continue;
                params.add(new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue())));
            }
            requestStr = url + URLEncodedUtils.format(params, (String)"UTF-8");
        } else {
            requestStr = url;
        }
        HttpGet httpGet = new HttpGet(requestStr);
        httpGet.setConfig(this.requestConfig);
        for (Map.Entry<String, Object> e : headers.entrySet()) {
            httpGet.addHeader(e.getKey(), String.valueOf(e.getValue()));
        }
        log.info("====>  executing request" + httpGet.getRequestLine());
        try {
            this.response = this.httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = this.response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (ConnectionPoolTimeoutException e) {
            log.error("http get throw ConnectionPoolTimeoutException(wait time out)");
        }
        catch (ConnectTimeoutException e) {
            log.error("http get throw ConnectTimeoutException");
        }
        catch (SocketTimeoutException e) {
            log.error("http get throw SocketTimeoutException");
        }
        catch (Exception e) {
            log.error("http get throw Exception");
        }
        finally {
            this.response.close();
            httpGet.abort();
            this.httpClient.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendPost(String url, Map<String, Object> map) throws IOException, KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException {
        if (!this.hasInit) {
            this.init();
        }
        String result = null;
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        if (map != null) {
            log.debug("get\u8fc7\u53bb\u7684\u6570\u636e\u662f\uff1a");
            log.debug(JSONObject.toJSONString(map));
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                params.add(new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue())));
            }
        }
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(this.requestConfig);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        log.debug("executing request" + httpPost.getRequestLine());
        try {
            this.response = this.httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = this.response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (ConnectionPoolTimeoutException e) {
            log.error("http get throw ConnectionPoolTimeoutException(wait time out)");
        }
        catch (ConnectTimeoutException e) {
            log.error("http get throw ConnectTimeoutException");
        }
        catch (SocketTimeoutException e) {
            log.error("http get throw SocketTimeoutException");
        }
        catch (Exception e) {
            log.error("http get throw Exception");
        }
        finally {
            this.response.close();
            httpPost.abort();
            this.httpClient.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendPost(String url, Map<String, Object> reqMap, Map<String, Object> headerMap) throws IOException, KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException {
        if (!this.hasInit) {
            this.init();
        }
        String result = null;
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        if (reqMap != null) {
            for (Map.Entry<String, Object> entry : reqMap.entrySet()) {
                if (entry.getValue() == null) continue;
                params.add(new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue())));
            }
        }
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(this.requestConfig);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        if (headerMap != null) {
            for (Map.Entry entry : headerMap.entrySet()) {
                if (entry.getValue() == null) continue;
                httpPost.setHeader((String)entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        log.debug("executing request" + httpPost.getRequestLine());
        try {
            this.response = this.httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = this.response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (ConnectionPoolTimeoutException e) {
            log.error("http get throw ConnectionPoolTimeoutException(wait time out)");
        }
        catch (ConnectTimeoutException e) {
            log.error("http get throw ConnectTimeoutException");
        }
        catch (SocketTimeoutException e) {
            log.error("http get throw SocketTimeoutException");
        }
        catch (Exception e) {
            log.error("http get throw Exception");
            e.printStackTrace();
        }
        finally {
            this.response.close();
            httpPost.abort();
            this.httpClient.close();
        }
        return result;
    }

    public void setSocketTimeout(int newSocketTimeout) {
        this.socketTimeout = newSocketTimeout;
        this.resetRequestConfig();
    }

    public void setConnectTimeout(int newConnectTimeout) {
        this.connectTimeout = newConnectTimeout;
        this.resetRequestConfig();
    }

    private void resetRequestConfig() {
        this.requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long sendGetAndSaveFiles(String url, Map<String, Object> map, String directPath, String fileName) throws IOException, KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException {
        if (!this.hasInit) {
            this.init();
        }
        String requestStr = "";
        Long result = null;
        if (map != null) {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if ("".equals(entry.getValue())) continue;
                params.add(new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue())));
            }
            requestStr = url + URLEncodedUtils.format(params, (String)"UTF-8");
        } else {
            requestStr = url;
        }
        HttpGet httpGet = new HttpGet(requestStr);
        httpGet.setConfig(this.requestConfig);
        try {
            this.response = this.httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = this.response.getEntity();
            result = HttpRequest.writeFiles(entity.getContent(), directPath, fileName);
        }
        catch (ConnectionPoolTimeoutException e) {
            log.error("http get throw ConnectionPoolTimeoutException(wait time out)");
        }
        catch (ConnectTimeoutException e) {
            log.error("http get throw ConnectTimeoutException");
        }
        catch (SocketTimeoutException e) {
            log.error("http get throw SocketTimeoutException");
        }
        catch (Exception e) {
            log.error("http get throw Exception");
        }
        finally {
            this.response.close();
            httpGet.abort();
            this.httpClient.close();
        }
        return result;
    }

    public void setRequestConfig(RequestConfig newRequestConfig) {
        this.requestConfig = newRequestConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendGetAndSaveFile(String url, Map<String, Object> map, String directPath, String fileName) throws IOException, KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException, ConnectionPoolTimeoutException, ConnectTimeoutException, SocketTimeoutException {
        if (!this.hasInit) {
            this.init();
        }
        String requestStr = "";
        String result = null;
        if (map != null) {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if ("".equals(entry.getValue())) continue;
                params.add(new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue())));
            }
            requestStr = url + URLEncodedUtils.format(params, (String)"UTF-8");
        } else {
            requestStr = url;
        }
        long s1 = System.currentTimeMillis();
        HttpGet httpGet = new HttpGet(requestStr);
        long e1 = System.currentTimeMillis();
        log.info("====> create httpGet take : {}", (Object)(e1 - s1));
        httpGet.setConfig(this.requestConfig);
        try {
            long s2 = System.currentTimeMillis();
            log.info("====> url : {}", (Object)url);
            this.response = this.httpClient.execute((HttpUriRequest)httpGet);
            long e2 = System.currentTimeMillis();
            log.info("====> request httpGet take : {}", (Object)(e2 - s2));
            long s3 = System.currentTimeMillis();
            byte[] bytes = null;
            String filePath = directPath + File.separator + fileName;
            OutputStream outputStream = null;
            try {
                bytes = EntityUtils.toByteArray((HttpEntity)this.response.getEntity());
                outputStream = new FileOutputStream(filePath);
                outputStream.write(bytes);
            }
            catch (Exception e) {
                log.error("====> exception : {}", (Throwable)e);
            }
            finally {
                bytes = null;
                outputStream.flush();
                outputStream.close();
                log.info("====> out put close");
            }
            long e3 = System.currentTimeMillis();
            log.info("====> write httpGet take : {}", (Object)(e3 - s3));
        }
        finally {
            this.response.close();
            httpGet.abort();
            this.httpClient.close();
            log.info("====> close connection ... ");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long writeFiles(InputStream is, String directPath, String fileName) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int len = 0;
        byte[] buffer = new byte[1024];
        try {
            while ((len = is.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            is.close();
            baos.close();
            byte[] result = baos.toByteArray();
            String filePath = directPath + File.separator + fileName;
            File file = new File(filePath);
            FileOutputStream fops = new FileOutputStream(file);
            fops.write(result);
            fops.flush();
            fops.close();
            Long l = result.length;
            return l;
        }
        catch (IOException e) {
            log.error("====> exception : {}", (Throwable)e);
        }
        finally {
            log.info("====> fileName : {} is down okay .. ", (Object)fileName);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(InputStream is, String directPath, String fileName) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int len = 0;
        byte[] buffer = new byte[4096];
        try {
            while ((len = is.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            is.close();
            baos.close();
            byte[] result = baos.toByteArray();
            String filePath = directPath + File.separator + fileName;
            File file = new File(filePath);
            FileOutputStream fops = new FileOutputStream(file);
            fops.write(result);
            fops.flush();
            fops.close();
        }
        catch (IOException e) {
            log.error("====> exception : {}", (Throwable)e);
        }
        finally {
            log.info("====> fileName : {} is down okay .. ", (Object)fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream sendGetResInputStream(String url) throws IOException, KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException {
        if (!this.hasInit) {
            this.init();
        }
        InputStream is = null;
        HttpGet httpGet = new HttpGet(url);
        httpGet.setConfig(this.requestConfig);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            is = entity.getContent();
        }
        catch (ConnectionPoolTimeoutException e) {
            log.error("http get throw ConnectionPoolTimeoutException(wait time out)");
        }
        catch (ConnectTimeoutException e) {
            log.error("http get throw ConnectTimeoutException");
        }
        catch (SocketTimeoutException e) {
            log.error("http get throw SocketTimeoutException");
        }
        catch (Exception e) {
            log.error("http get throw Exception");
        }
        finally {
            httpGet.abort();
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendPostOnApplicationJson(String url, String params, Map<String, Object> headerMap) throws IOException, KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException {
        if (!this.hasInit) {
            this.init();
        }
        String result = null;
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(this.requestConfig);
        StringEntity httpEntity = new StringEntity(params.toString(), ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)httpEntity);
        if (headerMap != null) {
            for (Map.Entry<String, Object> entry : headerMap.entrySet()) {
                if (entry.getValue() == null) continue;
                httpPost.setHeader(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        log.debug("executing request" + httpPost.getRequestLine());
        try {
            this.response = this.httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = this.response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (ConnectionPoolTimeoutException e) {
            log.error("http get throw ConnectionPoolTimeoutException(wait time out)");
        }
        catch (ConnectTimeoutException e) {
            log.error("http get throw ConnectTimeoutException");
        }
        catch (SocketTimeoutException e) {
            log.error("http get throw SocketTimeoutException");
        }
        catch (Exception e) {
            log.error("http get throw Exception");
            e.printStackTrace();
        }
        finally {
            this.response.close();
            httpPost.abort();
            this.httpClient.close();
        }
        return result;
    }

    public static interface ResultListener {
        public void onConnectionPoolTimeoutError();
    }
}

