/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.builder;

import com.daikit.graphql.builder.GQLSchemaBuilderCache;
import com.daikit.graphql.builder.types.GQLEntityTypesBuilder;
import com.daikit.graphql.builder.types.GQLEnumTypesBuilder;
import com.daikit.graphql.builder.types.GQLInputEntityTypesBuilder;
import com.daikit.graphql.builder.types.GQLInterfaceTypesBuilder;
import com.daikit.graphql.builder.types.GQLMutationDeleteResultOutputTypeBuilder;
import com.daikit.graphql.builder.types.GQLMutationTypeBuilder;
import com.daikit.graphql.builder.types.GQLQueryFilterOperatorsInputTypeBuilder;
import com.daikit.graphql.builder.types.GQLQueryOrderByDirectionTypeBuilder;
import com.daikit.graphql.builder.types.GQLQueryOrderByInputTypeBuilder;
import com.daikit.graphql.builder.types.GQLQueryOrderByOutputTypeBuilder;
import com.daikit.graphql.builder.types.GQLQueryPagingInputTypeBuilder;
import com.daikit.graphql.builder.types.GQLQueryPagingOutputTypeBuilder;
import com.daikit.graphql.builder.types.GQLQueryTypeBuilder;
import com.daikit.graphql.builder.types.GQLReferencesBuilder;
import com.daikit.graphql.config.GQLSchemaConfig;
import com.daikit.graphql.data.output.GQLDeleteResult;
import com.daikit.graphql.data.output.GQLListLoadResult;
import com.daikit.graphql.datafetcher.GQLAbstractDataFetcher;
import com.daikit.graphql.datafetcher.GQLAbstractGetListDataFetcher;
import com.daikit.graphql.datafetcher.GQLAbstractSaveDataFetcher;
import com.daikit.graphql.datafetcher.GQLCustomMethodDataFetcher;
import com.daikit.graphql.datafetcher.GQLDynamicAttributeRegistry;
import com.daikit.graphql.datafetcher.GQLPropertyDataFetcher;
import com.daikit.graphql.meta.GQLInternalMetaModel;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GQLSchemaBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public GraphQLSchema build(GQLSchemaConfig schemaConfig, GQLInternalMetaModel internalMetaModel, DataFetcher<?> getByIdDataFetcher, DataFetcher<GQLListLoadResult> listDataFetcher, DataFetcher<?> saveDataFetcher, DataFetcher<GQLDeleteResult> deleteDataFetcher, DataFetcher<?> customMethodDataFetcher, List<GQLPropertyDataFetcher<?>> propertyDataFetchers) {
        this.logger.debug("START building schema...");
        GQLSchemaBuilderCache cache = new GQLSchemaBuilderCache(schemaConfig);
        GraphQLSchema.Builder builder = GraphQLSchema.newSchema();
        cache.setCodeRegistryBuilder(GraphQLCodeRegistry.newCodeRegistry());
        List<GQLPropertyDataFetcher<?>> nullSafePropertyDataFetchers = propertyDataFetchers == null ? Collections.emptyList() : propertyDataFetchers;
        List<DataFetcher<?>> allDataFetchers = Stream.concat(Stream.of(getByIdDataFetcher, listDataFetcher, saveDataFetcher, deleteDataFetcher, customMethodDataFetcher), propertyDataFetchers.stream()).collect(Collectors.toList());
        this.setContext(schemaConfig, internalMetaModel, allDataFetchers);
        GQLDynamicAttributeRegistry dynAttrRegistry = new GQLDynamicAttributeRegistry(internalMetaModel);
        if (listDataFetcher instanceof GQLAbstractGetListDataFetcher) {
            ((GQLAbstractGetListDataFetcher)listDataFetcher).setDynamicAttributeRegistry(dynAttrRegistry);
        }
        if (saveDataFetcher instanceof GQLAbstractSaveDataFetcher) {
            ((GQLAbstractSaveDataFetcher)saveDataFetcher).setDynamicAttributeRegistry(dynAttrRegistry);
        }
        if (customMethodDataFetcher instanceof GQLCustomMethodDataFetcher) {
            this.logger.debug("START registering custom methods...");
            ((GQLCustomMethodDataFetcher)customMethodDataFetcher).registerCustomMethods(internalMetaModel.getCustomMethods().stream().map(method -> method.getMethod()).collect(Collectors.toList()));
            this.logger.debug("END registering custom methods");
        }
        this.logger.debug("START building output reference types...");
        new GQLReferencesBuilder(cache).buildTypeReferences(internalMetaModel);
        new GQLEnumTypesBuilder(cache).buildEnumTypes(internalMetaModel);
        new GQLInterfaceTypesBuilder(cache).buildInterfaceTypes(internalMetaModel, nullSafePropertyDataFetchers);
        new GQLEntityTypesBuilder(cache).buildEntityTypes(internalMetaModel, nullSafePropertyDataFetchers);
        this.logger.debug("END building output reference types");
        this.logger.debug("END building mutations utility types...");
        new GQLMutationDeleteResultOutputTypeBuilder(cache).buildDeleteResultOutputType();
        this.logger.debug("END building mutations utility types");
        this.logger.debug("END building queries utility types...");
        new GQLQueryPagingInputTypeBuilder(cache).buildPagingInputType();
        new GQLQueryPagingOutputTypeBuilder(cache).buildPagingOutputType();
        new GQLQueryOrderByDirectionTypeBuilder(cache).buildOrderByDirectionType();
        new GQLQueryOrderByInputTypeBuilder(cache).buildOrderByInputType();
        new GQLQueryOrderByOutputTypeBuilder(cache).buildOrderByOutputType();
        new GQLQueryFilterOperatorsInputTypeBuilder(cache).buildFilterOperatorsInputTypes(internalMetaModel);
        this.logger.debug("END building queries utility types");
        this.logger.debug("START building mutation entities input types...");
        new GQLInputEntityTypesBuilder(cache).buildInputEntities(internalMetaModel);
        this.logger.debug("END building mutation entities input types");
        this.logger.debug("START building queries...");
        builder.query(new GQLQueryTypeBuilder(cache).buildQueryType(internalMetaModel, getByIdDataFetcher, listDataFetcher, customMethodDataFetcher));
        this.logger.debug("END building queries");
        this.logger.debug("START building mutations...");
        builder.mutation(new GQLMutationTypeBuilder(cache).buildMutationType(internalMetaModel, saveDataFetcher, deleteDataFetcher, customMethodDataFetcher));
        this.logger.debug("END building mutations");
        builder.additionalTypes(this.getDictionnaryTypes(cache));
        this.logger.debug("Register code registry");
        builder.codeRegistry(cache.getCodeRegistryBuilder().build());
        GraphQLSchema schema = builder.build();
        this.logger.debug("END building schema");
        return schema;
    }

    private void setContext(GQLSchemaConfig schemaConfig, GQLInternalMetaModel metaModel, List<DataFetcher<?>> allDataFetchers) {
        allDataFetchers.forEach(dataFetcher -> {
            if (dataFetcher instanceof GQLAbstractDataFetcher) {
                ((GQLAbstractDataFetcher)dataFetcher).setMetaModel(metaModel);
                ((GQLAbstractDataFetcher)dataFetcher).setSchemaConfig(schemaConfig);
            }
        });
    }

    private Set<GraphQLType> getDictionnaryTypes(GQLSchemaBuilderCache cache) {
        HashSet<GraphQLType> dictionnaryTypes = new HashSet<GraphQLType>();
        dictionnaryTypes.addAll(cache.getObjectTypes().values());
        dictionnaryTypes.addAll(cache.getInterfaceTypes().values());
        return dictionnaryTypes;
    }
}

