/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.builder.types;

import com.daikit.graphql.builder.GQLSchemaBuilderCache;
import com.daikit.graphql.builder.GQLSchemaBuilderUtils;
import com.daikit.graphql.builder.types.GQLAbstractInputOutputTypesBuilder;
import com.daikit.graphql.meta.GQLInternalMetaModel;
import com.daikit.graphql.meta.attribute.GQLAbstractAttributeMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeEntityMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeEnumMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeListEntityMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeListEnumMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeListScalarMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeScalarMetaData;
import com.daikit.graphql.meta.internal.GQLAbstractEntityMetaDataInfos;
import com.daikit.graphql.meta.internal.GQLConcreteEntityMetaDataInfos;
import com.daikit.graphql.meta.internal.GQLInterfaceEntityMetaDataInfos;
import com.daikit.graphql.utils.Message;
import graphql.Scalars;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class GQLInputEntityTypesBuilder
extends GQLAbstractInputOutputTypesBuilder {
    public GQLInputEntityTypesBuilder(GQLSchemaBuilderCache cache) {
        super(cache);
    }

    public void buildInputEntities(GQLInternalMetaModel metaModel) {
        this.logger.debug("START building input entity types...");
        new BuilderImpl().build(metaModel);
        this.logger.debug("END building input entity types");
    }

    private class BuilderImpl {
        private final List<GQLAbstractEntityMetaDataInfos> allInfos = new ArrayList<GQLAbstractEntityMetaDataInfos>();
        private final Map<GQLAbstractEntityMetaDataInfos, Set<Class<?>>> lazyEntities = new HashMap();

        private BuilderImpl() {
        }

        public void build(GQLInternalMetaModel metaModel) {
            this.allInfos.addAll(metaModel.getEmbeddedConcretes());
            this.allInfos.addAll(metaModel.getEmbeddedInterfaces());
            this.allInfos.addAll(metaModel.getAllNonEmbeddedEntities());
            this.allInfos.forEach(infos -> this.getOrBuildAndRegisterInputEntity((GQLAbstractEntityMetaDataInfos)infos));
            this.generateLazyEntities();
        }

        private GraphQLInputObjectType getOrBuildAndRegisterInputEntity(Class<?> entityClass) {
            GraphQLInputObjectType existingInputEntityType = GQLInputEntityTypesBuilder.this.getCache().getInputEntityTypes().get(entityClass);
            if (existingInputEntityType == null) {
                GQLAbstractEntityMetaDataInfos infos = this.allInfos.stream().filter(current -> entityClass.equals(current.getEntity().getEntityClass())).findFirst().orElseThrow(() -> new IllegalArgumentException(Message.format("No meta data infos defined for entity class [{}]", entityClass)));
                existingInputEntityType = this.getOrBuildAndRegisterInputEntity(infos);
            }
            return existingInputEntityType;
        }

        private GraphQLInputObjectType getOrBuildAndRegisterInputEntity(GQLAbstractEntityMetaDataInfos infos) {
            GraphQLInputObjectType inputObjectType = GQLInputEntityTypesBuilder.this.getCache().getInputEntityTypes().get(infos.getEntity().getEntityClass());
            if (inputObjectType == null && (inputObjectType = !infos.getEntity().isEmbedded() || infos.getEntity().isEmbedded() && infos.isConcrete() ? this.buildInputEntity(infos) : this.buildEmbeddedAbstractInputEntity((GQLInterfaceEntityMetaDataInfos)infos)) != null) {
                GQLInputEntityTypesBuilder.this.getCache().getInputEntityTypes().put(infos.getEntity().getEntityClass(), inputObjectType);
            }
            return inputObjectType;
        }

        private GraphQLInputObjectType buildInputEntity(GQLAbstractEntityMetaDataInfos infos) {
            GQLInputEntityTypesBuilder.this.logger.debug(Message.format("Build input save entity type [{}]", infos.getEntity().getName()));
            List<GraphQLInputObjectField> buildFields = this.buildInputEntityFields(infos);
            GraphQLInputObjectType ret = null;
            if (this.lazyEntities.containsKey(infos)) {
                GQLInputEntityTypesBuilder.this.logger.debug(Message.format("Build input save entity [{}] deferred because of lazy field loading.", infos.getEntity().getName()));
            } else {
                GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject();
                builder.name(infos.getEntity().getName() + GQLInputEntityTypesBuilder.this.getConfig().getInputTypeNameSuffix());
                builder.description("Object input type for " + (infos.getEntity().isEmbedded() ? "embedded " : "") + "entity [" + infos.getEntity().getName() + "]");
                ArrayList<GraphQLInputObjectField> fields = new ArrayList<GraphQLInputObjectField>();
                if (infos.getEntity().getAttributes().stream().filter(attribute -> GQLInputEntityTypesBuilder.this.getConfig().getAttributeIdName().equals(attribute.getName())).count() > 0L) {
                    fields.add(this.buildIdInputField());
                }
                GQLSchemaBuilderUtils.addOrReplaceInputObjectFields(fields, buildFields);
                builder.fields(fields);
                ret = builder.build();
            }
            return ret;
        }

        private List<GraphQLInputObjectField> buildInputEntityFields(GQLAbstractEntityMetaDataInfos infos) {
            GQLInputEntityTypesBuilder.this.logger.debug(Message.format("Build input save entity fields for entity [{}]", infos.getEntity().getName()));
            List<GraphQLInputObjectField> inputFields = infos.getEntity().getAttributes().stream().filter(attribute -> attribute.isSaveable()).map(attribute -> this.buildInputEntityField(infos, (GQLAbstractAttributeMetaData)attribute)).flatMap(list -> list.stream()).filter(Objects::nonNull).collect(Collectors.toList());
            return inputFields;
        }

        private List<GraphQLInputObjectField> buildInputEntityField(GQLAbstractEntityMetaDataInfos infos, GQLAbstractAttributeMetaData attribute) {
            GQLInputEntityTypesBuilder.this.logger.debug(Message.format("Build input save entity field for attribute [{}]", attribute.getName()));
            ArrayList<GraphQLInputObjectField> inputFields = new ArrayList<GraphQLInputObjectField>();
            String name = attribute.getName();
            String nullableSuffix = this.getDescriptionNullableSuffix(attribute);
            if (attribute instanceof GQLAttributeScalarMetaData) {
                inputFields.add(GQLInputEntityTypesBuilder.this.buildInputField(name, "Input field [Scalar] [" + attribute.getName() + "]" + nullableSuffix, (GraphQLInputType)GQLInputEntityTypesBuilder.this.getConfig().getScalarType(((GQLAttributeScalarMetaData)attribute).getScalarType()).get()));
            } else if (attribute instanceof GQLAttributeEnumMetaData) {
                inputFields.add(GQLInputEntityTypesBuilder.this.buildInputField(name, "Input field [Enum] [" + attribute.getName() + "]" + nullableSuffix, (GraphQLInputType)GQLInputEntityTypesBuilder.this.getCache().getEnumType(((GQLAttributeEnumMetaData)attribute).getEnumClass())));
            } else if (attribute instanceof GQLAttributeEntityMetaData) {
                if (((GQLAttributeEntityMetaData)attribute).isEmbedded()) {
                    GraphQLInputObjectType existingInputEntityType = this.getOrBuildAndRegisterInputEntity(((GQLAttributeEntityMetaData)attribute).getEntityClass());
                    inputFields.add(GQLInputEntityTypesBuilder.this.buildInputField(name, "Input field [Object embedded] [" + attribute.getName() + "]" + nullableSuffix, (GraphQLInputType)existingInputEntityType));
                } else {
                    inputFields.add(GQLInputEntityTypesBuilder.this.buildInputField(name + GQLInputEntityTypesBuilder.this.getConfig().getAttributeIdSuffix(), "Input field [id] of [" + attribute.getName() + "]" + nullableSuffix, (GraphQLInputType)Scalars.GraphQLID));
                }
            } else if (attribute instanceof GQLAttributeListEnumMetaData) {
                inputFields.add(GQLInputEntityTypesBuilder.this.buildInputField(name, "Input field [List enum] [" + attribute.getName() + "]" + nullableSuffix, (GraphQLInputType)new GraphQLList((GraphQLType)GQLInputEntityTypesBuilder.this.getCache().getEnumType(((GQLAttributeListEnumMetaData)attribute).getEnumClass()))));
            } else if (attribute instanceof GQLAttributeListEntityMetaData) {
                if (((GQLAttributeListEntityMetaData)attribute).isEmbedded()) {
                    GraphQLInputObjectType existingInputEntityType = this.getOrBuildAndRegisterInputEntity(((GQLAttributeListEntityMetaData)attribute).getForeignClass());
                    inputFields.add(GQLInputEntityTypesBuilder.this.buildInputField(name, "Input field [List object embedded] [" + attribute.getName() + "]" + nullableSuffix, (GraphQLInputType)new GraphQLList((GraphQLType)existingInputEntityType)));
                } else {
                    if (((GQLAttributeListEntityMetaData)attribute).isCascadeSave()) {
                        GraphQLInputType foreignInputType = (GraphQLInputType)GQLInputEntityTypesBuilder.this.getCache().getInputEntityTypes().get(((GQLAttributeListEntityMetaData)attribute).getForeignClass());
                        if (foreignInputType == null) {
                            GQLInputEntityTypesBuilder.this.logger.debug(Message.format("Input save entity field attribute [{}] build deferred", attribute.getName()));
                            this.lazyEntities.computeIfAbsent(infos, k -> new HashSet()).add(((GQLAttributeListEntityMetaData)attribute).getForeignClass());
                        } else {
                            inputFields.add(GQLInputEntityTypesBuilder.this.buildInputField(name.endsWith(GQLInputEntityTypesBuilder.this.getConfig().getAttributePluralSuffix()) ? name : name + GQLInputEntityTypesBuilder.this.getConfig().getAttributePluralSuffix(), "Input field [Array] of [" + attribute.getName() + "]" + this.getDescriptionNullableSuffix(attribute), (GraphQLInputType)new GraphQLList((GraphQLType)foreignInputType)));
                        }
                    }
                    inputFields.add(GQLInputEntityTypesBuilder.this.buildInputField((name.endsWith(GQLInputEntityTypesBuilder.this.getConfig().getAttributePluralSuffix()) ? name.substring(0, name.length() - 1) : name) + GQLInputEntityTypesBuilder.this.getConfig().getAttributeIdPluralSuffix(), "Input field [Array] of [id] of [" + attribute.getName() + "]" + this.getDescriptionNullableSuffix(attribute), (GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLID)));
                }
            } else if (attribute instanceof GQLAttributeListScalarMetaData) {
                inputFields.add(GQLInputEntityTypesBuilder.this.buildInputField(name, "Input field [List scalar] [" + attribute.getName() + "]" + nullableSuffix, (GraphQLInputType)new GraphQLList((GraphQLType)GQLInputEntityTypesBuilder.this.getCache().getScalarType(((GQLAttributeListScalarMetaData)attribute).getScalarType()))));
            } else {
                throw new IllegalArgumentException(Message.format("Attribute could not be mapped to GraphQL [{}]", attribute));
            }
            return inputFields;
        }

        private GraphQLInputObjectType buildEmbeddedAbstractInputEntity(GQLInterfaceEntityMetaDataInfos infos) {
            GQLInputEntityTypesBuilder.this.logger.debug(Message.format("Build input save embedded abstract entity type [{}]", infos.getEntity().getName()));
            GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject();
            builder.name(infos.getEntity().getName() + GQLInputEntityTypesBuilder.this.getConfig().getInputTypeNameSuffix());
            builder.description("Object input type for embedded abstract entity [" + infos.getEntity().getName() + "]");
            List fields = infos.getConcreteSubEntities().stream().map(concreteSubEntityType -> this.buildConcreteExtendingInputEntity((GQLConcreteEntityMetaDataInfos)concreteSubEntityType)).collect(Collectors.toList());
            builder.fields(fields);
            GraphQLInputObjectType ret = builder.build();
            return ret;
        }

        private GraphQLInputObjectField buildConcreteExtendingInputEntity(GQLConcreteEntityMetaDataInfos concreteSubEntityType) {
            GQLInputEntityTypesBuilder.this.logger.debug(Message.format("Build input save entity field for concrete embedded extending type [{}]", concreteSubEntityType.getEntity().getName()));
            String name = GQLInputEntityTypesBuilder.this.getConfig().getConcreteEmbeddedExtendingTypeNamePrefix() + concreteSubEntityType.getEntity().getName();
            GraphQLInputObjectType type = GQLInputEntityTypesBuilder.this.getCache().getInputEntityType(concreteSubEntityType.getEntity().getEntityClass());
            GraphQLInputObjectField.Builder builder = GraphQLInputObjectField.newInputObjectField();
            builder.name(name);
            builder.description("Input field [object-embedded] [" + name + "] for concrete sub type [" + concreteSubEntityType.getEntity().getName() + "] within [" + concreteSubEntityType.getSuperEntity().getEntity().getName() + "]");
            builder.type((GraphQLInputType)type);
            GraphQLInputObjectField ret = builder.build();
            return ret;
        }

        private void generateLazyEntities() {
            GQLInputEntityTypesBuilder.this.logger.debug("START building lazy entities...");
            this.generateLazyEntitiesWrapped();
            GQLInputEntityTypesBuilder.this.logger.debug("END building lazy entities");
        }

        private void generateLazyEntitiesWrapped() {
            if (!this.lazyEntities.isEmpty()) {
                boolean atLeastOneBuilt = false;
                Iterator<Map.Entry<GQLAbstractEntityMetaDataInfos, Set<Class<?>>>> iterator = this.lazyEntities.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<GQLAbstractEntityMetaDataInfos, Set<Class<?>>> entry2 = iterator.next();
                    if (!entry2.getValue().stream().allMatch(foreignClass -> GQLInputEntityTypesBuilder.this.getCache().getInputEntityTypes().get(foreignClass) != null)) continue;
                    iterator.remove();
                    atLeastOneBuilt = true;
                    this.getOrBuildAndRegisterInputEntity(entry2.getKey());
                }
                if (atLeastOneBuilt) {
                    this.generateLazyEntitiesWrapped();
                } else {
                    throw new IllegalArgumentException(Message.format("Impossible to generate input types for [{}]. Maybe because of a loop ?", this.lazyEntities.entrySet().stream().map(entry -> ((GQLAbstractEntityMetaDataInfos)entry.getKey()).getEntity().getName() + " (fields=[" + ((Set)entry.getValue()).stream().map(clazz -> clazz.getSimpleName()).collect(Collectors.joining(", ")) + "])").collect(Collectors.joining(", "))));
                }
            }
        }

        private String getDescriptionNullableSuffix(GQLAbstractAttributeMetaData attribute) {
            String description = "";
            if (!attribute.isNullableForCreate()) {
                description = !attribute.isNullableForUpdate() ? " [field is mandatory]" : " [field is mandatory for creation]";
            } else if (!attribute.isNullableForUpdate()) {
                description = " [field is mandatory for update]";
            }
            return description;
        }

        private GraphQLInputObjectField buildIdInputField() {
            GraphQLInputObjectField.Builder builder = GraphQLInputObjectField.newInputObjectField();
            builder.name(GQLInputEntityTypesBuilder.this.getConfig().getAttributeIdName());
            builder.description("Input field [" + GQLInputEntityTypesBuilder.this.getConfig().getAttributeIdName() + "]");
            builder.type((GraphQLInputType)Scalars.GraphQLID);
            return builder.build();
        }
    }
}

