/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.builder.types;

import com.daikit.graphql.builder.GQLSchemaBuilderCache;
import com.daikit.graphql.builder.types.GQLAbstractTypesBuilder;
import graphql.Scalars;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import org.apache.commons.lang3.StringUtils;

public class GQLQueryPagingInputTypeBuilder
extends GQLAbstractTypesBuilder {
    public GQLQueryPagingInputTypeBuilder(GQLSchemaBuilderCache cache) {
        super(cache);
    }

    public void buildPagingInputType() {
        this.logger.debug("Build paging input type");
        this.getCache().setPagingInputObjectType(this.buildPagingQueryInputObjectType());
    }

    private GraphQLInputObjectType buildPagingQueryInputObjectType() {
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject();
        builder.name(StringUtils.capitalize((String)this.getConfig().getQueryGetListPagingAttributeName()) + this.getConfig().getInputTypeNameSuffix());
        builder.description("Query object for Pagination Requests, specifying the requested offset (0-indexed, default=0) and limit (default=" + this.getConfig().getQueryGetListPagingAttributeLimitDefaultValue() + "). Example: (" + this.getConfig().getQueryGetListPagingAttributeName() + ": { " + this.getConfig().getQueryGetListPagingAttributeOffsetName() + ": 0, " + this.getConfig().getQueryGetListPagingAttributeLimitName() + ": " + this.getConfig().getQueryGetListPagingAttributeLimitDefaultValue() + " })");
        GraphQLInputObjectField.Builder offsetFieldBuilder = GraphQLInputObjectField.newInputObjectField();
        offsetFieldBuilder.name(this.getConfig().getQueryGetListPagingAttributeOffsetName());
        offsetFieldBuilder.description("Offset of the first result to be returned, starting with 0 (0-indexed). This is equivalent to the page size multiplied by the index (0-indexed) of the page to be retrieved.");
        offsetFieldBuilder.type((GraphQLInputType)Scalars.GraphQLInt);
        offsetFieldBuilder.defaultValue((Object)0);
        builder.field(offsetFieldBuilder.build());
        GraphQLInputObjectField.Builder liitFieldBuilder = GraphQLInputObjectField.newInputObjectField();
        liitFieldBuilder.name(this.getConfig().getQueryGetListPagingAttributeLimitName());
        liitFieldBuilder.description("How many results should the resulting load result contain. This is equivalent to the page size. Default value is [" + this.getConfig().getQueryGetListPagingAttributeLimitDefaultValue() + "]");
        liitFieldBuilder.type((GraphQLInputType)Scalars.GraphQLInt);
        offsetFieldBuilder.defaultValue((Object)this.getConfig().getQueryGetListPagingAttributeLimitDefaultValue());
        builder.field(liitFieldBuilder.build());
        return builder.build();
    }
}

