/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.datafetcher;

import com.daikit.graphql.dynamicattribute.IGQLAbstractDynamicAttribute;
import com.daikit.graphql.dynamicattribute.IGQLDynamicAttributeGetter;
import com.daikit.graphql.dynamicattribute.IGQLDynamicAttributeSetter;
import com.daikit.graphql.meta.GQLInternalMetaModel;
import com.daikit.graphql.utils.Message;
import graphql.GraphQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class GQLDynamicAttributeRegistry {
    private final Map<Class<?>, Map<String, IGQLDynamicAttributeSetter<?, ?>>> dynamicAttributeSetters = new HashMap();
    private final Map<Class<?>, Map<String, IGQLDynamicAttributeGetter<?, ?>>> dynamicAttributeGetters = new HashMap();

    public GQLDynamicAttributeRegistry(GQLInternalMetaModel metaModel) {
        this.register(metaModel, metaModel.getDynamicAttributeSetters(), this.dynamicAttributeSetters);
        this.register(metaModel, metaModel.getDynamicAttributeGetters(), this.dynamicAttributeGetters);
    }

    private <T extends IGQLAbstractDynamicAttribute<?>> void register(GQLInternalMetaModel metaModel, Collection<T> dynamicAttributes, Map<Class<?>, Map<String, T>> map) {
        dynamicAttributes.stream().forEach(dynAttr -> {
            Map attrMap = map.computeIfAbsent(dynAttr.getEntityType(), x -> new HashMap());
            IGQLAbstractDynamicAttribute existing = (IGQLAbstractDynamicAttribute)attrMap.get(dynAttr.getName());
            if (existing != null && !existing.equals(dynAttr)) {
                throw new GraphQLException(Message.format("Duplicate dynamic attributes registered for entity {} and property name {}.", dynAttr.getEntityType(), dynAttr.getName()));
            }
            attrMap.put(dynAttr.getName(), dynAttr);
        });
    }

    public <ENTITY_TYPE, SETTER_ATTRIBUTE_TYPE> Optional<IGQLDynamicAttributeSetter<ENTITY_TYPE, SETTER_ATTRIBUTE_TYPE>> getSetter(Class<?> entityClass, String attributeName) {
        Map<String, IGQLDynamicAttributeSetter<?, ?>> map = this.dynamicAttributeSetters.get(entityClass);
        return map == null ? Optional.empty() : Optional.ofNullable(map.get(attributeName));
    }

    public <ENTITY_TYPE, SETTER_ATTRIBUTE_TYPE> Optional<IGQLDynamicAttributeGetter<ENTITY_TYPE, SETTER_ATTRIBUTE_TYPE>> getGetter(Class<?> entityClass, String attributeName) {
        Map<String, IGQLDynamicAttributeGetter<?, ?>> map = this.dynamicAttributeGetters.get(entityClass);
        return map == null ? Optional.empty() : Optional.ofNullable(map.get(attributeName));
    }
}

