/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.execution;

import com.daikit.graphql.builder.GQLSchemaBuilder;
import com.daikit.graphql.config.GQLSchemaConfig;
import com.daikit.graphql.data.output.GQLDeleteResult;
import com.daikit.graphql.data.output.GQLExecutionResult;
import com.daikit.graphql.data.output.GQLListLoadResult;
import com.daikit.graphql.datafetcher.GQLPropertyDataFetcher;
import com.daikit.graphql.execution.IGQLErrorProcessor;
import com.daikit.graphql.execution.IGQLExecutorCallback;
import com.daikit.graphql.meta.GQLInternalMetaModel;
import com.daikit.graphql.meta.GQLMetaModel;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Map;

public class GQLExecutor {
    private final GQLInternalMetaModel metaModel;
    private final GraphQLSchema schema;
    private final GraphQL graphql;
    private final IGQLErrorProcessor errorProcessor;
    private final IGQLExecutorCallback callback;

    public GQLExecutor(GQLSchemaConfig schemaConfig, GQLMetaModel metaModel, IGQLErrorProcessor errorProcessor, DataFetcher<?> getByIdDataFetcher, DataFetcher<GQLListLoadResult> listDataFetcher, DataFetcher<?> saveDataFetcher, DataFetcher<GQLDeleteResult> deleteDataFetcher, DataFetcher<?> customMethodDataFetcher, List<GQLPropertyDataFetcher<?>> propertyDataFetchers) {
        this(schemaConfig, metaModel, errorProcessor, null, getByIdDataFetcher, listDataFetcher, saveDataFetcher, deleteDataFetcher, customMethodDataFetcher, propertyDataFetchers);
    }

    public GQLExecutor(GQLSchemaConfig schemaConfig, GQLMetaModel metaModel, IGQLErrorProcessor errorProcessor, IGQLExecutorCallback callback, DataFetcher<?> getByIdDataFetcher, DataFetcher<GQLListLoadResult> listDataFetcher, DataFetcher<?> saveDataFetcher, DataFetcher<GQLDeleteResult> deleteDataFetcher, DataFetcher<?> customMethodDataFetcher, List<GQLPropertyDataFetcher<?>> propertyDataFetchers) {
        this.errorProcessor = errorProcessor;
        this.callback = callback;
        this.metaModel = new GQLInternalMetaModel(schemaConfig, metaModel);
        this.schema = new GQLSchemaBuilder().build(schemaConfig, this.metaModel, getByIdDataFetcher, listDataFetcher, saveDataFetcher, deleteDataFetcher, customMethodDataFetcher, propertyDataFetchers);
        this.graphql = GraphQL.newGraphQL((GraphQLSchema)this.schema).build();
    }

    public GQLExecutionResult execute(String requestString) {
        return this.execute(ExecutionInput.newExecutionInput().query(requestString).build());
    }

    public GQLExecutionResult execute(String requestString, String operationName, Object context, Map<String, Object> arguments) {
        return this.execute(ExecutionInput.newExecutionInput().query(requestString).operationName(operationName).context(context).root(context).variables(arguments).build());
    }

    public GQLExecutionResult execute(ExecutionInput executionInput) {
        if (this.callback != null) {
            this.callback.onBeforeExecute(executionInput);
        }
        GQLExecutionResult executionResult = this.wrapResult(this.graphql.execute(executionInput));
        if (this.callback != null) {
            this.callback.onAfterExecute(executionInput, executionResult);
        }
        return executionResult;
    }

    protected GQLExecutionResult wrapResult(ExecutionResult executionResult) {
        return new GQLExecutionResult(executionResult, this.errorProcessor.handleError(executionResult.getErrors()));
    }

    public GraphQLSchema getSchema() {
        return this.schema;
    }

    public GraphQL getGraphql() {
        return this.graphql;
    }

    public IGQLErrorProcessor getErrorProcessor() {
        return this.errorProcessor;
    }

    public GQLInternalMetaModel getMetaModel() {
        return this.metaModel;
    }
}

