/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.meta.builder;

import com.daikit.generics.utils.GenericsUtils;
import com.daikit.graphql.config.GQLSchemaConfig;
import com.daikit.graphql.dynamicattribute.IGQLAbstractDynamicAttribute;
import com.daikit.graphql.dynamicattribute.IGQLDynamicAttributeGetter;
import com.daikit.graphql.dynamicattribute.IGQLDynamicAttributeSetter;
import com.daikit.graphql.enums.GQLScalarTypeEnum;
import com.daikit.graphql.meta.attribute.GQLAbstractAttributeMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeEntityMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeEnumMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeListEntityMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeListEnumMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeListScalarMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeScalarMetaData;
import com.daikit.graphql.meta.builder.GQLAbstractMetaDataBuilder;
import com.daikit.graphql.meta.entity.GQLEntityMetaData;
import com.daikit.graphql.meta.entity.GQLEnumMetaData;
import com.daikit.graphql.utils.Message;
import java.lang.reflect.Type;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class GQLDynamicAttributeMetaDataBuilder
extends GQLAbstractMetaDataBuilder {
    public GQLDynamicAttributeMetaDataBuilder(GQLSchemaConfig schemaConfig) {
        super(schemaConfig);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GQLAbstractAttributeMetaData build(Collection<GQLEnumMetaData> enumMetaDatas, Collection<GQLEntityMetaData> entityMetaDatas, IGQLAbstractDynamicAttribute<?> attribute) {
        GQLAbstractAttributeMetaData attributeMetaData;
        Type attributeType;
        boolean readable = false;
        boolean saveable = false;
        boolean filterable = false;
        if (attribute instanceof IGQLDynamicAttributeGetter) {
            attributeType = (Type)GenericsUtils.getTypeArguments(attribute.getClass(), IGQLDynamicAttributeGetter.class).get(1);
            readable = true;
            saveable = attribute instanceof IGQLDynamicAttributeSetter;
            filterable = StringUtils.isNotEmpty((CharSequence)((IGQLDynamicAttributeGetter)attribute).getFilterQueryPath());
        } else {
            if (!(attribute instanceof IGQLDynamicAttributeSetter)) throw new IllegalArgumentException("Unsupported dynamic attribute type for : " + attribute.getClass().getName());
            attributeType = (Type)GenericsUtils.getTypeArguments(attribute.getClass(), IGQLDynamicAttributeSetter.class).get(1);
            saveable = true;
        }
        Class attributeRawClass = GenericsUtils.getTypeClass((Type)attributeType);
        if (this.getConfig().isScalarType(attributeRawClass) || attributeRawClass.isArray() && this.getConfig().isScalarType(attributeRawClass.getComponentType()) && GQLScalarTypeEnum.BYTE.toString().equals(this.getConfig().getScalarTypeCodeFromClass(attributeRawClass.getComponentType()).get())) {
            attributeMetaData = new GQLAttributeScalarMetaData();
            ((GQLAttributeScalarMetaData)attributeMetaData).setScalarType(this.getConfig().getScalarTypeCodeFromClass(attributeRawClass).get());
        } else if (this.isEnum(enumMetaDatas, attributeRawClass)) {
            attributeMetaData = new GQLAttributeEnumMetaData();
            ((GQLAttributeEnumMetaData)attributeMetaData).setEnumClass(attributeRawClass);
        } else if (this.isEntity(entityMetaDatas, attributeRawClass)) {
            attributeMetaData = new GQLAttributeEntityMetaData();
            ((GQLAttributeEntityMetaData)attributeMetaData).setEntityClass(attributeRawClass);
        } else {
            if (!Collection.class.isAssignableFrom(attributeRawClass)) throw new IllegalArgumentException(Message.format("Not handled  dynamic attribute [{}] on [{}] type [{}].", attribute.getName(), attribute.getEntityType().getName(), attributeRawClass.getSimpleName()));
            Class foreignClass = (Class)GenericsUtils.getTypeArgumentsAsClasses((Type)attributeType, Collection.class).get(0);
            if (this.getConfig().isScalarType(foreignClass)) {
                attributeMetaData = new GQLAttributeListScalarMetaData();
                ((GQLAttributeListScalarMetaData)attributeMetaData).setScalarType(this.getConfig().getScalarTypeCodeFromClass(foreignClass).get());
            } else if (this.isEnum(enumMetaDatas, foreignClass)) {
                attributeMetaData = new GQLAttributeListEnumMetaData();
                ((GQLAttributeListEnumMetaData)attributeMetaData).setEnumClass(foreignClass);
            } else {
                if (!this.isEntity(entityMetaDatas, foreignClass)) throw new IllegalArgumentException(Message.format("Not handled dynamic attribute [{}] on [{}] collection type [{}].", attribute.getName(), attribute.getEntityType().getName(), foreignClass.getName()));
                attributeMetaData = new GQLAttributeListEntityMetaData();
                ((GQLAttributeListEntityMetaData)attributeMetaData).setForeignClass(foreignClass);
            }
        }
        attributeMetaData.setReadable(readable);
        attributeMetaData.setSaveable(saveable);
        attributeMetaData.setFilterable(filterable);
        attributeMetaData.setName(attribute.getName());
        attributeMetaData.setDynamicAttributeGetter(attribute instanceof IGQLDynamicAttributeGetter ? (IGQLDynamicAttributeGetter)attribute : null);
        attributeMetaData.setDynamicAttributeSetter(attribute instanceof IGQLDynamicAttributeSetter ? (IGQLDynamicAttributeSetter)attribute : null);
        return attributeMetaData;
    }
}

