/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.builder.types;

import com.daikit.graphql.builder.GQLAbstractSchemaSubBuilder;
import com.daikit.graphql.builder.GQLSchemaBuilderCache;
import com.daikit.graphql.meta.GQLInternalMetaModel;
import com.daikit.graphql.meta.entity.GQLEnumMetaData;
import com.daikit.graphql.utils.Message;
import graphql.schema.GraphQLEnumType;
import java.util.stream.Stream;

public class GQLEnumTypesBuilder
extends GQLAbstractSchemaSubBuilder {
    public GQLEnumTypesBuilder(GQLSchemaBuilderCache cache) {
        super(cache);
    }

    public void buildEnumTypes(GQLInternalMetaModel metaModel) {
        this.logger.debug("START building enum types...");
        metaModel.getEnums().forEach(enumMeta -> this.getCache().getEnumTypes().put(enumMeta.getEnumClass(), this.buildEnum((GQLEnumMetaData)enumMeta)));
        this.logger.debug("END building enum types");
    }

    private GraphQLEnumType buildEnum(GQLEnumMetaData enumMetaData) {
        this.logger.debug(Message.format("Build enum type [{}]", enumMetaData.getName()));
        GraphQLEnumType.Builder builder = GraphQLEnumType.newEnum();
        builder.name(enumMetaData.getName());
        builder.description("Enum type for [" + enumMetaData.getName() + "]");
        Stream.of(enumMetaData.getEnumClass().getEnumConstants()).forEach(enumValue -> builder.value(enumValue.name(), enumValue));
        return builder.build();
    }
}

