/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.datafetcher;

import com.daikit.graphql.datafetcher.GQLAbstractDataFetcher;
import com.daikit.graphql.datafetcher.GQLDynamicAttributeRegistry;
import com.daikit.graphql.exception.GQLException;
import com.daikit.graphql.utils.Message;
import graphql.language.Field;
import graphql.language.ObjectValue;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.schema.DataFetchingEnvironment;
import java.util.Map;

public abstract class GQLAbstractSaveDataFetcher<SUPER_ENTITY_TYPE>
extends GQLAbstractDataFetcher<SUPER_ENTITY_TYPE> {
    private GQLDynamicAttributeRegistry dynamicAttributeRegistry;

    protected abstract void save(SUPER_ENTITY_TYPE var1);

    protected abstract SUPER_ENTITY_TYPE getOrCreateAndSetProperties(Class<?> var1, GQLDynamicAttributeRegistry var2, Map<String, Object> var3);

    protected SUPER_ENTITY_TYPE save(Class<?> entityClass, GQLDynamicAttributeRegistry dynamicAttributeRegistry, Map<String, Object> fieldValueMap) {
        SUPER_ENTITY_TYPE model = this.getOrCreateAndSetProperties(entityClass, dynamicAttributeRegistry, fieldValueMap);
        this.save(model);
        return model;
    }

    public SUPER_ENTITY_TYPE get(DataFetchingEnvironment environment) {
        Map<String, Object> fieldValueMap;
        Field mutationField = environment.getField();
        String entityName = this.getEntityName(this.getConfig().getMutationSavePrefix(), mutationField.getName());
        Value dataValue = mutationField.getArguments().stream().filter(argument -> this.getConfig().getMutationAttributeInputDataName().equals(argument.getName())).findFirst().get().getValue();
        Map<String, Object> arguments = this.getArgumentsForContext(environment.getArguments(), this.getConfig().getMutationAttributeInputDataName());
        if (dataValue instanceof ObjectValue) {
            fieldValueMap = this.convertObjectValue((ObjectValue)dataValue, arguments);
        } else if (dataValue instanceof VariableReference) {
            fieldValueMap = arguments;
        } else {
            throw new GQLException(Message.format("Unsupported save data type : [{}]", dataValue.getClass().getName()));
        }
        return this.save(this.getEntityClassByEntityName(entityName), this.dynamicAttributeRegistry, fieldValueMap);
    }

    public GQLDynamicAttributeRegistry getDynamicAttributeRegistry() {
        return this.dynamicAttributeRegistry;
    }

    public void setDynamicAttributeRegistry(GQLDynamicAttributeRegistry dynamicAttributeRegistry) {
        this.dynamicAttributeRegistry = dynamicAttributeRegistry;
    }
}

