/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.execution;

import com.daikit.graphql.builder.GQLExecutionContext;
import com.daikit.graphql.builder.GQLSchemaBuilder;
import com.daikit.graphql.config.GQLSchemaConfig;
import com.daikit.graphql.data.output.GQLDeleteResult;
import com.daikit.graphql.data.output.GQLExecutionResult;
import com.daikit.graphql.data.output.GQLListLoadResult;
import com.daikit.graphql.datafetcher.GQLPropertyDataFetcher;
import com.daikit.graphql.exception.GQLException;
import com.daikit.graphql.execution.IGQLErrorProcessor;
import com.daikit.graphql.execution.IGQLExecutorCallback;
import com.daikit.graphql.meta.GQLInternalMetaModel;
import com.daikit.graphql.meta.GQLMetaModel;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class GQLExecutor {
    private final GQLInternalMetaModel metaModel;
    private final Map<GQLExecutionContext, GraphQLSchema> schemaMap = new HashMap<GQLExecutionContext, GraphQLSchema>();
    private final Map<GQLExecutionContext, GraphQL> graphqlMap = new HashMap<GQLExecutionContext, GraphQL>();
    private final IGQLErrorProcessor errorProcessor;
    private final IGQLExecutorCallback callback;

    public GQLExecutor(GQLSchemaConfig schemaConfig, GQLMetaModel metaModel, IGQLErrorProcessor errorProcessor, DataFetcher<?> getByIdDataFetcher, DataFetcher<GQLListLoadResult> listDataFetcher, DataFetcher<?> saveDataFetcher, DataFetcher<GQLDeleteResult> deleteDataFetcher, DataFetcher<?> customMethodDataFetcher, List<GQLPropertyDataFetcher<?>> propertyDataFetchers, List<GQLExecutionContext> allPossibleExecutionContexts) {
        this(schemaConfig, metaModel, errorProcessor, null, getByIdDataFetcher, listDataFetcher, saveDataFetcher, deleteDataFetcher, customMethodDataFetcher, propertyDataFetchers, allPossibleExecutionContexts);
    }

    public GQLExecutor(GQLSchemaConfig schemaConfig, GQLMetaModel metaModel, IGQLErrorProcessor errorProcessor, IGQLExecutorCallback callback, DataFetcher<?> getByIdDataFetcher, DataFetcher<GQLListLoadResult> listDataFetcher, DataFetcher<?> saveDataFetcher, DataFetcher<GQLDeleteResult> deleteDataFetcher, DataFetcher<?> customMethodDataFetcher, List<GQLPropertyDataFetcher<?>> propertyDataFetchers, List<GQLExecutionContext> allPossibleExecutionContexts) {
        this.errorProcessor = errorProcessor;
        this.callback = callback;
        this.metaModel = new GQLInternalMetaModel(schemaConfig, metaModel);
        ArrayList<GQLExecutionContext> executionContexts = new ArrayList<GQLExecutionContext>();
        if (allPossibleExecutionContexts == null || allPossibleExecutionContexts.isEmpty()) {
            executionContexts.add(GQLExecutionContext.DEFAULT);
        } else {
            executionContexts.addAll(allPossibleExecutionContexts);
        }
        executionContexts.forEach(context -> {
            GraphQLSchema schema = new GQLSchemaBuilder().build((GQLExecutionContext)context, schemaConfig, this.metaModel, getByIdDataFetcher, listDataFetcher, saveDataFetcher, deleteDataFetcher, customMethodDataFetcher, propertyDataFetchers);
            this.schemaMap.put((GQLExecutionContext)context, schema);
            this.graphqlMap.put((GQLExecutionContext)context, GraphQL.newGraphQL((GraphQLSchema)schema).build());
        });
    }

    public GQLExecutionResult execute(String requestString) {
        return this.execute(GQLExecutionContext.DEFAULT, requestString);
    }

    public GQLExecutionResult execute(String requestString, String operationName, Object rootContext, Map<String, Object> arguments) {
        return this.execute(GQLExecutionContext.DEFAULT, requestString, operationName, rootContext, arguments);
    }

    public GQLExecutionResult execute(ExecutionInput executionInput) {
        return this.execute(GQLExecutionContext.DEFAULT, executionInput);
    }

    public GQLExecutionResult execute(GQLExecutionContext executionContext, String requestString) {
        return this.execute(ExecutionInput.newExecutionInput().query(requestString).build());
    }

    public GQLExecutionResult execute(GQLExecutionContext executionContext, String requestString, String operationName, Object rootContext, Map<String, Object> arguments) {
        return this.execute(ExecutionInput.newExecutionInput().query(requestString).operationName(operationName).context(rootContext).root(rootContext).variables(arguments).build());
    }

    public GQLExecutionResult execute(GQLExecutionContext executionContext, ExecutionInput executionInput) {
        if (this.callback != null) {
            this.callback.onBeforeExecute(executionContext, executionInput);
        }
        GQLExecutionResult executionResult = this.wrapResult(this.getGraphql(executionContext).orElseThrow(() -> new GQLException("No schema registered for given context " + executionContext + ". Schemas should be precomputed for each possible context for better performances.")).execute(executionInput));
        if (this.callback != null) {
            this.callback.onAfterExecute(executionContext, executionInput, executionResult);
        }
        return executionResult;
    }

    protected GQLExecutionResult wrapResult(ExecutionResult executionResult) {
        return new GQLExecutionResult(executionResult, this.errorProcessor.handleError(executionResult.getErrors()));
    }

    public Optional<GraphQLSchema> getSchema(GQLExecutionContext executionContext) {
        return Optional.ofNullable(this.schemaMap.get(executionContext));
    }

    public Optional<GraphQL> getGraphql(GQLExecutionContext executionContext) {
        return Optional.ofNullable(this.graphqlMap.get(executionContext));
    }

    public GraphQLSchema getSchema() {
        return this.getSchema(GQLExecutionContext.DEFAULT).get();
    }

    public GraphQL getGraphql() {
        return this.getGraphql(GQLExecutionContext.DEFAULT).get();
    }

    public IGQLErrorProcessor getErrorProcessor() {
        return this.errorProcessor;
    }

    public GQLInternalMetaModel getMetaModel() {
        return this.metaModel;
    }
}

