/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.meta;

import com.daikit.graphql.config.GQLSchemaConfig;
import com.daikit.graphql.custommethod.GQLCustomMethod;
import com.daikit.graphql.dynamicattribute.IGQLAbstractDynamicAttribute;
import com.daikit.graphql.dynamicattribute.IGQLDynamicAttributeGetter;
import com.daikit.graphql.dynamicattribute.IGQLDynamicAttributeSetter;
import com.daikit.graphql.exception.GQLException;
import com.daikit.graphql.meta.GQLEnumsAndEmbeddedEntities;
import com.daikit.graphql.meta.GQLEnumsAndEmbeddedEntitiesCollector;
import com.daikit.graphql.meta.GQLMetaModel;
import com.daikit.graphql.meta.attribute.GQLAbstractAttributeMetaData;
import com.daikit.graphql.meta.builder.GQLControllerMethodCollector;
import com.daikit.graphql.meta.builder.GQLDynamicAttributeMetaDataBuilder;
import com.daikit.graphql.meta.builder.GQLEntityMetaDataBuilder;
import com.daikit.graphql.meta.builder.GQLEnumMetaDataBuilder;
import com.daikit.graphql.meta.builder.GQLMethodMetaDataBuilder;
import com.daikit.graphql.meta.custommethod.GQLAbstractMethodMetaData;
import com.daikit.graphql.meta.entity.GQLEntityMetaData;
import com.daikit.graphql.meta.entity.GQLEnumMetaData;
import com.daikit.graphql.meta.internal.GQLAbstractEntityMetaDataInfos;
import com.daikit.graphql.meta.internal.GQLConcreteEntityMetaDataInfos;
import com.daikit.graphql.meta.internal.GQLInterfaceEntityMetaDataInfos;
import com.daikit.graphql.utils.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GQLInternalMetaModel {
    private final List<GQLEnumMetaData> enumMetaDatas = new ArrayList<GQLEnumMetaData>();
    private final List<GQLEntityMetaData> entityMetaDatas = new ArrayList<GQLEntityMetaData>();
    private final List<GQLAbstractMethodMetaData> methodMetaDatas = new ArrayList<GQLAbstractMethodMetaData>();
    private final List<GQLInterfaceEntityMetaDataInfos> interfaceMetaDatas = new ArrayList<GQLInterfaceEntityMetaDataInfos>();
    private final List<GQLConcreteEntityMetaDataInfos> concreteMetaDatas = new ArrayList<GQLConcreteEntityMetaDataInfos>();

    public GQLInternalMetaModel(GQLSchemaConfig schemaConfig, GQLMetaModel inputMetaModel) {
        this.enumMetaDatas.addAll(inputMetaModel.getEnumMetaDatas());
        this.entityMetaDatas.addAll(inputMetaModel.getEntityMetaDatas());
        List<GQLCustomMethod> customMethods = new GQLControllerMethodCollector().collect(inputMetaModel.getControllers());
        if (!inputMetaModel.getEntityClasses().isEmpty()) {
            GQLEnumsAndEmbeddedEntities collected = new GQLEnumsAndEmbeddedEntitiesCollector(schemaConfig).collect(inputMetaModel.getEntityClasses(), inputMetaModel.getAvailableEmbeddedEntityClasses(), inputMetaModel.getDynamicAttributes(), customMethods);
            GQLEnumMetaDataBuilder enumMetaDataBuilder = new GQLEnumMetaDataBuilder(schemaConfig);
            this.enumMetaDatas.addAll(collected.getEnums().stream().map(enumClass -> enumMetaDataBuilder.build((Class<? extends Enum<?>>)enumClass)).collect(Collectors.toList()));
            GQLEntityMetaDataBuilder entityMetaDataBuilder = new GQLEntityMetaDataBuilder(schemaConfig, inputMetaModel.getEntityClasses(), collected.getEntities(), collected.getEnums());
            this.entityMetaDatas.addAll(inputMetaModel.getEntityClasses().stream().map(entityClass -> entityMetaDataBuilder.build((Class<?>)entityClass, false)).collect(Collectors.toList()));
            this.entityMetaDatas.addAll(collected.getEntities().stream().map(entityClass -> entityMetaDataBuilder.build((Class<?>)entityClass, true)).collect(Collectors.toList()));
        }
        GQLDynamicAttributeMetaDataBuilder dynamicAttributeMetaDataBuilder = new GQLDynamicAttributeMetaDataBuilder(schemaConfig);
        GQLMethodMetaDataBuilder methodMetaDataBuilder = new GQLMethodMetaDataBuilder(schemaConfig);
        Collection dynamicAttributeMetaDatas = inputMetaModel.getDynamicAttributes().stream().map(attribute -> dynamicAttributeMetaDataBuilder.build((Collection<GQLEnumMetaData>)this.enumMetaDatas, (Collection<GQLEntityMetaData>)this.entityMetaDatas, (IGQLAbstractDynamicAttribute<?>)attribute)).filter(Objects::nonNull).collect(Collectors.toList());
        Collection methodMetaDatas = customMethods.stream().map(customMethod -> methodMetaDataBuilder.build((Collection<GQLEnumMetaData>)this.enumMetaDatas, (Collection<GQLEntityMetaData>)this.entityMetaDatas, (GQLCustomMethod)customMethod)).collect(Collectors.toList());
        this.registerDynamicAttributes(this.entityMetaDatas, dynamicAttributeMetaDatas);
        Comparator<GQLEnumMetaData> enumComparator = new Comparator<GQLEnumMetaData>(){

            @Override
            public int compare(GQLEnumMetaData o1, GQLEnumMetaData o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        Comparator<GQLAbstractEntityMetaDataInfos> infosComparator = new Comparator<GQLAbstractEntityMetaDataInfos>(){

            @Override
            public int compare(GQLAbstractEntityMetaDataInfos o1, GQLAbstractEntityMetaDataInfos o2) {
                return o1.getEntity().getName().compareTo(o2.getEntity().getName());
            }
        };
        this.getEnums().addAll(this.enumMetaDatas);
        Collections.sort(this.getEnums(), enumComparator);
        for (GQLEntityMetaData entityMetaData : this.entityMetaDatas) {
            GQLAbstractEntityMetaDataInfos infos2;
            if (entityMetaData.isConcrete()) {
                infos2 = new GQLConcreteEntityMetaDataInfos(entityMetaData);
                this.getAllConcretes().add((GQLConcreteEntityMetaDataInfos)infos2);
                continue;
            }
            infos2 = new GQLInterfaceEntityMetaDataInfos(entityMetaData);
            this.getAllInterfaces().add((GQLInterfaceEntityMetaDataInfos)infos2);
        }
        Collections.sort(this.getAllConcretes(), infosComparator);
        Collections.sort(this.getAllInterfaces(), infosComparator);
        this.getAllEntities().forEach(infosToUpdate -> infosToUpdate.setSuperEntity(this.getAllEntities().stream().filter(infos -> infos.getEntity().getEntityClass().equals(infosToUpdate.getEntity().getSuperEntityClass())).findFirst().orElse(null)));
        this.getAllEntities().forEach(infos -> this.buildAndSetSuperInterfaces((Collection<GQLInterfaceEntityMetaDataInfos>)this.getAllInterfaces(), (GQLAbstractEntityMetaDataInfos)infos));
        this.getNonEmbeddedInterfaces().forEach(infos -> this.setConcreteSubEntities((Collection<GQLConcreteEntityMetaDataInfos>)this.getAllConcretes(), (GQLInterfaceEntityMetaDataInfos)infos));
        this.getEmbeddedInterfaces().forEach(infos -> this.setConcreteSubEntities((Collection<GQLConcreteEntityMetaDataInfos>)this.getAllConcretes(), (GQLInterfaceEntityMetaDataInfos)infos));
        this.getCustomMethods().addAll(methodMetaDatas);
    }

    private void registerDynamicAttributes(Collection<GQLEntityMetaData> entityMetaDatas, Collection<GQLAbstractAttributeMetaData> dynamicAttributes) {
        for (GQLAbstractAttributeMetaData dynamicAttribute : dynamicAttributes) {
            Class<?> entityType = dynamicAttribute.isDynamicAttributeGetter() ? dynamicAttribute.getDynamicAttributeGetter().getEntityType() : dynamicAttribute.getDynamicAttributeSetter().getEntityType();
            Optional<GQLEntityMetaData> entityMetaData = entityMetaDatas.stream().filter(metaData -> metaData.getEntityClass().equals(entityType)).findFirst();
            if (!entityMetaData.isPresent()) {
                throw new GQLException(Message.format("No entity meta data registered for dynamic attribute [{}] entity class [{}]", dynamicAttribute.getName(), entityType.getSimpleName()));
            }
            entityMetaData.get().addAttribute(dynamicAttribute);
        }
    }

    private void buildAndSetSuperInterfaces(Collection<GQLInterfaceEntityMetaDataInfos> allInterfaces, GQLAbstractEntityMetaDataInfos infos) {
        this.getSuperInterfaceInfos(allInterfaces, infos).ifPresent(superInterface -> this.setSuperInterfaceInfos(allInterfaces, (GQLAbstractEntityMetaDataInfos)superInterface, infos));
    }

    private Optional<GQLInterfaceEntityMetaDataInfos> getSuperInterfaceInfos(Collection<GQLInterfaceEntityMetaDataInfos> allInterfaces, GQLAbstractEntityMetaDataInfos infos) {
        return allInterfaces.stream().filter(potential -> potential.equals(infos.getSuperEntity())).findFirst();
    }

    private void setSuperInterfaceInfos(Collection<GQLInterfaceEntityMetaDataInfos> allInterfaces, GQLAbstractEntityMetaDataInfos superInterfaceInfos, GQLAbstractEntityMetaDataInfos infos) {
        infos.getSuperInterfaces().add(superInterfaceInfos);
        this.getSuperInterfaceInfos(allInterfaces, superInterfaceInfos).ifPresent(superSuperInterfaceInfos -> this.setSuperInterfaceInfos(allInterfaces, (GQLAbstractEntityMetaDataInfos)superSuperInterfaceInfos, infos));
    }

    private void setConcreteSubEntities(Collection<GQLConcreteEntityMetaDataInfos> concretes, GQLInterfaceEntityMetaDataInfos infos) {
        infos.getConcreteSubEntities().addAll(concretes.stream().filter(concrete -> concrete.getSuperInterfaces().contains(infos)).collect(Collectors.toList()));
    }

    public <ENTITY_CLASS> Class<? extends ENTITY_CLASS> getEntityClassByEntityName(String entityName) {
        Optional<GQLAbstractEntityMetaDataInfos> entityMetaDataOptional = this.getAllEntities().stream().filter(metaDataInfos -> metaDataInfos.getEntity().getName().equals(entityName)).findFirst();
        if (!entityMetaDataOptional.isPresent()) {
            throw new GQLException(Message.format("Not entity exists for name [{}]", entityName));
        }
        return entityMetaDataOptional.get().getEntity().getEntityClass();
    }

    public List<IGQLDynamicAttributeSetter<?, ?>> getDynamicAttributeSetters() {
        return this.concreteMetaDatas.stream().flatMap(entityMetaData -> entityMetaData.getEntity().getAttributes().stream().filter(attribute -> attribute.isDynamicAttributeSetter()).map(attribute -> attribute.getDynamicAttributeSetter())).collect(Collectors.toList());
    }

    public List<IGQLDynamicAttributeGetter<?, ?>> getDynamicAttributeGetters() {
        return this.concreteMetaDatas.stream().flatMap(entityMetaData -> entityMetaData.getEntity().getAttributes().stream().filter(attribute -> attribute.isDynamicAttributeGetter()).map(attribute -> attribute.getDynamicAttributeGetter())).collect(Collectors.toList());
    }

    public List<GQLEnumMetaData> getEnums() {
        return this.enumMetaDatas;
    }

    public List<GQLInterfaceEntityMetaDataInfos> getNonEmbeddedInterfaces() {
        return this.interfaceMetaDatas.stream().filter(infos -> !infos.getEntity().isEmbedded()).collect(Collectors.toList());
    }

    public List<GQLConcreteEntityMetaDataInfos> getNonEmbeddedConcretes() {
        return this.concreteMetaDatas.stream().filter(infos -> !infos.getEntity().isEmbedded()).collect(Collectors.toList());
    }

    public List<GQLInterfaceEntityMetaDataInfos> getEmbeddedInterfaces() {
        return this.interfaceMetaDatas.stream().filter(infos -> infos.getEntity().isEmbedded()).collect(Collectors.toList());
    }

    public List<GQLConcreteEntityMetaDataInfos> getEmbeddedConcretes() {
        return this.concreteMetaDatas.stream().filter(infos -> infos.getEntity().isEmbedded()).collect(Collectors.toList());
    }

    public List<GQLAbstractEntityMetaDataInfos> getAllEntities() {
        return Stream.concat(this.interfaceMetaDatas.stream(), this.concreteMetaDatas.stream()).collect(Collectors.toList());
    }

    public List<GQLAbstractEntityMetaDataInfos> getAllEmbeddedEntities() {
        return Stream.concat(this.getEmbeddedInterfaces().stream(), this.getEmbeddedConcretes().stream()).collect(Collectors.toList());
    }

    public List<GQLAbstractEntityMetaDataInfos> getAllNonEmbeddedEntities() {
        return Stream.concat(this.getNonEmbeddedInterfaces().stream(), this.getNonEmbeddedConcretes().stream()).collect(Collectors.toList());
    }

    public List<GQLInterfaceEntityMetaDataInfos> getAllInterfaces() {
        return this.interfaceMetaDatas;
    }

    public List<GQLConcreteEntityMetaDataInfos> getAllConcretes() {
        return this.concreteMetaDatas;
    }

    public List<GQLAbstractMethodMetaData> getCustomMethods() {
        return this.methodMetaDatas;
    }
}

