/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.meta.attribute;

import com.daikit.graphql.builder.GQLExecutionContext;
import com.daikit.graphql.dynamicattribute.IGQLDynamicAttributeGetter;
import com.daikit.graphql.dynamicattribute.IGQLDynamicAttributeSetter;
import com.daikit.graphql.exception.GQLException;
import com.daikit.graphql.meta.GQLAbstractMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeRightsMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class GQLAbstractAttributeMetaData
extends GQLAbstractMetaData {
    private String name;
    private String description;
    private boolean filterable = true;
    private List<GQLAttributeRightsMetaData> rights = new ArrayList<GQLAttributeRightsMetaData>();
    private IGQLDynamicAttributeGetter<?, ?> dynamicAttributeGetter;
    private IGQLDynamicAttributeSetter<?, ?> dynamicAttributeSetter;
    private final GQLAttributeRightsMetaData DEFAULT_RIGHTS = new GQLAttributeRightsMetaData();

    public GQLAbstractAttributeMetaData() {
    }

    public GQLAbstractAttributeMetaData(String name) {
        this.name = name;
    }

    @Override
    protected void appendToString(StringBuilder stringBuilder) {
        stringBuilder.append(this.name).append(this.filterable ? "[FILT]" : "").append(this.isDynamic() ? "[DYN]" : "");
    }

    public boolean isSaveable(GQLExecutionContext executionContext) {
        return this.checkRights(executionContext, rights -> rights.isSaveable());
    }

    public boolean isReadable(GQLExecutionContext executionContext) {
        return this.checkRights(executionContext, rights -> rights.isReadable());
    }

    public boolean isNullableForCreate(GQLExecutionContext executionContext) {
        return this.checkRights(executionContext, rights -> rights.isNullableForCreate());
    }

    public boolean isNullableForUpdate(GQLExecutionContext executionContext) {
        return this.checkRights(executionContext, rights -> rights.isNullableForUpdate());
    }

    public boolean isMandatoryForCreate(GQLExecutionContext executionContext) {
        return this.checkRights(executionContext, rights -> rights.isMandatoryForCreate());
    }

    public boolean isMandatoryForUpdate(GQLExecutionContext executionContext) {
        return this.checkRights(executionContext, rights -> rights.isMandatoryForUpdate());
    }

    public boolean isDynamic() {
        return this.dynamicAttributeGetter != null || this.dynamicAttributeSetter != null;
    }

    public boolean isDynamicAttributeSetter() {
        return this.dynamicAttributeSetter != null;
    }

    public boolean isDynamicAttributeGetter() {
        return this.dynamicAttributeGetter != null;
    }

    public GQLAbstractAttributeMetaData addRights(GQLAttributeRightsMetaData ... rightsArray) {
        Stream.of(rightsArray).forEach(rights -> {
            this.getRights().stream().filter(r -> Objects.equals(r.getRole(), rights.getRole())).findFirst().ifPresent(r -> {
                throw new GQLException("Several rights configured for same role [" + r.getRole() + "] within attribute [" + this + "]");
            });
            if (rights.getRole() == null) {
                this.getRights().add(0, (GQLAttributeRightsMetaData)rights);
            } else {
                this.getRights().add((GQLAttributeRightsMetaData)rights);
            }
        });
        return this;
    }

    private Stream<GQLAttributeRightsMetaData> getRights(List<?> roles) {
        return this.getRights().stream().filter(rights -> rights.getRole() == null || roles.contains(rights.getRole()));
    }

    private boolean checkRights(GQLExecutionContext executionContext, Predicate<GQLAttributeRightsMetaData> predicate) {
        return this.getRights().isEmpty() ? predicate.test(this.DEFAULT_RIGHTS) : (GQLExecutionContext.GQLRolesJunctionEnum.AND.equals((Object)executionContext.getRolesJunction()) ? this.getRights(executionContext.getRoles()).allMatch(predicate) : this.getRights(executionContext.getRoles()).anyMatch(predicate));
    }

    public List<GQLAttributeRightsMetaData> getRights() {
        return this.rights;
    }

    public void setRights(List<GQLAttributeRightsMetaData> rights) {
        this.rights = rights;
    }

    public String getDescription() {
        return this.description;
    }

    public GQLAbstractAttributeMetaData setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public GQLAbstractAttributeMetaData setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isFilterable() {
        return this.filterable;
    }

    public GQLAbstractAttributeMetaData setFilterable(boolean filterable) {
        this.filterable = filterable;
        return this;
    }

    public IGQLDynamicAttributeGetter<?, ?> getDynamicAttributeGetter() {
        return this.dynamicAttributeGetter;
    }

    public GQLAbstractAttributeMetaData setDynamicAttributeGetter(IGQLDynamicAttributeGetter<?, ?> dynamicAttributeGetter) {
        this.dynamicAttributeGetter = dynamicAttributeGetter;
        return this;
    }

    public IGQLDynamicAttributeSetter<?, ?> getDynamicAttributeSetter() {
        return this.dynamicAttributeSetter;
    }

    public GQLAbstractAttributeMetaData setDynamicAttributeSetter(IGQLDynamicAttributeSetter<?, ?> dynamicAttributeSetter) {
        this.dynamicAttributeSetter = dynamicAttributeSetter;
        return this;
    }
}

