/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.meta.builder;

import com.daikit.graphql.config.GQLSchemaConfig;
import com.daikit.graphql.meta.GQLAttribute;
import com.daikit.graphql.meta.GQLAttributeRights;
import com.daikit.graphql.meta.attribute.GQLAbstractAttributeMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeRightsMetaData;
import com.daikit.graphql.meta.builder.GQLAbstractMetaDataBuilder;
import java.util.stream.Stream;

public class GQLAbstractAttributeMetaDataBuilder
extends GQLAbstractMetaDataBuilder {
    public GQLAbstractAttributeMetaDataBuilder(GQLSchemaConfig schemaConfig) {
        super(schemaConfig);
    }

    protected void populateAttributeRights(GQLAbstractAttributeMetaData attributeMetaData, GQLAttribute annotation) {
        this.populateAttributeRights(attributeMetaData, annotation, true, true);
    }

    protected void populateAttributeRights(GQLAbstractAttributeMetaData attributeMetaData, GQLAttribute annotation, boolean defaultReadable, boolean defaultSaveable) {
        if (annotation == null || annotation.rights() == null || annotation.rights().length == 0) {
            GQLAttributeRightsMetaData rights = new GQLAttributeRightsMetaData();
            rights.setSaveable(defaultSaveable);
            rights.setReadable(defaultReadable);
            rights.setNullable(true);
            rights.setMandatory(false);
            attributeMetaData.getRights().add(rights);
        } else {
            Stream.of(annotation.rights()).forEach(ann -> {
                if (ann.roles() == null || ann.roles().length == 0) {
                    this.addRights(attributeMetaData, (GQLAttributeRights)ann, null);
                } else {
                    Stream.of(ann.roles()).forEach(role -> this.addRights(attributeMetaData, (GQLAttributeRights)ann, role));
                }
            });
        }
    }

    private void addRights(GQLAbstractAttributeMetaData attributeMetaData, GQLAttributeRights ann, Object role) {
        GQLAttributeRightsMetaData rights = new GQLAttributeRightsMetaData();
        rights.setRole(role);
        rights.setSaveable(!ann.exclude() && !ann.readOnly() && ann.save());
        rights.setReadable(!ann.exclude() && ann.readOnly() || ann.read());
        rights.setNullableForCreate(ann.nullableForCreate() && ann.nullable());
        rights.setNullableForUpdate(ann.nullableForUpdate() && ann.nullable());
        rights.setMandatoryForCreate(ann.mandatoryForCreate() || ann.mandatory());
        rights.setMandatoryForUpdate(ann.mandatoryForUpdate() || ann.mandatory());
        attributeMetaData.addRights(rights);
    }
}

