/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.meta.builder;

import com.daikit.graphql.config.GQLSchemaConfig;
import com.daikit.graphql.meta.GQLEntity;
import com.daikit.graphql.meta.GQLEntityRights;
import com.daikit.graphql.meta.builder.GQLAbstractMetaDataBuilder;
import com.daikit.graphql.meta.builder.GQLAttributeMetaDataBuilder;
import com.daikit.graphql.meta.entity.GQLEntityMetaData;
import com.daikit.graphql.meta.entity.GQLEntityRightsMetaData;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class GQLEntityMetaDataBuilder
extends GQLAbstractMetaDataBuilder {
    private final Collection<Class<?>> allEntityClasses;
    private final GQLAttributeMetaDataBuilder attributeBuilder;

    public GQLEntityMetaDataBuilder(GQLSchemaConfig schemaConfig, Collection<Class<?>> allEntityClasses, Collection<Class<?>> allDataClasses, Collection<Class<? extends Enum<?>>> allEnumClasses) {
        super(schemaConfig);
        this.allEntityClasses = allEntityClasses;
        this.attributeBuilder = new GQLAttributeMetaDataBuilder(schemaConfig, allEntityClasses, allDataClasses, allEnumClasses);
    }

    public GQLEntityMetaData build(Class<?> entityClass, boolean embedded) {
        GQLEntity annotation = entityClass.getAnnotation(GQLEntity.class);
        GQLEntityMetaData gqlEntity = null;
        if (annotation == null || !annotation.exclude()) {
            gqlEntity = new GQLEntityMetaData();
            gqlEntity.setConcrete(!Modifier.isAbstract(entityClass.getModifiers()));
            gqlEntity.setEntityClass(entityClass);
            gqlEntity.setEmbedded(embedded);
            gqlEntity.setName(annotation == null || StringUtils.isEmpty((CharSequence)annotation.name()) ? entityClass.getSimpleName() : annotation.name());
            gqlEntity.setDescription(annotation == null ? null : annotation.description());
            this.setEntityRights(gqlEntity, annotation);
            if (this.allEntityClasses.contains(entityClass.getSuperclass())) {
                gqlEntity.setSuperEntityClass(entityClass.getSuperclass());
            }
            gqlEntity.getAttributes().addAll(FieldUtils.getAllFieldsList(entityClass).stream().map(field -> this.attributeBuilder.buildAttribute(entityClass, (Field)field)).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return gqlEntity;
    }

    private void setEntityRights(GQLEntityMetaData entityMetaData, GQLEntity annotation) {
        if (annotation == null || annotation.rights() == null || annotation.rights().length == 0) {
            GQLEntityRightsMetaData rights = new GQLEntityRightsMetaData();
            rights.setSaveable(true);
            rights.setReadable(true);
            rights.setDeletable(true);
            entityMetaData.getRights().add(rights);
        } else {
            Stream.of(annotation.rights()).forEach(ann -> {
                if (ann.roles() == null || ann.roles().length == 0) {
                    this.addRights(entityMetaData, (GQLEntityRights)ann, null);
                } else {
                    Stream.of(ann.roles()).forEach(role -> this.addRights(entityMetaData, (GQLEntityRights)ann, role));
                }
            });
        }
    }

    private void addRights(GQLEntityMetaData entityMetaData, GQLEntityRights ann, Object role) {
        GQLEntityRightsMetaData rights = new GQLEntityRightsMetaData();
        rights.setRole(role);
        rights.setSaveable(!ann.exclude() && !ann.readOnly() && ann.save());
        rights.setReadable(!ann.exclude() && ann.readOnly() || ann.read());
        rights.setDeletable(!ann.exclude() && !ann.readOnly() && ann.delete());
        entityMetaData.addRights(rights);
    }
}

