/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.meta.builder;

import com.daikit.generics.utils.GenericsUtils;
import com.daikit.graphql.config.GQLSchemaConfig;
import com.daikit.graphql.custommethod.GQLCustomMethod;
import com.daikit.graphql.custommethod.GQLCustomMethodArg;
import com.daikit.graphql.meta.builder.GQLAbstractMetaDataBuilder;
import com.daikit.graphql.meta.custommethod.GQLAbstractMethodArgumentMetaData;
import com.daikit.graphql.meta.custommethod.GQLAbstractMethodMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodArgumentEntityMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodArgumentEnumMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodArgumentListEntityMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodArgumentListEnumMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodArgumentListScalarMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodArgumentScalarMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodEntityMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodEnumMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodListEntityMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodListEnumMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodListScalarMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodScalarMetaData;
import com.daikit.graphql.meta.entity.GQLEntityMetaData;
import com.daikit.graphql.meta.entity.GQLEnumMetaData;
import com.daikit.graphql.utils.Message;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GQLMethodMetaDataBuilder
extends GQLAbstractMetaDataBuilder {
    public GQLMethodMetaDataBuilder(GQLSchemaConfig schemaConfig) {
        super(schemaConfig);
    }

    public GQLAbstractMethodMetaData build(Collection<GQLEnumMetaData> enumMetaDatas, Collection<GQLEntityMetaData> entityMetaDatas, GQLCustomMethod customMethod) {
        ArrayList<GQLAbstractMethodArgumentMetaData> arguments = new ArrayList<GQLAbstractMethodArgumentMetaData>();
        for (GQLCustomMethodArg arg : customMethod.getArgs()) {
            arguments.add(this.createMethodArgument(enumMetaDatas, entityMetaDatas, customMethod, arg.getName(), arg.getType()));
        }
        return this.createMethod(enumMetaDatas, entityMetaDatas, customMethod, arguments);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GQLAbstractMethodMetaData createMethod(Collection<GQLEnumMetaData> enumMetaDatas, Collection<GQLEntityMetaData> entityMetaDatas, GQLCustomMethod method, List<GQLAbstractMethodArgumentMetaData> arguments) {
        GQLAbstractMethodMetaData methodMetaData;
        Class outputRawClass = GenericsUtils.getTypeClass((Type)method.getOutputType());
        if (this.getConfig().isScalarType(outputRawClass)) {
            methodMetaData = new GQLMethodScalarMetaData();
            ((GQLMethodScalarMetaData)methodMetaData).setScalarType(this.getConfig().getScalarTypeCodeFromClass(outputRawClass).get());
        } else if (this.isByteArray(outputRawClass)) {
            methodMetaData = new GQLMethodScalarMetaData();
            ((GQLMethodScalarMetaData)methodMetaData).setScalarType(this.getConfig().getScalarTypeCodeFromClass(outputRawClass.getComponentType()).get());
        } else if (this.isEnum(enumMetaDatas, outputRawClass)) {
            methodMetaData = new GQLMethodEnumMetaData();
            ((GQLMethodEnumMetaData)methodMetaData).setEnumClass(outputRawClass);
        } else if (this.isEntity(entityMetaDatas, outputRawClass)) {
            methodMetaData = new GQLMethodEntityMetaData();
            ((GQLMethodEntityMetaData)methodMetaData).setEntityClass(outputRawClass);
        } else {
            if (!Collection.class.isAssignableFrom(outputRawClass)) throw new IllegalArgumentException(Message.format("Not handled method [{}] output type [{}].", method.getName(), outputRawClass.getSimpleName()));
            Class foreignClass = (Class)GenericsUtils.getTypeArgumentsAsClasses((Type)method.getOutputType(), Collection.class).get(0);
            if (this.getConfig().isScalarType(foreignClass)) {
                methodMetaData = new GQLMethodListScalarMetaData();
                ((GQLMethodListScalarMetaData)methodMetaData).setScalarType(this.getConfig().getScalarTypeCodeFromClass(foreignClass).get());
            } else if (this.isEnum(enumMetaDatas, foreignClass)) {
                methodMetaData = new GQLMethodListEnumMetaData();
                ((GQLMethodListEnumMetaData)methodMetaData).setEnumClass(foreignClass);
            } else {
                if (!this.isEntity(entityMetaDatas, foreignClass)) throw new IllegalArgumentException(Message.format("Not handled method [{}] output collection type [{}].", method.getName(), outputRawClass.getName()));
                methodMetaData = new GQLMethodListEntityMetaData();
                ((GQLMethodListEntityMetaData)methodMetaData).setForeignClass(foreignClass);
            }
        }
        methodMetaData.getArguments().addAll(arguments);
        methodMetaData.setMethod(method);
        return methodMetaData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GQLAbstractMethodArgumentMetaData createMethodArgument(Collection<GQLEnumMetaData> enumMetaDatas, Collection<GQLEntityMetaData> entityMetaDatas, GQLCustomMethod customMethod, String argumentName, Type argumentType) {
        GQLAbstractMethodArgumentMetaData argumentMetaData;
        Class argumentRawClass = GenericsUtils.getTypeClass((Type)argumentType);
        if (this.getConfig().isScalarType(argumentRawClass)) {
            argumentMetaData = new GQLMethodArgumentScalarMetaData();
            ((GQLMethodArgumentScalarMetaData)argumentMetaData).setScalarType(this.getConfig().getScalarTypeCodeFromClass(argumentRawClass).get());
        } else if (this.isByteArray(argumentRawClass)) {
            argumentMetaData = new GQLMethodArgumentScalarMetaData();
            ((GQLMethodArgumentScalarMetaData)argumentMetaData).setScalarType(this.getConfig().getScalarTypeCodeFromClass(argumentRawClass.getComponentType()).get());
        } else if (this.isEnum(enumMetaDatas, argumentRawClass)) {
            argumentMetaData = new GQLMethodArgumentEnumMetaData();
            ((GQLMethodArgumentEnumMetaData)argumentMetaData).setEnumClass(argumentRawClass);
        } else if (this.isEntity(entityMetaDatas, argumentRawClass)) {
            argumentMetaData = new GQLMethodArgumentEntityMetaData();
            ((GQLMethodArgumentEntityMetaData)argumentMetaData).setEntityClass(argumentRawClass);
        } else {
            if (!Collection.class.isAssignableFrom(argumentRawClass)) throw new IllegalArgumentException(Message.format("Not handled method [{}] argument [{}] type [{}].", customMethod.getName(), argumentName, argumentRawClass.getName()));
            Class foreignClass = (Class)GenericsUtils.getTypeArgumentsAsClasses((Type)argumentType, Collection.class).get(0);
            if (this.getConfig().isScalarType(foreignClass)) {
                argumentMetaData = new GQLMethodArgumentListScalarMetaData();
                ((GQLMethodArgumentListScalarMetaData)argumentMetaData).setScalarType(this.getConfig().getScalarTypeCodeFromClass(foreignClass).get());
            } else if (this.isEnum(enumMetaDatas, foreignClass)) {
                argumentMetaData = new GQLMethodArgumentListEnumMetaData();
                ((GQLMethodArgumentListEnumMetaData)argumentMetaData).setEnumClass(foreignClass);
            } else {
                if (!this.isEntity(entityMetaDatas, foreignClass)) throw new IllegalArgumentException(Message.format("Not handled method [{}] argument [{}] collection type [{}].", customMethod.getName(), argumentName, foreignClass.getName()));
                argumentMetaData = new GQLMethodArgumentListEntityMetaData();
                ((GQLMethodArgumentListEntityMetaData)argumentMetaData).setForeignClass(foreignClass);
            }
        }
        argumentMetaData.setName(argumentName);
        return argumentMetaData;
    }
}

