/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.builder;

import com.daikit.graphql.builder.GQLSchemaBuilderCache;
import com.daikit.graphql.builder.types.GQLEntityTypesBuilder;
import com.daikit.graphql.builder.types.GQLEnumTypesBuilder;
import com.daikit.graphql.builder.types.GQLInputEntityTypesBuilder;
import com.daikit.graphql.builder.types.GQLInterfaceTypesBuilder;
import com.daikit.graphql.builder.types.GQLMutationDeleteResultOutputTypeBuilder;
import com.daikit.graphql.builder.types.GQLMutationTypeBuilder;
import com.daikit.graphql.builder.types.GQLQueryFilterOperatorsInputTypeBuilder;
import com.daikit.graphql.builder.types.GQLQueryOrderByDirectionTypeBuilder;
import com.daikit.graphql.builder.types.GQLQueryOrderByInputTypeBuilder;
import com.daikit.graphql.builder.types.GQLQueryOrderByOutputTypeBuilder;
import com.daikit.graphql.builder.types.GQLQueryPagingInputTypeBuilder;
import com.daikit.graphql.builder.types.GQLQueryPagingOutputTypeBuilder;
import com.daikit.graphql.builder.types.GQLQueryTypeBuilder;
import com.daikit.graphql.builder.types.GQLReferencesBuilder;
import com.daikit.graphql.data.output.GQLDeleteResult;
import com.daikit.graphql.data.output.GQLListLoadResult;
import com.daikit.graphql.datafetcher.GQLAbstractSaveDataFetcher;
import com.daikit.graphql.datafetcher.GQLCustomMethodDataFetcher;
import com.daikit.graphql.datafetcher.GQLPropertyDataFetcher;
import com.daikit.graphql.meta.GQLMetaDataModel;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GQLSchemaBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private GQLSchemaBuilderCache cache = new GQLSchemaBuilderCache();

    public GQLSchemaBuilder setCache(GQLSchemaBuilderCache cache) {
        this.cache = cache;
        return this;
    }

    public GraphQLSchema buildSchema(GQLMetaDataModel metaDataModel, DataFetcher<?> getByIdDataFetcher, DataFetcher<GQLListLoadResult> listDataFetcher, DataFetcher<?> saveDataFetcher, DataFetcher<GQLDeleteResult> deleteDataFetcher, DataFetcher<?> customMethodsDataFetcher, List<GQLPropertyDataFetcher<?>> propertyDataFetchers) {
        List<GQLPropertyDataFetcher<?>> nullSafePropertyDataFetchers;
        this.logger.debug("START building schema...");
        GraphQLSchema.Builder builder = GraphQLSchema.newSchema();
        this.cache.setCodeRegistryBuilder(GraphQLCodeRegistry.newCodeRegistry());
        List<Object> list = nullSafePropertyDataFetchers = propertyDataFetchers == null ? Collections.emptyList() : propertyDataFetchers;
        if (customMethodsDataFetcher instanceof GQLCustomMethodDataFetcher) {
            this.logger.debug("START registering custom methods...");
            ((GQLCustomMethodDataFetcher)customMethodsDataFetcher).registerCustomMethods(metaDataModel.getCustomMethods().stream().map(method -> method.getMethod()).collect(Collectors.toList()));
            this.logger.debug("END registering custom methods");
        }
        if (saveDataFetcher instanceof GQLAbstractSaveDataFetcher) {
            this.logger.debug("START registering dynamic attribute setters...");
            ((GQLAbstractSaveDataFetcher)saveDataFetcher).registerDynamicAttributeSetters(metaDataModel.getDynamicAttributeSetters());
            this.logger.debug("END registering dynamic attribute setters");
        }
        this.logger.debug("START building output reference types...");
        new GQLReferencesBuilder(this.cache).buildTypeReferences(metaDataModel);
        new GQLEnumTypesBuilder(this.cache).buildEnumTypes(metaDataModel);
        new GQLInterfaceTypesBuilder(this.cache).buildInterfaceTypes(metaDataModel, nullSafePropertyDataFetchers);
        new GQLEntityTypesBuilder(this.cache).buildEntityTypes(metaDataModel, nullSafePropertyDataFetchers);
        this.logger.debug("END building output reference types");
        this.logger.debug("END building mutations utility types...");
        new GQLMutationDeleteResultOutputTypeBuilder(this.cache).buildDeleteResultOutputType();
        this.logger.debug("END building mutations utility types");
        this.logger.debug("END building queries utility types...");
        new GQLQueryPagingInputTypeBuilder(this.cache).buildPagingInputType();
        new GQLQueryPagingOutputTypeBuilder(this.cache).buildPagingOutputType();
        new GQLQueryOrderByDirectionTypeBuilder(this.cache).buildOrderByDirectionType();
        new GQLQueryOrderByInputTypeBuilder(this.cache).buildOrderByInputType();
        new GQLQueryOrderByOutputTypeBuilder(this.cache).buildOrderByOutputType();
        new GQLQueryFilterOperatorsInputTypeBuilder(this.cache).buildFilterOperatorsInputTypes(metaDataModel);
        this.logger.debug("END building queries utility types");
        this.logger.debug("START building mutation entities input types...");
        new GQLInputEntityTypesBuilder(this.cache).buildInputEntities(metaDataModel);
        this.logger.debug("END building mutation entities input types");
        this.logger.debug("START building queries...");
        builder.query(new GQLQueryTypeBuilder(this.cache).buildQueryType(metaDataModel, getByIdDataFetcher, listDataFetcher, customMethodsDataFetcher));
        this.logger.debug("END building queries");
        this.logger.debug("START building mutations...");
        builder.mutation(new GQLMutationTypeBuilder(this.cache).buildMutationType(metaDataModel, saveDataFetcher, deleteDataFetcher, customMethodsDataFetcher));
        this.logger.debug("END building mutations");
        builder.additionalTypes(this.getDictionnaryTypes(this.cache));
        this.logger.debug("Register code registry");
        builder.codeRegistry(this.cache.getCodeRegistryBuilder().build());
        GraphQLSchema schema = builder.build();
        this.logger.debug("END building schema");
        return schema;
    }

    private Set<GraphQLType> getDictionnaryTypes(GQLSchemaBuilderCache cache) {
        HashSet<GraphQLType> dictionnaryTypes = new HashSet<GraphQLType>();
        dictionnaryTypes.addAll(cache.getObjectTypes().values());
        dictionnaryTypes.addAll(cache.getInterfaceTypes().values());
        return dictionnaryTypes;
    }
}

