/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.builder.types;

import com.daikit.graphql.builder.GQLAbstractSchemaSubBuilder;
import com.daikit.graphql.builder.GQLBuilderUtils;
import com.daikit.graphql.builder.GQLSchemaBuilderCache;
import com.daikit.graphql.constants.GQLSchemaConstants;
import com.daikit.graphql.datafetcher.GQLDynamicAttributeDataFetcher;
import com.daikit.graphql.datafetcher.GQLPropertyDataFetcher;
import com.daikit.graphql.meta.attribute.GQLAbstractAttributeMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeEntityMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeEnumMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeListEntityMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeListEnumMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeListScalarMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeScalarMetaData;
import com.daikit.graphql.meta.entity.GQLEntityMetaData;
import com.daikit.graphql.utils.Message;
import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class GQLAbstractTypesBuilder
extends GQLAbstractSchemaSubBuilder {
    public GQLAbstractTypesBuilder(GQLSchemaBuilderCache cache) {
        super(cache);
    }

    protected Map<GQLAbstractAttributeMetaData, GraphQLFieldDefinition> buildEntityFieldDefinitions(GQLEntityMetaData entity) {
        this.logger.debug(Message.format("Build field definitions for entity/interface [{}]", entity.getName()));
        Map fieldDefinitions = entity.getAttributes().stream().filter(attribute -> attribute.isReadable()).collect(LinkedHashMap::new, (map, attribute) -> map.put(attribute, this.buildEntityFieldDefinition((GQLAbstractAttributeMetaData)attribute)), Map::putAll);
        return fieldDefinitions;
    }

    protected GraphQLFieldDefinition buildIdFieldDefinition() {
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
        builder.name("id");
        builder.description("Field [id]");
        builder.type((GraphQLOutputType)Scalars.GraphQLID);
        return builder.build();
    }

    protected void registerIdDataFetcher(GraphQLFieldsContainer fieldsContainer, GraphQLFieldDefinition idFieldDefinition, List<GQLPropertyDataFetcher<?>> propertiesDataFetchers) {
        Optional<GQLPropertyDataFetcher> dataFetcher;
        if (idFieldDefinition != null && (dataFetcher = propertiesDataFetchers.stream().filter(df -> "id".equals(df.getGraphQLPropertyName())).findFirst()).isPresent()) {
            this.getCache().getCodeRegistryBuilder().dataFetcher(fieldsContainer, idFieldDefinition, (DataFetcher)dataFetcher.get());
        }
    }

    protected void registerOtherDataFetchers(GraphQLFieldsContainer fieldsContainer, Map<GQLAbstractAttributeMetaData, GraphQLFieldDefinition> fieldDefinitions, List<GQLPropertyDataFetcher<?>> propertiesDataFetchers) {
        fieldDefinitions.entrySet().stream().forEach(entry -> {
            if (((GQLAbstractAttributeMetaData)entry.getKey()).isDynamic()) {
                if (((GQLAbstractAttributeMetaData)entry.getKey()).getDynamicAttributeGetter() != null) {
                    this.getCache().getCodeRegistryBuilder().dataFetcher(fieldsContainer, (GraphQLFieldDefinition)entry.getValue(), (DataFetcher)new GQLDynamicAttributeDataFetcher(((GQLAbstractAttributeMetaData)entry.getKey()).getName(), ((GQLAbstractAttributeMetaData)entry.getKey()).getDynamicAttributeGetter()));
                }
            } else {
                Optional<GQLPropertyDataFetcher> dataFetcher = propertiesDataFetchers.stream().filter(propertyDataFetcher -> Objects.equals(((GQLAbstractAttributeMetaData)entry.getKey()).getName(), propertyDataFetcher.getEntityPropertyName())).findFirst();
                if (dataFetcher.isPresent()) {
                    this.getCache().getCodeRegistryBuilder().dataFetcher(fieldsContainer, (GraphQLFieldDefinition)entry.getValue(), (DataFetcher)dataFetcher.get());
                }
            }
        });
    }

    private GraphQLFieldDefinition buildEntityFieldDefinition(GQLAbstractAttributeMetaData attribute) {
        this.logger.debug(Message.format("Build field definition for attribute [{}]", attribute.getName()));
        GraphQLFieldDefinition fieldDefinition = null;
        if (attribute instanceof GQLAttributeScalarMetaData) {
            fieldDefinition = this.buildFieldDefinition(attribute, (GraphQLOutputType)GQLSchemaConstants.SCALARS.get((Object)((GQLAttributeScalarMetaData)attribute).getScalarType()));
        } else if (attribute instanceof GQLAttributeEnumMetaData) {
            fieldDefinition = this.buildFieldDefinition(attribute, (GraphQLOutputType)this.getCache().getEnumType(((GQLAttributeEnumMetaData)attribute).getEnumClass()));
        } else if (attribute instanceof GQLAttributeEntityMetaData) {
            fieldDefinition = this.buildFieldDefinition(attribute, (GraphQLOutputType)new GraphQLTypeReference(this.getCache().getEntityTypeName(((GQLAttributeEntityMetaData)attribute).getEntityClass())));
        } else if (attribute instanceof GQLAttributeListEnumMetaData) {
            fieldDefinition = this.buildFieldDefinition(attribute, (GraphQLOutputType)new GraphQLList((GraphQLType)this.getCache().getEnumType(((GQLAttributeListEnumMetaData)attribute).getEnumClass())));
        } else if (attribute instanceof GQLAttributeListEntityMetaData) {
            fieldDefinition = this.buildFieldDefinition(attribute, (GraphQLOutputType)new GraphQLList((GraphQLType)new GraphQLTypeReference(this.getCache().getEntityTypeName(((GQLAttributeListEntityMetaData)attribute).getForeignClass()))));
        } else if (attribute instanceof GQLAttributeListScalarMetaData) {
            fieldDefinition = this.buildFieldDefinition(attribute, (GraphQLOutputType)new GraphQLList((GraphQLType)this.getCache().getScalarType(((GQLAttributeListScalarMetaData)attribute).getScalarType())));
        } else {
            throw new IllegalArgumentException(Message.format("Attribute could not be mapped to GraphQL [{}]", attribute));
        }
        return fieldDefinition;
    }

    private GraphQLFieldDefinition buildFieldDefinition(GQLAbstractAttributeMetaData attribute, GraphQLOutputType type) {
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
        builder.name(attribute.getName());
        builder.description("Field definition [" + attribute.getName() + "]");
        builder.type(type);
        this.logger.debug(Message.format("Field definition created for [{}] with type [{}]", attribute.getName(), GQLBuilderUtils.typeToString((GraphQLType)type)));
        return builder.build();
    }
}

