/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.builder.types;

import com.daikit.graphql.builder.GQLSchemaBuilderCache;
import com.daikit.graphql.builder.custommethod.GQLCustomMethodBuilder;
import com.daikit.graphql.builder.types.GQLAbstractInputOutputTypesBuilder;
import com.daikit.graphql.data.output.GQLDeleteResult;
import com.daikit.graphql.meta.GQLMetaDataModel;
import com.daikit.graphql.meta.custommethod.GQLAbstractMethodMetaData;
import com.daikit.graphql.meta.internal.GQLAbstractEntityMetaDataInfos;
import com.daikit.graphql.utils.Message;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GQLMutationTypeBuilder
extends GQLAbstractInputOutputTypesBuilder {
    public GQLMutationTypeBuilder(GQLSchemaBuilderCache cache) {
        super(cache);
    }

    public GraphQLObjectType buildMutationType(GQLMetaDataModel metaDataModel, DataFetcher<?> saveDataFetcher, DataFetcher<GQLDeleteResult> deleteDataFetcher, DataFetcher<?> customMethodsDataFetcher) {
        this.logger.debug("START building mutation types...");
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject();
        builder.name("MutationType");
        builder.description("Mutation type from meta model");
        this.logger.debug("Build mutation types for entities...");
        List<GraphQLFieldDefinition> saveFieldDefinitions = metaDataModel.getNonEmbeddedConcretes().stream().filter(infos -> infos.getEntity().isSaveable()).map(infos -> this.buildSaveMutationFieldDefinition((GQLAbstractEntityMetaDataInfos)infos)).collect(Collectors.toList());
        builder.fields(saveFieldDefinitions);
        List<GraphQLFieldDefinition> deleteFieldDefinitions = metaDataModel.getNonEmbeddedConcretes().stream().filter(infos -> infos.getEntity().isDeletable()).map(infos -> this.buildDeleteMutationFieldDefinition((GQLAbstractEntityMetaDataInfos)infos)).collect(Collectors.toList());
        builder.fields(deleteFieldDefinitions);
        this.logger.debug("Build mutation types for custom methods...");
        Map<GQLAbstractMethodMetaData, GraphQLFieldDefinition> customMethodFieldDefinitions = new GQLCustomMethodBuilder(this.getCache()).buildMethods(metaDataModel.getCustomMethods().stream().filter(GQLAbstractMethodMetaData::isMutation).collect(Collectors.toList()));
        builder.fields(new ArrayList<GraphQLFieldDefinition>(customMethodFieldDefinitions.values()));
        GraphQLObjectType mutationType = builder.build();
        saveFieldDefinitions.forEach(fieldDefinition -> this.getCache().getCodeRegistryBuilder().dataFetcher((GraphQLFieldsContainer)mutationType, fieldDefinition, saveDataFetcher));
        deleteFieldDefinitions.forEach(fieldDefinition -> this.getCache().getCodeRegistryBuilder().dataFetcher((GraphQLFieldsContainer)mutationType, fieldDefinition, deleteDataFetcher));
        customMethodFieldDefinitions.entrySet().forEach(entry -> this.getCache().getCodeRegistryBuilder().dataFetcher((GraphQLFieldsContainer)mutationType, (GraphQLFieldDefinition)entry.getValue(), customMethodsDataFetcher));
        this.logger.debug("END building mutation types");
        return mutationType;
    }

    private GraphQLFieldDefinition buildSaveMutationFieldDefinition(GQLAbstractEntityMetaDataInfos infos) {
        this.logger.debug(Message.format("Build save mutation for entity [{}]", infos.getEntity().getName()));
        GraphQLFieldDefinition.Builder builderSave = GraphQLFieldDefinition.newFieldDefinition();
        builderSave.name("save" + infos.getEntity().getName());
        builderSave.description("Entity save mutation for [" + infos.getEntity().getName() + "].");
        builderSave.type((GraphQLOutputType)this.getCache().getEntityType(infos.getEntity().getEntityClass()));
        builderSave.argument(this.buildSaveMutationArgument(infos));
        return builderSave.build();
    }

    private GraphQLArgument buildSaveMutationArgument(GQLAbstractEntityMetaDataInfos infos) {
        this.logger.debug(Message.format("Build save mutation argument for entity [{}]", infos.getEntity().getName()));
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
        builder.name("data");
        builder.description("Entity save mutation argument for [" + infos.getEntity().getName() + "]");
        builder.type((GraphQLInputType)new GraphQLNonNull((GraphQLType)this.getCache().getInputEntityType(infos.getEntity().getEntityClass())));
        return builder.build();
    }

    private GraphQLFieldDefinition buildDeleteMutationFieldDefinition(GQLAbstractEntityMetaDataInfos infos) {
        this.logger.debug(Message.format("Build delete mutation for entity [{}]", infos.getEntity().getName()));
        GraphQLFieldDefinition.Builder builderDelete = GraphQLFieldDefinition.newFieldDefinition();
        builderDelete.name("delete" + infos.getEntity().getName());
        builderDelete.description("Entity delete mutation for [" + infos.getEntity().getName() + "].");
        builderDelete.type(this.getCache().getDeleteResultOutputObjectType());
        builderDelete.argument(this.buildArgumentNonNull(this.getIdAttribute(infos)));
        return builderDelete.build();
    }
}

