/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.builder.types;

import com.daikit.graphql.builder.GQLBuilderUtils;
import com.daikit.graphql.builder.GQLSchemaBuilderCache;
import com.daikit.graphql.builder.custommethod.GQLCustomMethodBuilder;
import com.daikit.graphql.builder.types.GQLAbstractInputOutputTypesBuilder;
import com.daikit.graphql.data.output.GQLListLoadResult;
import com.daikit.graphql.meta.GQLMetaDataModel;
import com.daikit.graphql.meta.attribute.GQLAbstractAttributeMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeEntityMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeEnumMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeListEntityMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeListEnumMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeListScalarMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeScalarMetaData;
import com.daikit.graphql.meta.custommethod.GQLAbstractMethodMetaData;
import com.daikit.graphql.meta.entity.GQLEntityMetaData;
import com.daikit.graphql.meta.internal.GQLAbstractEntityMetaDataInfos;
import com.daikit.graphql.utils.Assert;
import com.daikit.graphql.utils.Message;
import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class GQLQueryTypeBuilder
extends GQLAbstractInputOutputTypesBuilder {
    public GQLQueryTypeBuilder(GQLSchemaBuilderCache cache) {
        super(cache);
    }

    public GraphQLObjectType buildQueryType(GQLMetaDataModel metaDataModel, DataFetcher<?> getByIdDataFetcher, DataFetcher<GQLListLoadResult> listDataFetcher, DataFetcher<?> customMethodsDataFetcher) {
        this.logger.debug("START building query types...");
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject();
        builder.name("QueryType");
        builder.description("Query type from meta model");
        ArrayList getByIdFieldDefinitions = new ArrayList();
        ArrayList getAllFieldDefinitions = new ArrayList();
        this.logger.debug("Build query types for interfaces...");
        metaDataModel.getNonEmbeddedInterfaces().stream().filter(infos -> infos.getEntity().isReadable()).forEach(infos -> {
            getByIdFieldDefinitions.add(this.buildGetSingleQueryFieldDefinitions((GQLAbstractEntityMetaDataInfos)infos, true));
            getAllFieldDefinitions.add(this.buildGetAllQueryFieldDefinitions((GQLAbstractEntityMetaDataInfos)infos, true));
        });
        this.logger.debug("Build query types for entities...");
        metaDataModel.getNonEmbeddedConcretes().stream().filter(infos -> infos.getEntity().isReadable()).forEach(infos -> {
            getByIdFieldDefinitions.add(this.buildGetSingleQueryFieldDefinitions((GQLAbstractEntityMetaDataInfos)infos, false));
            getAllFieldDefinitions.add(this.buildGetAllQueryFieldDefinitions((GQLAbstractEntityMetaDataInfos)infos, false));
        });
        builder.fields(getByIdFieldDefinitions);
        builder.fields(getAllFieldDefinitions);
        this.logger.debug("Build query types for custom methods...");
        Map<GQLAbstractMethodMetaData, GraphQLFieldDefinition> customMethodFieldDefinitions = new GQLCustomMethodBuilder(this.getCache()).buildMethods(metaDataModel.getCustomMethods().stream().filter(customMethod -> !customMethod.isMutation()).collect(Collectors.toList()));
        builder.fields(new ArrayList<GraphQLFieldDefinition>(customMethodFieldDefinitions.values()));
        GraphQLObjectType queryType = builder.build();
        if (!getByIdFieldDefinitions.isEmpty()) {
            Assert.assertNotNull(getByIdDataFetcher, "If there is at least one entity with an ID property defined then 'getByIdDataFetcher' must be non null", new Object[0]);
            getByIdFieldDefinitions.forEach(fieldDefinition -> this.getCache().getCodeRegistryBuilder().dataFetcher((GraphQLFieldsContainer)queryType, fieldDefinition, getByIdDataFetcher));
        }
        if (!getAllFieldDefinitions.isEmpty()) {
            Assert.assertNotNull(listDataFetcher, "If there is at least one entity defined then 'listDataFetcher' must be non null", new Object[0]);
            getAllFieldDefinitions.forEach(fieldDefinition -> this.getCache().getCodeRegistryBuilder().dataFetcher((GraphQLFieldsContainer)queryType, fieldDefinition, listDataFetcher));
        }
        customMethodFieldDefinitions.entrySet().forEach(entry -> this.getCache().getCodeRegistryBuilder().dataFetcher((GraphQLFieldsContainer)queryType, (GraphQLFieldDefinition)entry.getValue(), customMethodsDataFetcher));
        this.logger.debug("END building query types");
        return queryType;
    }

    private GraphQLFieldDefinition buildGetSingleQueryFieldDefinitions(GQLAbstractEntityMetaDataInfos infos, boolean isInterface) {
        this.logger.debug(Message.format("Build 'getById' query type for " + (isInterface ? "interface" : "entity") + " [{}]", infos.getEntity().getName()));
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
        builder.name("get" + infos.getEntity().getName());
        builder.description((isInterface ? "Interface" : "Entity") + " single result query for [" + infos.getEntity().getName() + "]. This method only accepts the mandatory [id] parameter and returns a single result.");
        builder.type((GraphQLOutputType)(isInterface ? this.getCache().getInterfaceType(infos.getEntity().getEntityClass()) : this.getCache().getEntityType(infos.getEntity().getEntityClass())));
        builder.argument(this.buildArgumentNonNull(this.getIdAttribute(infos)));
        return builder.build();
    }

    private GraphQLFieldDefinition buildGetAllQueryFieldDefinitions(GQLAbstractEntityMetaDataInfos infos, boolean isInterface) {
        this.logger.debug("Build 'getAll' query type for " + (isInterface ? "interface" : "entity") + " [{}]", (Object)infos.getEntity().getName());
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
        builder.name("getAll" + infos.getEntity().getName());
        builder.description((isInterface ? "Interface" : "Entity") + " listing query for [" + infos.getEntity().getName() + "]. This method accepts several filtering arguments and returns a list load result. Give a [" + "paging" + "] argument if you need paging.");
        builder.type((GraphQLOutputType)this.buildListResultWrapperType(infos, isInterface));
        builder.arguments(this.buildListQueryArguments(infos));
        return builder.build();
    }

    private List<GraphQLArgument> buildListQueryArguments(GQLAbstractEntityMetaDataInfos infos) {
        this.logger.debug(Message.format("Build paging query arguments for entity [{}]", infos.getEntity().getName()));
        ArrayList<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
        arguments.add(this.buildQueryFilterArgument(infos));
        arguments.add(this.buildPagingQueryArgument());
        arguments.add(this.buildOrderByQueryArgument());
        return arguments;
    }

    private GraphQLArgument buildPagingQueryArgument() {
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
        builder.name("paging");
        builder.type((GraphQLInputType)this.getCache().getPagingInputObjectType());
        return builder.build();
    }

    private GraphQLArgument buildQueryFilterArgument(GQLAbstractEntityMetaDataInfos infos) {
        this.logger.debug(Message.format("Build filter query argument for entity [{}]", infos.getEntity().getName()));
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
        builder.name("filter");
        builder.description("Query filter argument for [" + infos.getEntity().getName() + "]");
        builder.type((GraphQLInputType)this.buildQueryFilterObjectType(infos));
        GraphQLArgument ret = builder.build();
        return ret;
    }

    private GraphQLArgument buildOrderByQueryArgument() {
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
        builder.name("orderBy");
        builder.type((GraphQLInputType)new GraphQLList((GraphQLType)this.getCache().getOrderByInputObjectType()));
        return builder.build();
    }

    private GraphQLInputObjectType buildQueryFilterObjectType(GQLAbstractEntityMetaDataInfos infos) {
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject();
        builder.name("Filter" + infos.getEntity().getName());
        builder.description("Query filter object type for entity [" + infos.getEntity().getName() + "]");
        GraphQLInputObjectType filterFieldsObjectType = this.buildQueryFilterFieldsObjectType(infos);
        return filterFieldsObjectType;
    }

    private GraphQLInputObjectType buildQueryFilterFieldsObjectType(GQLAbstractEntityMetaDataInfos infos) {
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject();
        builder.name(infos.getEntity().getName() + "Filter");
        builder.description("Query filter fields object type for entity [" + infos.getEntity().getName() + "]");
        ArrayList<GraphQLInputObjectField> objectFields = new ArrayList<GraphQLInputObjectField>();
        GQLBuilderUtils.addOrReplaceInputObjectFields(objectFields, this.buildQueryFilterInputObjectFields(infos.getEntity()));
        builder.fields(objectFields);
        return builder.build();
    }

    private List<GraphQLInputObjectField> buildQueryFilterInputObjectFields(GQLEntityMetaData entity) {
        return entity.getAttributes().stream().filter(attribute -> attribute.isFilterable()).map(attribute -> this.buildQueryFilterInputObjectField((GQLAbstractAttributeMetaData)attribute)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private GraphQLInputObjectField buildQueryFilterInputObjectField(GQLAbstractAttributeMetaData attribute) {
        this.logger.debug(Message.format("Build query filter input object field for attribute [{}]", attribute.getName()));
        GraphQLInputObjectField field = null;
        String name = attribute.getName();
        String description = "Filter [" + attribute.getName() + "]";
        if (attribute instanceof GQLAttributeScalarMetaData) {
            GraphQLInputObjectType scalarType = this.getCache().getInputScalarFilterOperators().get((Object)((GQLAttributeScalarMetaData)attribute).getScalarType());
            if (scalarType != null) {
                field = this.buildInputField(name, description, (GraphQLInputType)scalarType);
            }
        } else if (attribute instanceof GQLAttributeEnumMetaData) {
            field = this.buildInputField(name, description, (GraphQLInputType)this.getCache().getInputEnumFilterOperators().get(((GQLAttributeEnumMetaData)attribute).getEnumClass()));
        } else if (attribute instanceof GQLAttributeEntityMetaData) {
            if (!((GQLAttributeEntityMetaData)attribute).isEmbedded()) {
                field = this.buildInputField(name + "Id", "Filter [id] of [" + attribute.getName() + "]", (GraphQLInputType)Scalars.GraphQLID);
            }
        } else if (attribute instanceof GQLAttributeListEnumMetaData) {
            field = this.buildInputField(name, description, (GraphQLInputType)new GraphQLList((GraphQLType)this.getCache().getEnumType(((GQLAttributeListEnumMetaData)attribute).getEnumClass())));
        } else if (!(attribute instanceof GQLAttributeListEntityMetaData) && !(attribute instanceof GQLAttributeListScalarMetaData)) {
            throw new IllegalArgumentException(Message.format("Attribute could not be mapped to GraphQL [{}]", attribute));
        }
        return field;
    }

    private GraphQLObjectType buildListResultWrapperType(GQLAbstractEntityMetaDataInfos infos, boolean isInterface) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject();
        builder.name(infos.getEntity().getName() + "LoadResult");
        builder.description("Result list wrapper for [" + infos.getEntity().getName() + "]. This object will contain list load result in [" + "data" + "] property and also metadata about the query. (paging, sorting...)");
        GraphQLFieldDefinition.Builder contentBuilder = GraphQLFieldDefinition.newFieldDefinition();
        contentBuilder.name("data");
        contentBuilder.description("The actual results list.");
        contentBuilder.type((GraphQLOutputType)new GraphQLList((GraphQLType)(isInterface ? this.getCache().getInterfaceType(infos.getEntity().getEntityClass()) : this.getCache().getEntityType(infos.getEntity().getEntityClass()))));
        builder.field(contentBuilder.build());
        GraphQLFieldDefinition.Builder orderByBuilder = GraphQLFieldDefinition.newFieldDefinition();
        orderByBuilder.name("orderBy");
        orderByBuilder.description("Sort informations used to sort this query.");
        orderByBuilder.type((GraphQLOutputType)new GraphQLList((GraphQLType)this.getCache().getOrderByOutputObjectType()));
        builder.field(orderByBuilder.build());
        GraphQLFieldDefinition.Builder pagingBuilder = GraphQLFieldDefinition.newFieldDefinition();
        pagingBuilder.name("paging");
        pagingBuilder.description("Paging informations used for this query.");
        pagingBuilder.type(this.getCache().getPagingOutputObjectType());
        builder.field(pagingBuilder.build());
        return builder.build();
    }
}

